/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.common.RootInterface;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.ErrorPage;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.FilterMapping;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.impl.web.WebAppProxy;
import org.netbeans.modules.j2ee.dd.impl.web.WebParseUtils;
import org.netbeans.modules.j2ee.ddloaders.catalog.EnterpriseCatalog;
import org.netbeans.modules.j2ee.ddloaders.multiview.DDMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.DDChangesPanel;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataLoader;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataNode;
import org.netbeans.modules.j2ee.ddloaders.web.DDUtils;
import org.netbeans.modules.j2ee.ddloaders.web.event.DDChangeEvent;
import org.netbeans.modules.j2ee.ddloaders.web.event.DDChangeListener;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.FiltersMultiViewElement;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.OverviewMultiViewElement;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.PagesMultiViewElement;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.ReferencesMultiViewElement;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityMultiViewElement;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.ServletsMultiViewElement;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.xml.multiview.DesignMultiViewDesc;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.OperationAdapter;
import org.openide.loaders.OperationEvent;
import org.openide.loaders.OperationListener;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DDDataObject
extends DDMultiViewDataObject
implements DDChangeListener,
ChangeListener,
PropertyChangeListener {
    private transient WebApp webApp;
    private transient FileObject[] srcRoots;
    protected static final transient RequestProcessor RP = new RequestProcessor("XML Parsing");
    protected boolean changedFromUI;
    private static final long serialVersionUID = 8857563089355069362L;
    public static final String PROP_DOCUMENT_DTD = "documentDTD";
    public static final String HELP_ID_PREFIX_OVERVIEW = "dd_multiview_overview_";
    public static final String HELP_ID_PREFIX_ORDERING = "dd_multiview_ordering_";
    public static final String HELP_ID_PREFIX_SERVLETS = "dd_multiview_servlets_";
    public static final String HELP_ID_PREFIX_FILTERS = "dd_multiview_filters_";
    public static final String HELP_ID_PREFIX_PAGES = "dd_multiview_pages_";
    public static final String HELP_ID_PREFIX_REFERENCES = "dd_multiview_references_";
    public static final String HELP_ID_PREFIX_SECURITY = "dd_multiview_security_";
    private static final Logger LOG = Logger.getLogger(DDMultiViewDataObject.class.getName());
    private String documentDTD;
    private Vector updates;
    private transient RequestProcessor.Task updateTask;
    private OperationListener operationListener = new OperationAdapter(){

        public void operationDelete(OperationEvent operationEvent) {
            FileObject fileObject = operationEvent.getObject().getPrimaryFile();
            String string = DDDataObject.this.getPackageName(fileObject);
            if (string != null && "java".equals(fileObject.getExt()) && DDDataObject.this.getWebApp() != null) {
                boolean bl = false;
                Servlet[] servletArray = DDDataObject.this.getWebApp().getServlet();
                for (int i = 0; i < servletArray.length; ++i) {
                    if (!string.equals(servletArray[i].getServletClass())) continue;
                    DDChangeEvent dDChangeEvent = new DDChangeEvent(DDDataObject.this, DDDataObject.this, null, string, 3);
                    DDDataObject.this.deploymentChange(dDChangeEvent);
                    bl = true;
                    break;
                }
                if (bl) {
                    return;
                }
                Filter[] filterArray = DDDataObject.this.getWebApp().getFilter();
                for (int i = 0; i < filterArray.length; ++i) {
                    if (!string.equals(filterArray[i].getFilterClass())) continue;
                    DDChangeEvent dDChangeEvent = new DDChangeEvent(DDDataObject.this, DDDataObject.this, null, string, 7);
                    DDDataObject.this.deploymentChange(dDChangeEvent);
                    bl = true;
                    break;
                }
                if (bl) {
                    return;
                }
                Listener[] listenerArray = DDDataObject.this.getWebApp().getListener();
                for (int i = 0; i < listenerArray.length; ++i) {
                    if (!string.equals(listenerArray[i].getListenerClass())) continue;
                    DDChangeEvent dDChangeEvent = new DDChangeEvent(DDDataObject.this, DDDataObject.this, null, string, 11);
                    DDDataObject.this.deploymentChange(dDChangeEvent);
                    break;
                }
            }
        }
    };
    public static final String DD_MULTIVIEW_PREFIX = "dd_multiview";
    public static final String MULTIVIEW_OVERVIEW = "Overview";
    public static final String MULTIVIEW_SERVLETS = "Servlets";
    public static final String MULTIVIEW_FILTERS = "Filters";
    public static final String MULTIVIEW_PAGES = "Pages";
    public static final String MULTIVIEW_REFERENCES = "References";
    public static final String MULTIVIEW_SECURITY = "Security";

    public DDDataObject(FileObject fileObject, DDDataLoader dDDataLoader) throws DataObjectExistsException {
        super(fileObject, (MultiFileLoader)dDDataLoader);
        this.init(fileObject, dDDataLoader);
    }

    private void init(FileObject fileObject, DDDataLoader dDDataLoader) {
        InputSource inputSource = DataObjectAdapters.inputSource((DataObject)this);
        CheckXMLSupport checkXMLSupport = new CheckXMLSupport(inputSource);
        this.getCookieSet().add((Node.Cookie)checkXMLSupport);
        ValidateXMLSupport validateXMLSupport = new ValidateXMLSupport(inputSource);
        this.getCookieSet().add((Node.Cookie)validateXMLSupport);
        Project project = FileOwnerQuery.getOwner((FileObject)this.getPrimaryFile());
        if (project != null) {
            Sources sources = ProjectUtils.getSources((Project)project);
            sources.addChangeListener((ChangeListener)this);
            this.refreshSourceFolders(sources);
        }
        this.addPropertyChangeListener(this);
    }

    private void refreshSourceFolders(Sources sources) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            if (WebModule.getWebModule((FileObject)sourceGroupArray[i].getRootFolder()) == null) continue;
            arrayList.add(sourceGroupArray[i].getRootFolder());
            DataLoaderPool.getDefault().removeOperationListener(this.operationListener);
            DataLoaderPool.getDefault().addOperationListener(this.operationListener);
        }
        this.srcRoots = arrayList.toArray(new FileObject[arrayList.size()]);
    }

    private String getPackageName(FileObject fileObject) {
        for (int i = 0; i < this.srcRoots.length; ++i) {
            String string = FileUtil.getRelativePath((FileObject)this.srcRoots[i], (FileObject)fileObject);
            if (string == null) continue;
            if (fileObject.getExt().length() > 0) {
                string = string.substring(0, string.length() - fileObject.getExt().length() - 1);
            }
            return string.replace('/', '.');
        }
        return null;
    }

    public WebApp getWebApp() {
        if (this.webApp == null) {
            try {
                this.webApp = this.createWebApp();
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
            }
        }
        return this.webApp;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("document_valid".equals(propertyChangeEvent.getPropertyName()) && this.isValid()) {
            ((DDDataNode)this.getNodeDelegate()).iconChanged();
        }
    }

    private WebApp createWebApp() throws IOException {
        WebApp webApp = DDProvider.getDefault().getDDRoot(this.getPrimaryFile());
        if (webApp != null) {
            this.setSaxError(webApp.getError());
        }
        return webApp;
    }

    protected Node createNodeDelegate() {
        return new DDDataNode(this);
    }

    public void setReasonableMappings(ServletMapping[] servletMappingArray) {
        ArrayList<ServletMapping> arrayList = new ArrayList<ServletMapping>();
        Servlet[] servletArray = this.webApp.getServlet();
        block0: for (int i = 0; i < servletMappingArray.length; ++i) {
            for (int j = 0; j < servletArray.length; ++j) {
                if (!servletArray[j].getServletName().equals(servletMappingArray[i].getServletName())) continue;
                arrayList.add(servletMappingArray[i]);
                continue block0;
            }
        }
        ServletMapping[] servletMappingArray2 = new ServletMapping[arrayList.size()];
        arrayList.toArray(servletMappingArray2);
        this.webApp.setServletMapping(servletMappingArray2);
    }

    protected void parseDocument() throws IOException {
        block3: {
            if (this.webApp == null || ((WebAppProxy)this.webApp).getOriginal() == null) {
                try {
                    this.webApp = DDProvider.getDefault().getDDRoot(this.getPrimaryFile());
                }
                catch (IOException iOException) {
                    if (this.webApp != null) break block3;
                    this.webApp = new WebAppProxy(null, null);
                }
            }
        }
        this.parseDocument(true);
    }

    protected void validateDocument() throws IOException {
        this.parseDocument(false);
    }

    private void parseDocument(boolean bl) throws IOException {
        WebAppProxy webAppProxy = (WebAppProxy)this.webApp;
        try {
            SAXParseException sAXParseException = WebParseUtils.parse((InputSource)new InputSource(this.createReader()), (EntityResolver)new EnterpriseCatalog());
            this.setSaxError(sAXParseException);
            String string = WebParseUtils.getVersion((InputSource)new InputSource(this.createReader()));
            WebAppProxy webAppProxy2 = new WebAppProxy(org.netbeans.modules.j2ee.dd.impl.common.DDUtils.createWebApp((InputStream)this.createInputStream(), (String)string), string);
            if (bl) {
                if (string.equals(webAppProxy.getVersion()) && webAppProxy.getOriginal() != null) {
                    this.webApp.merge((RootInterface)webAppProxy2, 3);
                } else if (webAppProxy2.getOriginal() != null) {
                    webAppProxy = webAppProxy2;
                    this.webApp = webAppProxy;
                }
            }
            webAppProxy.setStatus(sAXParseException != null ? 1 : 0);
            webAppProxy.setError(sAXParseException);
        }
        catch (SAXException sAXException) {
            webAppProxy.setStatus(2);
            if (sAXException instanceof SAXParseException) {
                webAppProxy.setError((SAXParseException)sAXException);
            } else if (sAXException.getException() instanceof SAXParseException) {
                webAppProxy.setError((SAXParseException)sAXException.getException());
            }
            this.setSaxError(sAXException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            webAppProxy.setStatus(2);
            LOG.log(Level.FINE, "IAE thrown during merge, see #104180.", illegalArgumentException);
        }
    }

    protected RootInterface getDDModel() {
        return this.getWebApp();
    }

    public boolean isDocumentParseable() {
        return 2 != this.getWebApp().getStatus();
    }

    protected String getPrefixMark() {
        return "<web-app";
    }

    private void createDefaultServletConfiguration(String string, String string2) {
        WebApp webApp = this.getWebApp();
        try {
            Servlet servlet = (Servlet)this.webApp.createBean("Servlet");
            servlet.setServletClass(string);
            String string3 = DDUtils.findFreeName((CommonDDBean[])webApp.getServlet(), "ServletName", "Servlet_" + string);
            servlet.setServletName(string3);
            servlet.setDescription(NbBundle.getMessage(DDDataObject.class, (String)"TXT_newServletElementDescription"));
            servlet.setDisplayName("Servlet " + string);
            webApp.addServlet(servlet);
            ServletMapping servletMapping = (ServletMapping)this.webApp.createBean("ServletMapping");
            servletMapping.setServletName(string3);
            servletMapping.setUrlPattern(string2);
            webApp.addServletMapping(servletMapping);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.getLogger("DDDataObject").log(Level.FINE, "ignored exception", classNotFoundException);
        }
    }

    protected DataObject handleCopy(DataFolder dataFolder) throws IOException {
        DataObject dataObject = super.handleCopy(dataFolder);
        try {
            dataObject.setValid(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return dataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        DDDataObject dDDataObject = this;
        synchronized (dDDataObject) {
            this.updates = null;
            if (this.updateTask != null) {
                this.updateTask.cancel();
            }
        }
        super.dispose();
    }

    public String getDocumentDTD() {
        return this.documentDTD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploymentChange(DDChangeEvent dDChangeEvent) {
        if (dDChangeEvent.getType() == 1 && this.servletDefined(dDChangeEvent.getNewValue())) {
            return;
        }
        if (dDChangeEvent.getType() == 11 || dDChangeEvent.getType() == 7 || dDChangeEvent.getType() == 3) {
            return;
        }
        DDDataObject dDDataObject = this;
        synchronized (dDDataObject) {
            if (this.updates == null) {
                this.updates = new Vector();
            }
            this.updates.addElement(dDChangeEvent);
        }
        if (this.updateTask == null) {
            this.updateTask = RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Vector vector = null;
                    DDDataObject dDDataObject = DDDataObject.this;
                    synchronized (dDDataObject) {
                        if (!DDDataObject.this.isValid()) {
                            return;
                        }
                        if (DDDataObject.this.updates != null) {
                            vector = DDDataObject.this.updates;
                            DDDataObject.this.updates = null;
                        }
                    }
                    if (vector != null) {
                        DDDataObject.this.showDDChangesDialog(vector);
                    }
                }
            }, 2000, 1);
        } else {
            this.updateTask.schedule(2000);
        }
    }

    private boolean servletDefined(String string) {
        WebApp webApp = this.getWebApp();
        if (webApp == null) {
            return true;
        }
        Servlet[] servletArray = webApp.getServlet();
        for (int i = 0; i < servletArray.length; ++i) {
            if (servletArray[i].getServletClass() == null || !servletArray[i].getServletClass().equals(string)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showDDChangesDialog(List list) {
        final Dialog[] dialogArray = new Dialog[]{null};
        final JButton jButton = new JButton(NbBundle.getMessage(DDDataObject.class, (String)"LAB_processButton"));
        jButton.setMnemonic(NbBundle.getMessage(DDDataObject.class, (String)"LAB_processButton_Mnemonic").charAt(0));
        jButton.setToolTipText(NbBundle.getMessage(DDDataObject.class, (String)"ACS_processButtonA11yDesc"));
        JButton jButton2 = new JButton(NbBundle.getMessage(DDDataObject.class, (String)"LAB_processAllButton"));
        jButton2.setMnemonic(NbBundle.getMessage(DDDataObject.class, (String)"LAB_processAllButton_Mnemonic").charAt(0));
        jButton2.setToolTipText(NbBundle.getMessage(DDDataObject.class, (String)"ACS_processAllButtonA11yDesc"));
        JButton jButton3 = new JButton(NbBundle.getMessage(DDDataObject.class, (String)"LAB_closeButton"));
        jButton3.setMnemonic(NbBundle.getMessage(DDDataObject.class, (String)"LAB_closeButton_Mnemonic").charAt(0));
        jButton3.setToolTipText(NbBundle.getMessage(DDDataObject.class, (String)"ACS_closeButtonA11yDesc"));
        final Object[] objectArray = new Object[]{jButton, jButton2};
        final Object[] objectArray2 = new Object[]{jButton3};
        WebModule webModule = WebModule.getWebModule((FileObject)this.getPrimaryFile());
        String string = "";
        if (webModule != null) {
            string = webModule.getContextPath();
        }
        String string2 = NbBundle.getMessage(DDDataObject.class, (String)"MSG_SynchronizeCaption", (Object)string);
        final DDChangesPanel dDChangesPanel = new DDChangesPanel(string2, jButton);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)dDChangesPanel, NbBundle.getMessage(DDDataObject.class, (String)"LAB_ConfirmDialog"), true, objectArray, (Object)jButton, 1, HelpCtx.DEFAULT_HELP, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                if (actionEvent.getSource() instanceof Component && !((Component)(object = SwingUtilities.getRoot((Component)actionEvent.getSource()))).isDisplayable()) {
                    return;
                }
                if (objectArray[0].equals(actionEvent.getSource())) {
                    int n;
                    int n2 = dDChangesPanel.changesList.getMinSelectionIndex();
                    for (int i = n = dDChangesPanel.changesList.getMaxSelectionIndex(); i >= n2; --i) {
                        if (!dDChangesPanel.changesList.isSelectedIndex(i)) continue;
                        DDChangeEvent dDChangeEvent = (DDChangeEvent)dDChangesPanel.listModel.getElementAt(i);
                        DDDataObject.this.processDDChangeEvent(dDChangeEvent);
                        dDChangesPanel.listModel.removeElementAt(i);
                    }
                    if (dDChangesPanel.listModel.isEmpty()) {
                        dialogArray[0].setVisible(false);
                    } else {
                        jButton.setEnabled(false);
                    }
                } else if (objectArray[1].equals(actionEvent.getSource())) {
                    object = dDChangesPanel.listModel.elements();
                    while (object.hasMoreElements()) {
                        DDDataObject.this.processDDChangeEvent((DDChangeEvent)object.nextElement());
                    }
                    dialogArray[0].setVisible(false);
                    dDChangesPanel.setChanges(null);
                } else if (objectArray2[0].equals(actionEvent.getSource())) {
                    dialogArray[0].setVisible(false);
                    dDChangesPanel.setChanges(null);
                }
            }
        });
        dialogDescriptor.setAdditionalOptions(objectArray2);
        jButton.setEnabled(false);
        jButton2.requestFocus();
        dDChangesPanel.setChanges(list);
        try {
            dialogArray[0] = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialogArray[0].setVisible(true);
        }
        finally {
            dialogArray[0].dispose();
        }
    }

    private void processDDChangeEvent(DDChangeEvent dDChangeEvent) {
        String string;
        if (!this.isValid()) {
            return;
        }
        if (dDChangeEvent.getType() == 1) {
            string = dDChangeEvent.getNewValue();
            String string2 = "/servlet/" + string;
            this.createDefaultServletConfiguration(string, string2);
        } else if (dDChangeEvent.getType() == 2) {
            string = dDChangeEvent.getOldValue();
            if (string == null) {
                return;
            }
            Servlet[] servletArray = this.getWebApp().getServlet();
            for (int i = 0; i < servletArray.length; ++i) {
                if (!string.equals(servletArray[i].getServletClass())) continue;
                servletArray[i].setServletClass(dDChangeEvent.getNewValue());
            }
        } else if (dDChangeEvent.getType() == 3) {
            string = dDChangeEvent.getNewValue();
            if (string == null) {
                return;
            }
            WebApp webApp = this.getWebApp();
            Servlet[] servletArray = webApp.getServlet();
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < servletArray.length; ++i) {
                if (!string.equals(servletArray[i].getServletClass())) continue;
                vector.addElement(servletArray[i].getServletName());
                webApp.removeServlet(servletArray[i]);
            }
            ServletMapping[] servletMappingArray = webApp.getServletMapping();
            for (int i = 0; i < servletMappingArray.length; ++i) {
                if (!vector.contains(servletMappingArray[i].getServletName())) continue;
                webApp.removeServletMapping(servletMappingArray[i]);
            }
        } else if (dDChangeEvent.getType() == 6) {
            string = dDChangeEvent.getOldValue();
            if (string == null) {
                return;
            }
            Filter[] filterArray = this.getWebApp().getFilter();
            for (int i = 0; i < filterArray.length; ++i) {
                if (!string.equals(filterArray[i].getFilterClass())) continue;
                filterArray[i].setFilterClass(dDChangeEvent.getNewValue());
            }
        } else if (dDChangeEvent.getType() == 7) {
            string = dDChangeEvent.getNewValue();
            if (string == null) {
                return;
            }
            WebApp webApp = this.getWebApp();
            Filter[] filterArray = webApp.getFilter();
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < filterArray.length; ++i) {
                if (!string.equals(filterArray[i].getFilterClass())) continue;
                vector.addElement(filterArray[i].getFilterName());
                webApp.removeFilter(filterArray[i]);
            }
            FilterMapping[] filterMappingArray = webApp.getFilterMapping();
            for (int i = 0; i < filterMappingArray.length; ++i) {
                if (!vector.contains(filterMappingArray[i].getFilterName())) continue;
                webApp.removeFilterMapping(filterMappingArray[i]);
            }
        } else if (dDChangeEvent.getType() == 10) {
            string = dDChangeEvent.getOldValue();
            if (string == null) {
                return;
            }
            Listener[] listenerArray = this.getWebApp().getListener();
            for (int i = 0; i < listenerArray.length; ++i) {
                if (!string.equals(listenerArray[i].getListenerClass())) continue;
                listenerArray[i].setListenerClass(dDChangeEvent.getNewValue());
            }
        } else if (dDChangeEvent.getType() == 11) {
            string = dDChangeEvent.getNewValue();
            if (string == null) {
                return;
            }
            WebApp webApp = this.getWebApp();
            Listener[] listenerArray = webApp.getListener();
            for (int i = 0; i < listenerArray.length; ++i) {
                if (!string.equals(listenerArray[i].getListenerClass())) continue;
                webApp.removeListener(listenerArray[i]);
                break;
            }
        }
        try {
            this.writeModel((RootInterface)this.getWebApp());
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.refreshSourceFolders((Sources)changeEvent.getSource());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("dd_multiview_overview_overviewNode");
    }

    protected boolean isModelCreated() {
        return this.webApp != null && ((WebAppProxy)this.webApp).getOriginal() != null;
    }

    protected DesignMultiViewDesc[] getMultiViewDesc() {
        return new DesignMultiViewDesc[]{new DDView(this, MULTIVIEW_OVERVIEW), new DDView(this, MULTIVIEW_SERVLETS), new DDView(this, MULTIVIEW_FILTERS), new DDView(this, MULTIVIEW_PAGES), new DDView(this, MULTIVIEW_REFERENCES), new DDView(this, MULTIVIEW_SECURITY)};
    }

    public void showElement(Object object) {
        Object object2;
        Object object3 = null;
        if (object instanceof Servlet) {
            this.openView(1);
            object3 = object;
        } else if (object instanceof Filter) {
            this.openView(2);
            object3 = object;
        } else if (object instanceof Listener) {
            this.openView(0);
            object3 = "listeners";
        } else if (object instanceof InitParam) {
            object2 = (InitParam)object;
            InitParam[] initParamArray = this.getWebApp().getContextParam();
            for (int i = 0; i < initParamArray.length; ++i) {
                if (initParamArray[i] != object2) continue;
                this.openView(0);
                object3 = "context_params";
                break;
            }
        } else if (object instanceof ErrorPage) {
            this.openView(3);
            object3 = "error_pages";
        }
        if (object3 != null) {
            object2 = object3;
            Utils.runInAwtDispatchThread((Runnable)new Runnable(){

                public void run() {
                    ToolBarMultiViewElement toolBarMultiViewElement = DDDataObject.this.getActiveMVElement();
                    if (toolBarMultiViewElement != null) {
                        toolBarMultiViewElement.getSectionView().openPanel(object2);
                    }
                }
            });
        }
    }

    public boolean isDeleteAllowed() {
        String string = this.getWebApp().getVersion();
        if (string == null) {
            return true;
        }
        BigDecimal bigDecimal = new BigDecimal(string);
        return bigDecimal.compareTo(new BigDecimal("2.5")) >= 0;
    }

    public ToolBarMultiViewElement getActiveMVElement() {
        return (ToolBarMultiViewElement)super.getActiveMultiViewElement();
    }

    public boolean isChangedFromUI() {
        return this.changedFromUI;
    }

    public void setChangedFromUI(boolean bl) {
        this.changedFromUI = bl;
    }

    static class DDView
    extends DesignMultiViewDesc
    implements Serializable {
        private static final long serialVersionUID = -4814134594154669985L;
        private String name;

        DDView() {
        }

        DDView(DDDataObject dDDataObject, String string) {
            super((XmlMultiViewDataObject)dDDataObject, string);
            this.name = string;
        }

        public MultiViewElement createElement() {
            DDDataObject dDDataObject = (DDDataObject)this.getDataObject();
            if (this.name.equals(DDDataObject.MULTIVIEW_OVERVIEW)) {
                return new OverviewMultiViewElement(dDDataObject, 0);
            }
            if (this.name.equals(DDDataObject.MULTIVIEW_SERVLETS)) {
                return new ServletsMultiViewElement(dDDataObject, 1);
            }
            if (this.name.equals(DDDataObject.MULTIVIEW_FILTERS)) {
                return new FiltersMultiViewElement(dDDataObject, 2);
            }
            if (this.name.equals(DDDataObject.MULTIVIEW_PAGES)) {
                return new PagesMultiViewElement(dDDataObject, 3);
            }
            if (this.name.equals(DDDataObject.MULTIVIEW_REFERENCES)) {
                return new ReferencesMultiViewElement(dDDataObject, 4);
            }
            if (this.name.equals(DDDataObject.MULTIVIEW_SECURITY)) {
                return new SecurityMultiViewElement(dDDataObject, 5);
            }
            return null;
        }

        public HelpCtx getHelpCtx() {
            if (this.name.equals(DDDataObject.MULTIVIEW_OVERVIEW)) {
                return new HelpCtx("dd_multiview_overview_overviewNode");
            }
            if (this.name.equals(DDDataObject.MULTIVIEW_SERVLETS)) {
                return new HelpCtx("dd_multiview_servlets_servletsNode");
            }
            if (this.name.equals(DDDataObject.MULTIVIEW_FILTERS)) {
                return new HelpCtx("dd_multiview_filters_filtersNode");
            }
            if (this.name.equals(DDDataObject.MULTIVIEW_PAGES)) {
                return new HelpCtx("dd_multiview_overview_overviewNode");
            }
            if (this.name.equals(DDDataObject.MULTIVIEW_REFERENCES)) {
                return new HelpCtx("dd_multiview_references_references");
            }
            return null;
        }

        public Image getIcon() {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/ddloaders/web/resources/DDDataIcon.gif");
        }

        public String preferredID() {
            return DDDataObject.DD_MULTIVIEW_PREFIX + this.name;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(DDDataObject.class, (String)("TTL_" + this.name));
        }
    }
}

