/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli.commands;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.subversion.client.cli.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListPropertiesCommand
extends SvnCommand {
    private List<String> output = new ArrayList<String>();
    private final File file;
    private final boolean rec;
    private final SVNUrl url;
    private final ListType type;

    public ListPropertiesCommand(File file, boolean bl) {
        this.file = file;
        this.rec = bl;
        this.url = null;
        this.type = ListType.file;
    }

    public ListPropertiesCommand(SVNUrl sVNUrl, boolean bl) {
        this.url = sVNUrl;
        this.rec = bl;
        this.file = null;
        this.type = ListType.url;
    }

    @Override
    protected boolean notifyOutput() {
        return false;
    }

    @Override
    protected int getCommand() {
        return 21;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("proplist");
        if (this.rec) {
            arguments.add("-R");
        }
        switch (this.type) {
            case file: {
                arguments.add(this.file);
                break;
            }
            case url: {
                arguments.add(this.url);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal gettype: " + (Object)((Object)this.type));
            }
        }
    }

    @Override
    public void outputText(String string) {
        if (string == null || string.trim().equals("") || string.startsWith("Properties on '")) {
            return;
        }
        this.output.add(string.trim());
    }

    public List<String> getPropertyNames() throws SVNClientException {
        return this.output;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ListType {
        url,
        file;

    }
}

