/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.web.metadata;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.common.EnvEntry;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceEnvRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRef;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.web.AbsoluteOrdering;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.RelativeOrdering;
import org.netbeans.modules.j2ee.dd.api.web.RelativeOrderingItems;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WebAppMetadata;
import org.netbeans.modules.j2ee.dd.api.web.WebFragment;
import org.netbeans.modules.j2ee.dd.api.web.WebFragmentProvider;
import org.netbeans.modules.j2ee.dd.api.web.model.FilterInfo;
import org.netbeans.modules.j2ee.dd.api.web.model.ServletInfo;
import org.netbeans.modules.j2ee.dd.impl.web.annotation.AnnotationHelpers;
import org.netbeans.modules.j2ee.dd.impl.web.metadata.MergeEngine;
import org.netbeans.modules.j2ee.dd.impl.web.metadata.MergeEngines;
import org.netbeans.modules.j2ee.dd.impl.web.metadata.WebAppMetadataModelImpl;
import org.netbeans.modules.j2ee.dd.spi.MetadataUnit;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppMetadataImpl
implements WebAppMetadata {
    private static final Logger LOG = Logger.getLogger(WebAppMetadataImpl.class.getName());
    private WebAppMetadataModelImpl modelImpl;
    private AnnotationHelpers annoHelpers;
    private MetadataUnit metadataUnit;
    private WebApp webXml;
    private long webXmlLastModification = -1L;
    private Map<FileObject, FragmentRec> myRootToFragment = new HashMap<FileObject, FragmentRec>();
    private static final int OTHERS = -1;
    private static final int NOT_FOUND = -2;

    public WebAppMetadataImpl(MetadataUnit metadataUnit, WebAppMetadataModelImpl webAppMetadataModelImpl) {
        this.metadataUnit = metadataUnit;
        this.modelImpl = webAppMetadataModelImpl;
        this.refreshWebXml();
        this.collectFragments();
        this.registerListener();
    }

    @Override
    public WebApp getRoot() {
        this.refreshWebXml();
        return this.webXml;
    }

    @Override
    public List<WebFragment> getFragments() {
        ArrayList<WebFragment> arrayList = new ArrayList<WebFragment>();
        for (FragmentRec fragmentRec : this.myRootToFragment.values()) {
            arrayList.add(fragmentRec.fragment);
        }
        return WebAppMetadataImpl.sortFragments(this.webXml, arrayList);
    }

    @Override
    public List<FileObject> getFragmentFiles() {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (FragmentRec fragmentRec : this.myRootToFragment.values()) {
            arrayList.add(fragmentRec.source);
        }
        return arrayList;
    }

    @Override
    public List<ServletInfo> getServlets() {
        return this.doMerging(MergeEngines.servletsEngine());
    }

    @Override
    public List<FilterInfo> getFilters() {
        return this.doMerging(MergeEngines.filtersEngine());
    }

    @Override
    public List<String> getSecurityRoles() {
        return this.doMerging(MergeEngines.securityRolesEngine());
    }

    @Override
    public List<ResourceRef> getResourceRefs() {
        return this.doMerging(MergeEngines.resourceRefsEngine());
    }

    @Override
    public List<ResourceEnvRef> getResourceEnvRefs() {
        return this.doMerging(MergeEngines.resourceEnvRefsEngine());
    }

    @Override
    public List<EnvEntry> getEnvEntries() {
        return this.doMerging(MergeEngines.resourceEnvEntriesEngine());
    }

    @Override
    public List<MessageDestinationRef> getMessageDestinationRefs() {
        return this.doMerging(MergeEngines.resourceMsgDestsEngine());
    }

    @Override
    public List<ServiceRef> getServiceRefs() {
        return this.doMerging(MergeEngines.resourceServicesEngine());
    }

    @Override
    public List<EjbLocalRef> getEjbLocalRefs() {
        return this.doMerging(MergeEngines.ejbLocalRefsEngine());
    }

    @Override
    public List<EjbRef> getEjbRefs() {
        return this.doMerging(MergeEngines.ejbRefsEngine());
    }

    private <T> List<T> doMerging(MergeEngine<T> mergeEngine) {
        mergeEngine.clean();
        this.refreshWebXml();
        if (this.webXml != null) {
            boolean bl;
            mergeEngine.addItems(this.webXml);
            try {
                bl = this.webXml.isMetadataComplete();
            }
            catch (VersionNotSupportedException versionNotSupportedException) {
                bl = true;
            }
            if (bl) {
                return mergeEngine.getResult();
            }
        }
        for (WebFragment webFragment : this.getFragments()) {
            mergeEngine.addItems(webFragment);
        }
        mergeEngine.addAnnotations(this.getAnnotationHelpers());
        return mergeEngine.getResult();
    }

    private void refreshWebXml() {
        FileObject fileObject = this.metadataUnit.getDeploymentDescriptor();
        if (fileObject == null) {
            this.webXml = null;
            this.webXmlLastModification = -1L;
            return;
        }
        fileObject.refresh();
        long l = fileObject.lastModified().getTime();
        if (l > this.webXmlLastModification) {
            try {
                this.webXml = DDProvider.getDefault().getDDRoot(fileObject, true);
                this.webXmlLastModification = l;
            }
            catch (IOException iOException) {
                LOG.log(Level.SEVERE, "Error during web.xml parsing!", iOException);
                this.webXml = null;
            }
        }
    }

    private void registerListener() {
        this.metadataUnit.getCompilePath().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!propertyChangeEvent.getPropertyName().equals("entries")) {
                    return;
                }
                try {
                    WebAppMetadataImpl.this.modelImpl.runReadAction(new MetadataModelAction<WebAppMetadata, Void>(){

                        public Void run(WebAppMetadata webAppMetadata) {
                            FileObject[] fileObjectArray = WebAppMetadataImpl.this.metadataUnit.getCompilePath().getRoots();
                            HashSet<FileObject> hashSet = new HashSet<FileObject>(Arrays.asList(fileObjectArray));
                            HashSet hashSet2 = new HashSet(WebAppMetadataImpl.this.myRootToFragment.keySet());
                            HashSet<FileObject> hashSet3 = new HashSet<FileObject>(hashSet);
                            hashSet3.retainAll(hashSet2);
                            hashSet2.removeAll(hashSet);
                            for (FileObject fileObject : hashSet2) {
                                WebAppMetadataImpl.this.myRootToFragment.remove(fileObject);
                            }
                            hashSet.remove(hashSet3);
                            for (FileObject fileObject : hashSet) {
                                WebAppMetadataImpl.this.addFragmentRec(fileObject);
                            }
                            return null;
                        }
                    });
                }
                catch (Exception exception) {
                    LOG.log(Level.SEVERE, "Error during access to compile path", exception);
                }
            }
        });
    }

    private void collectFragments() {
        FileObject[] fileObjectArray;
        for (FileObject fileObject : fileObjectArray = this.metadataUnit.getCompilePath().getRoots()) {
            this.addFragmentRec(fileObject);
        }
    }

    private void addFragmentRec(FileObject fileObject) {
        FileObject fileObject2 = fileObject.getFileObject("META-INF/web-fragment.xml");
        if (fileObject2 == null) {
            return;
        }
        fileObject2.refresh();
        try {
            FragmentRec fragmentRec = new FragmentRec();
            fragmentRec.source = fileObject2;
            fragmentRec.fragment = WebFragmentProvider.getDefault().getWebFragmentRoot(fileObject2);
            this.myRootToFragment.put(fileObject, fragmentRec);
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "Error during web-fragment.xml parsing! File: " + fileObject2, exception);
        }
    }

    private FragmentRec findFragmentRec(FileObject fileObject) {
        for (FragmentRec fragmentRec : this.myRootToFragment.values()) {
            try {
                if (!fragmentRec.source.getURL().equals(fileObject.getURL())) continue;
                return fragmentRec;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                fileStateInvalidException.printStackTrace();
            }
        }
        return null;
    }

    private AnnotationHelpers getAnnotationHelpers() {
        if (this.annoHelpers == null) {
            this.annoHelpers = new AnnotationHelpers(this.modelImpl.getHelper());
        }
        return this.annoHelpers;
    }

    static List<WebFragment> sortFragments(WebApp webApp, List<WebFragment> list) {
        assert (list != null);
        AbsoluteOrdering[] absoluteOrderingArray = null;
        try {
            if (webApp != null) {
                absoluteOrderingArray = webApp.getAbsoluteOrdering();
            }
        }
        catch (VersionNotSupportedException versionNotSupportedException) {
            // empty catch block
        }
        return absoluteOrderingArray == null ? WebAppMetadataImpl.sortFragmentsRelatively(list) : WebAppMetadataImpl.sortFragmentsAbsolutely(webApp, list);
    }

    private static List<WebFragment> sortFragmentsRelatively(List<WebFragment> list) {
        List<Constraint> list2 = WebAppMetadataImpl.extractConstraints(list);
        List<Integer> list3 = WebAppMetadataImpl.extractOthers(list, list2);
        List<Integer> list4 = WebAppMetadataImpl.sort(list2);
        ArrayList<WebFragment> arrayList = new ArrayList<WebFragment>();
        for (int n : list4) {
            if (n == -1) {
                for (int n2 : list3) {
                    arrayList.add(list.get(n2));
                }
                continue;
            }
            arrayList.add(list.get(n));
        }
        return arrayList;
    }

    private static List<Constraint> extractConstraints(List<WebFragment> list) {
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
        int n = -1;
        for (WebFragment webFragment : list) {
            ++n;
            RelativeOrdering[] relativeOrderingArray = webFragment.getOrdering();
            if (relativeOrderingArray == null) continue;
            for (RelativeOrdering relativeOrdering : relativeOrderingArray) {
                RelativeOrderingItems relativeOrderingItems;
                int n2;
                int n3;
                RelativeOrderingItems relativeOrderingItems2 = relativeOrdering.getAfter();
                if (relativeOrderingItems2 != null) {
                    n3 = relativeOrderingItems2.sizeName();
                    for (int i = 0; i < n3; ++i) {
                        n2 = WebAppMetadataImpl.findFragment(list, relativeOrderingItems2.getName(i));
                        if (n2 == -2) continue;
                        arrayList.add(new Constraint(n2, n));
                    }
                    if (relativeOrderingItems2.getOthers() != null) {
                        arrayList.add(new Constraint(-1, n));
                    }
                }
                if ((relativeOrderingItems = relativeOrdering.getBefore()) == null) continue;
                n2 = relativeOrderingItems.sizeName();
                for (n3 = 0; n3 < n2; ++n3) {
                    int n4 = WebAppMetadataImpl.findFragment(list, relativeOrderingItems.getName(n3));
                    if (n4 == -2) continue;
                    arrayList.add(new Constraint(n, n4));
                }
                if (relativeOrderingItems.getOthers() == null) continue;
                arrayList.add(new Constraint(n, -1));
            }
        }
        return arrayList;
    }

    private static List<Integer> extractOthers(List<WebFragment> list, List<Constraint> list2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            boolean bl = false;
            for (Constraint constraint : list2) {
                if (!constraint.references(i)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    private static List<Integer> sort(List<Constraint> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (!list.isEmpty()) {
            int n = -1;
            Constraint constraint = null;
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                constraint = list.get(i);
                if (!WebAppMetadataImpl.isReady(list, constraint.op1, i)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return null;
            }
            list.remove(n);
            if (!arrayList.contains(constraint.op1)) {
                arrayList.add(constraint.op1);
            }
            if (WebAppMetadataImpl.isReferenced(list, constraint.op2)) continue;
            arrayList.add(constraint.op2);
        }
        return arrayList;
    }

    private static boolean isReady(List<Constraint> list, int n, int n2) {
        int n3 = list.size();
        for (int i = 0; i < n3; ++i) {
            if (i == n2) continue;
            Constraint constraint = list.get(i);
            if (constraint.op2 != n) continue;
            return false;
        }
        return true;
    }

    private static boolean isReferenced(List<Constraint> list, int n) {
        for (Constraint constraint : list) {
            if (constraint.op1 != n && constraint.op2 != n) continue;
            return true;
        }
        return false;
    }

    private static int findFragment(List<WebFragment> list, String string) {
        int n = -1;
        for (WebFragment webFragment : list) {
            ++n;
            try {
                String[] stringArray = webFragment.getName();
                if (stringArray == null) continue;
                for (String string2 : stringArray) {
                    if (!string2.equals(string)) continue;
                    return n;
                }
            }
            catch (VersionNotSupportedException versionNotSupportedException) {
            }
        }
        return -2;
    }

    private static List<WebFragment> sortFragmentsAbsolutely(WebApp webApp, List<WebFragment> list) {
        assert (webApp != null);
        AbsoluteOrdering[] absoluteOrderingArray = null;
        try {
            absoluteOrderingArray = webApp.getAbsoluteOrdering();
        }
        catch (VersionNotSupportedException versionNotSupportedException) {
            LOG.log(Level.SEVERE, "sortFragmentsAbsolutely failed", versionNotSupportedException);
            return null;
        }
        assert (absoluteOrderingArray != null);
        List<Integer> list2 = new ArrayList<Integer>();
        for (AbsoluteOrdering absoluteOrdering : absoluteOrderingArray) {
            WebAppMetadataImpl.addFragmentsIntoResult(list2, list, absoluteOrdering.getName());
        }
        list2 = WebAppMetadataImpl.insertOthers(list2, list);
        ArrayList arrayList = new ArrayList();
        for (int n : list2) {
            arrayList.add(list.get(n));
        }
        return arrayList;
    }

    private static void addFragmentsIntoResult(List<Integer> list, List<WebFragment> list2, String[] stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (string.equals("<others>")) {
                    list.add(-1);
                    continue;
                }
                int n = WebAppMetadataImpl.findFragment(list2, string);
                if (n == -2) continue;
                list.add(n);
            }
        }
    }

    private static List<Integer> insertOthers(List<Integer> list, List<WebFragment> list2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = list2.size();
        for (int i = 0; i < n; ++i) {
            if (list.contains(i)) continue;
            arrayList.add(i);
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int n2 : list) {
            if (n2 == -1) {
                arrayList2.addAll(arrayList);
                continue;
            }
            arrayList2.add(n2);
        }
        return arrayList2;
    }

    private static class Constraint {
        int op1;
        int op2;

        Constraint(int n, int n2) {
            this.op1 = n;
            this.op2 = n2;
        }

        boolean references(int n) {
            return this.op1 == n || this.op2 == n;
        }
    }

    private static class FragmentRec {
        WebFragment fragment;
        FileObject source;

        private FragmentRec() {
        }
    }
}

