/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.project;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Enumeration;
import javax.swing.DefaultButtonModel;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.KenaiPopupMenu;
import org.netbeans.modules.kenai.ui.ProjectHandleImpl;
import org.netbeans.modules.kenai.ui.dashboard.DashboardImpl;
import org.netbeans.modules.kenai.ui.project.RefreshableContentPanel;
import org.netbeans.modules.kenai.ui.project.SourcesInformationPanel;
import org.netbeans.modules.kenai.ui.project.kenaiProjectTopComponent;
import org.netbeans.modules.kenai.ui.spi.KenaiIssueAccessor;
import org.netbeans.modules.kenai.ui.spi.QueryAccessor;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class IssuesInformationPanel
extends JPanel
implements RefreshableContentPanel {
    private final String WAIT_STRING = String.format("<html><table cellpadding=\"0\" border=\"0\" cellspacing=\"0\"><tr><td width=\"30\"><img src=\"%s\"></td><td>%s</td></tr></table></html>", SourcesInformationPanel.class.getResource("/org/netbeans/modules/kenai/ui/resources/wait.gif"), NbBundle.getMessage(SourcesInformationPanel.class, (String)"MSG_WAIT_ISSUES"));
    private KenaiProject instPr = null;
    private JEditorPane issuesInfoPane;

    public IssuesInformationPanel(KenaiProject kenaiProject) {
        this.initComponents();
        this.instPr = kenaiProject;
        this.issuesInfoPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    IssuesInformationPanel.this.issuesInfoPane.setToolTipText(hyperlinkEvent.getDescription());
                    IssuesInformationPanel.this.issuesInfoPane.setCursor(Cursor.getPredefinedCursor(12));
                    return;
                }
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    IssuesInformationPanel.this.issuesInfoPane.setToolTipText("");
                    IssuesInformationPanel.this.issuesInfoPane.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (hyperlinkEvent.getDescription().startsWith("issue:")) {
                        final String string = hyperlinkEvent.getDescription().substring(6);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                KenaiIssueAccessor.getDefault().open(IssuesInformationPanel.this.instPr, string);
                            }
                        });
                        return;
                    }
                    HtmlBrowser.URLDisplayer.getDefault().showURL(hyperlinkEvent.getURL());
                    return;
                }
            }
        });
    }

    private void registerHTMLButton(HTMLDocument hTMLDocument, String string, ActionListener actionListener) {
        Element element = hTMLDocument.getElement(string);
        if (element != null) {
            AttributeSet attributeSet = element.getAttributes();
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                Object object = attributeSet.getAttribute(obj);
                if (!"model".equals(obj.toString())) continue;
                DefaultButtonModel defaultButtonModel = (DefaultButtonModel)object;
                defaultButtonModel.setActionCommand(string);
                defaultButtonModel.addActionListener(actionListener);
            }
        }
    }

    private String getRecentIssuesTable(KenaiProject kenaiProject) {
        KenaiIssueAccessor.IssueHandle[] issueHandleArray = KenaiIssueAccessor.getDefault().getRecentIssues(kenaiProject);
        if (issueHandleArray == null || issueHandleArray.length == 0) {
            return "";
        }
        String string = String.format("<br><h4>%s</h4><table>", NbBundle.getMessage(IssuesInformationPanel.class, (String)"MSG_RECENTLY_OPENED"));
        for (int i = 0; i < issueHandleArray.length; ++i) {
            KenaiIssueAccessor.IssueHandle issueHandle = issueHandleArray[i];
            string = string + String.format("<tr><td><a href=\"issue:%s\">%s</a></td><td>%s</td></tr>", issueHandle.getID(), issueHandle.getID(), issueHandle.getDisplayName());
        }
        string = string + "</table>";
        return string;
    }

    private String buildIssueInformation(KenaiProject kenaiProject) throws KenaiException {
        String string = String.format("<html><div class=\"section\"><h2>%s</h2>", NbBundle.getMessage(IssuesInformationPanel.class, (String)"MSG_PROJECT_ISSUES"));
        KenaiFeature[] kenaiFeatureArray = kenaiProject.getFeatures(KenaiService.Type.ISSUES);
        if (kenaiFeatureArray.length > 0) {
            if (Thread.interrupted()) {
                return this.WAIT_STRING;
            }
            KenaiFeature kenaiFeature = kenaiFeatureArray[0];
            String string2 = "external.png";
            if (kenaiFeature.getService().equals("bugzilla")) {
                string2 = "bugzilla-logo.png";
            } else if (kenaiFeature.getService().equals("jira")) {
                string2 = "jira-logo.png";
            }
            if (Thread.interrupted()) {
                return this.WAIT_STRING;
            }
            string = string + String.format("<table cellpadding=\"0\" border=\"0\" cellspacing=\"0\"><tr><td><img src=\"%s\"></td><td width=\"10px\"></td><td><h3>%s</h3></td></tr></table><br>", IssuesInformationPanel.class.getResource("/org/netbeans/modules/kenai/ui/resources/" + string2), kenaiFeature.getDisplayName() + (string2.equals("external.png") ? " <i>(" + NbBundle.getMessage(IssuesInformationPanel.class, (String)"MSG_UNKNOWN_IT") + ")</i>" : ""));
            if (Thread.interrupted()) {
                return this.WAIT_STRING;
            }
            if (kenaiFeature.getService().equals("bugzilla") || kenaiFeature.getService().equals("jira")) {
                string = string + String.format("<h4>%s</h4>", NbBundle.getMessage(IssuesInformationPanel.class, (String)"MSG_DID_YOU_FIND_ISSUE"));
                string = string + "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td>";
                string = string + String.format("<input id=\"find\" type=\"reset\" value=\"%s\"><br>", NbBundle.getMessage(IssuesInformationPanel.class, (String)"MSG_FIND_ISSUE"));
                string = string + "</td></tr><tr><td>";
                string = string + String.format("<input id=\"enter\" type=\"reset\" value=\"%s\"><br>", NbBundle.getMessage(IssuesInformationPanel.class, (String)"MSG_NEW_REPORT"));
                string = string + "</td></tr></table><br>";
            }
            string = string + String.format("%s:<br><p>&nbsp;&nbsp;&nbsp;&nbsp;%s&nbsp;<a href=\"%s\">%s</a></p>", NbBundle.getMessage(IssuesInformationPanel.class, (String)"MSG_ISSUE_TRACKER_ONLINE"), kenaiProjectTopComponent.linkImageHTML, kenaiFeature.getWebLocation(), kenaiFeature.getWebLocation());
            string = string + this.getRecentIssuesTable(kenaiProject);
        } else {
            string = string + String.format("<i>%s</i>", NbBundle.getMessage(IssuesInformationPanel.class, (String)"MSG_NO_ISSUE_TRACKERS"));
        }
        string = string + "</div></html>";
        return string;
    }

    private void initComponents() {
        this.issuesInfoPane = new JEditorPane();
        this.setBackground(new Color(255, 255, 255));
        this.setPreferredSize(new Dimension(0, 800));
        this.setLayout(new BorderLayout());
        this.issuesInfoPane.setContentType(NbBundle.getMessage(IssuesInformationPanel.class, (String)"IssuesInformationPanel.issuesInfoPane.contentType"));
        this.issuesInfoPane.setEditable(false);
        this.issuesInfoPane.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                IssuesInformationPanel.this.issuesInfoPaneFocusGained(focusEvent);
            }
        });
        this.add((Component)this.issuesInfoPane, "Center");
    }

    private void issuesInfoPaneFocusGained(FocusEvent focusEvent) {
        this.issuesInfoPane.getCaret().setVisible(false);
    }

    public void resetContent(final KenaiProject kenaiProject) {
        Font font = UIManager.getFont("Label.font");
        String string = "body { background-color: white; font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; padding: 10px;}";
        StyleSheet styleSheet = ((HTMLDocument)this.issuesInfoPane.getDocument()).getStyleSheet();
        styleSheet.addRule(string);
        styleSheet.addRule("div.section {margin-bottom: 10px;}");
        styleSheet.addRule("i {color: gray}");
        styleSheet.addRule("h2 {color: rgb(0,22,103)}; font-size: 18pt");
        styleSheet.addRule("h3 {font-size: 15pt");
        styleSheet.addRule("h4 {font-size: 12pt");
        try {
            final String string2 = this.buildIssueInformation(kenaiProject);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    HTMLDocument hTMLDocument = (HTMLDocument)IssuesInformationPanel.this.issuesInfoPane.getDocument();
                    IssuesInformationPanel.this.issuesInfoPane.setText(string2);
                    IssuesInformationPanel.this.issuesInfoPane.validate();
                    IssuesInformationPanel.this.issuesInfoPane.setCaretPosition(0);
                    IssuesInformationPanel.this.registerHTMLButton(hTMLDocument, "enter", new ActionListener(){

                        public void actionPerformed(final ActionEvent actionEvent) {
                            final ProjectHandleImpl projectHandleImpl = new ProjectHandleImpl(kenaiProject);
                            DashboardImpl.getInstance().addProject(projectHandleImpl, false, false);
                            RequestProcessor.getDefault().post(new Runnable(){

                                public void run() {
                                    ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(KenaiPopupMenu.class, (String)"CONTACTING_ISSUE_TRACKER"));
                                    progressHandle.start();
                                    QueryAccessor.getDefault().getCreateIssueAction(projectHandleImpl).actionPerformed(actionEvent);
                                    progressHandle.finish();
                                }
                            });
                        }
                    });
                    IssuesInformationPanel.this.registerHTMLButton(hTMLDocument, "find", new ActionListener(){

                        public void actionPerformed(final ActionEvent actionEvent) {
                            try {
                                if (kenaiProject.getFeatures(KenaiService.Type.ISSUES).length > 0) {
                                    final ProjectHandleImpl projectHandleImpl = new ProjectHandleImpl(kenaiProject);
                                    DashboardImpl.getInstance().addProject(projectHandleImpl, false, false);
                                    RequestProcessor.getDefault().post(new Runnable(){

                                        public void run() {
                                            ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(KenaiPopupMenu.class, (String)"CONTACTING_ISSUE_TRACKER"));
                                            progressHandle.start();
                                            QueryAccessor.getDefault().getFindIssueAction(projectHandleImpl).actionPerformed(actionEvent);
                                            progressHandle.finish();
                                        }
                                    });
                                }
                            }
                            catch (KenaiException kenaiException) {
                                Exceptions.printStackTrace((Throwable)kenaiException);
                            }
                        }
                    });
                }
            });
        }
        catch (KenaiException kenaiException) {
            Exceptions.printStackTrace((Throwable)kenaiException);
        }
    }

    public void clearContent() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IssuesInformationPanel.this.issuesInfoPane.setText(IssuesInformationPanel.this.WAIT_STRING);
            }
        });
    }
}

