/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class ManualMethodSelect
extends JPanel
implements HelpCtx.Provider {
    private static final String SELECT_METHODS_DIALOG_CAPTION = NbBundle.getMessage(ManualMethodSelect.class, (String)"ManualMethodSelect_SelectMethodsDialogCaption");
    private static final String OK_BUTTON_TEXT = NbBundle.getMessage(ManualMethodSelect.class, (String)"ManualMethodSelect_OKButtonText");
    private static final String CLASS_NAME_LABEL_TEXT = NbBundle.getMessage(ManualMethodSelect.class, (String)"ManualMethodSelect_ClassNameLabelText");
    private static final String METHOD_NAME_LABEL_TEXT = NbBundle.getMessage(ManualMethodSelect.class, (String)"ManualMethodSelect_MethodNameLabelText");
    private static final String METHOD_SIGNATURE_LABEL_TEXT = NbBundle.getMessage(ManualMethodSelect.class, (String)"ManualMethodSelect_MethodSignatureLabelText");
    private static final String HINT_MSG = NbBundle.getMessage(ManualMethodSelect.class, (String)"ManualMethodSelect_HintMsg");
    private static final String CLASS_NAME_ACCESS_NAME = NbBundle.getMessage(ManualMethodSelect.class, (String)"ManualMethodSelect_ClassNameAccessName");
    private static final String METHOD_NAME_ACCESS_NAME = NbBundle.getMessage(ManualMethodSelect.class, (String)"ManualMethodSelect_MethodNameAccessName");
    private static final String METHOD_SIGNATURE_ACCESS_NAME = NbBundle.getMessage(ManualMethodSelect.class, (String)"ManualMethodSelect_MethodSignatureAccessName");
    private static final String HELP_CTX_KEY = "ManualMethodSelect.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ManualMethodSelect.HelpCtx");
    private static ManualMethodSelect mms;
    private static JButton okButton;
    private HTMLTextArea hintArea;
    private JTextField className;
    private JTextField methodName;
    private JTextField methodSignature;
    private MethodSelectDocumentListener documentListener = new MethodSelectDocumentListener();

    private ManualMethodSelect() {
        JLabel jLabel = new JLabel();
        this.className = new JTextField();
        JLabel jLabel2 = new JLabel();
        this.methodName = new JTextField();
        JLabel jLabel3 = new JLabel();
        this.methodSignature = new JTextField();
        this.hintArea = new HTMLTextArea(){

            public Dimension getPreferredSize() {
                return new Dimension(1, super.getPreferredSize().height);
            }
        };
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints2.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        jLabel.setLabelFor(this.className);
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)CLASS_NAME_LABEL_TEXT);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)jLabel, gridBagConstraints);
        this.className.getAccessibleContext().setAccessibleName(CLASS_NAME_ACCESS_NAME);
        this.className.setPreferredSize(new Dimension(290, this.className.getPreferredSize().height));
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        this.add((Component)this.className, gridBagConstraints2);
        jLabel2.setLabelFor(this.methodName);
        Mnemonics.setLocalizedText((JLabel)jLabel2, (String)METHOD_NAME_LABEL_TEXT);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)jLabel2, gridBagConstraints);
        this.methodName.getAccessibleContext().setAccessibleName(METHOD_NAME_ACCESS_NAME);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        this.add((Component)this.methodName, gridBagConstraints2);
        jLabel3.setLabelFor(this.methodSignature);
        Mnemonics.setLocalizedText((JLabel)jLabel3, (String)METHOD_SIGNATURE_LABEL_TEXT);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)jLabel3, gridBagConstraints);
        this.methodSignature.getAccessibleContext().setAccessibleName(METHOD_SIGNATURE_ACCESS_NAME);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 2;
        this.add((Component)this.methodSignature, gridBagConstraints2);
        Color color = UIManager.getColor("Panel.background");
        Color color2 = UIUtils.getSafeColor((int)(color.getRed() - 10), (int)(color.getGreen() - 10), (int)(color.getBlue() - 10));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 3;
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.fill = 1;
        this.add((Component)new JPanel(), gridBagConstraints3);
        this.hintArea.setText(HINT_MSG);
        this.hintArea.setEnabled(false);
        this.hintArea.setDisabledTextColor(Color.darkGray);
        this.hintArea.setBackground(color2);
        this.hintArea.setBorder((Border)BorderFactory.createMatteBorder(10, 10, 10, 10, color2));
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 4;
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.insets = new Insets(18, 0, 0, 0);
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.fill = 1;
        this.add((Component)this.hintArea, gridBagConstraints3);
        this.setBorder(new EmptyBorder(12, 12, 0, 12));
        this.className.getDocument().addDocumentListener(this.documentListener);
        this.methodName.getDocument().addDocumentListener(this.documentListener);
        this.methodSignature.getDocument().addDocumentListener(this.documentListener);
        this.updateEnabledState();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public static ClientUtils.SourceCodeSelection selectMethod() {
        if (mms == null) {
            mms = new ManualMethodSelect();
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)mms, SELECT_METHODS_DIALOG_CAPTION, true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, null, null);
        Dialog dialog = ProfilerDialogs.createDialog(dialogDescriptor);
        dialog.pack();
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == okButton) {
            return mms.getSelectedMethod();
        }
        return null;
    }

    private String getClassName() {
        return this.className.getText().trim();
    }

    private String getMethodName() {
        String string = this.methodName.getText().trim();
        if ("".equals(string)) {
            return null;
        }
        return string;
    }

    private String getMethodSignature() {
        String string = this.methodSignature.getText().trim();
        if ("".equals(string)) {
            return null;
        }
        return string;
    }

    private ClientUtils.SourceCodeSelection getSelectedMethod() {
        return new ClientUtils.SourceCodeSelection(this.getClassName(), this.getMethodName(), this.getMethodSignature());
    }

    private void updateEnabledState() {
        boolean bl = true;
        if ("".equals(this.className.getText().trim())) {
            bl = false;
        } else if ("".equals(this.methodName.getText().trim())) {
            bl = false;
        } else if ("".equals(this.methodSignature.getText().trim())) {
            bl = false;
        } else {
            try {
                this.methodSignature.setForeground(UIManager.getColor("Label.foreground"));
            }
            catch (Exception exception) {
                this.methodSignature.setForeground(Color.red);
                bl = false;
            }
        }
        okButton.setEnabled(bl);
    }

    static {
        okButton = new JButton(OK_BUTTON_TEXT);
    }

    private final class MethodSelectDocumentListener
    implements DocumentListener {
        private MethodSelectDocumentListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            ManualMethodSelect.this.updateEnabledState();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            ManualMethodSelect.this.updateEnabledState();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            ManualMethodSelect.this.updateEnabledState();
        }
    }
}

