/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import java.text.MessageFormat;
import java.util.List;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.modules.profiler.heapwalk.model.ArrayNode;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.ChildrenComputer;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNodeFactory;
import org.openide.util.NbBundle;

public class ObjectArrayNode
extends ArrayNode {
    private static final String ITEMS_NUMBER_STRING = NbBundle.getMessage(ObjectArrayNode.class, (String)"ObjectArrayNode_ItemsNumberString");
    private static final String LOOP_TO_STRING = NbBundle.getMessage(ObjectArrayNode.class, (String)"ObjectArrayNode_LoopToString");

    public ObjectArrayNode(ObjectArrayInstance objectArrayInstance, String string, HeapWalkerNode heapWalkerNode) {
        super((Instance)objectArrayInstance, string, heapWalkerNode);
    }

    public ObjectArrayNode(ObjectArrayInstance objectArrayInstance, String string, HeapWalkerNode heapWalkerNode, int n) {
        super((Instance)objectArrayInstance, string, heapWalkerNode, n);
    }

    public ObjectArrayInstance getInstance() {
        return (ObjectArrayInstance)super.getInstance();
    }

    public boolean isPrimitive() {
        return false;
    }

    protected ChildrenComputer getChildrenComputer() {
        return new ChildrenComputer(){

            public HeapWalkerNode[] computeChildren() {
                HeapWalkerNode[] heapWalkerNodeArray = null;
                if (ObjectArrayNode.this.getMode() == 1) {
                    int n = ObjectArrayNode.this.getInstance().getLength();
                    if (n == 0) {
                        heapWalkerNodeArray = new HeapWalkerNode[]{HeapWalkerNodeFactory.createNoItemsNode(ObjectArrayNode.this)};
                    } else if (n > HeapWalkerNodeFactory.ITEMS_COLLAPSE_UNIT_SIZE) {
                        int n2 = n;
                        BrowserUtils.GroupingInfo groupingInfo = BrowserUtils.getGroupingInfo(n2);
                        int n3 = groupingInfo.containersCount;
                        int n4 = groupingInfo.collapseUnitSize;
                        heapWalkerNodeArray = new HeapWalkerNode[n3];
                        for (int i = 0; i < n3; ++i) {
                            int n5 = n4 * i;
                            int n6 = Math.min(n5 + n4, n2) - 1;
                            heapWalkerNodeArray[i] = HeapWalkerNodeFactory.createArrayItemContainerNode(ObjectArrayNode.this, n5, n6);
                        }
                    } else {
                        List list = ObjectArrayNode.this.getInstance().getValues();
                        heapWalkerNodeArray = new HeapWalkerNode[list.size()];
                        for (int i = 0; i < heapWalkerNodeArray.length; ++i) {
                            heapWalkerNodeArray[i] = HeapWalkerNodeFactory.createObjectArrayItemNode(ObjectArrayNode.this, i, (Instance)list.get(i));
                        }
                    }
                } else if (ObjectArrayNode.this.getMode() == 2) {
                    heapWalkerNodeArray = HeapWalkerNodeFactory.createReferences(ObjectArrayNode.this);
                }
                return heapWalkerNodeArray;
            }
        };
    }

    protected String computeValue() {
        if (!this.hasInstance()) {
            return super.computeValue();
        }
        return super.computeValue() + " " + MessageFormat.format(ITEMS_NUMBER_STRING, this.getInstance().getLength());
    }

    public static abstract class RootNode
    extends ObjectArrayNode
    implements org.netbeans.modules.profiler.heapwalk.model.RootNode {
        public RootNode(ObjectArrayInstance objectArrayInstance, String string, HeapWalkerNode heapWalkerNode) {
            super(objectArrayInstance, string, heapWalkerNode);
        }

        public RootNode(ObjectArrayInstance objectArrayInstance, String string, HeapWalkerNode heapWalkerNode, int n) {
            super(objectArrayInstance, string, heapWalkerNode, n);
        }

        public abstract void refreshView();
    }

    public static class ArrayItem
    extends ObjectArrayNode
    implements org.netbeans.modules.profiler.heapwalk.model.ArrayItem {
        private int itemIndex;

        public ArrayItem(int n, ObjectArrayInstance objectArrayInstance, HeapWalkerNode heapWalkerNode) {
            this(n, objectArrayInstance, heapWalkerNode, heapWalkerNode == null ? 1 : heapWalkerNode.getMode());
        }

        public ArrayItem(int n, ObjectArrayInstance objectArrayInstance, HeapWalkerNode heapWalkerNode, int n2) {
            super(objectArrayInstance, null, heapWalkerNode, n2);
            this.itemIndex = n;
        }

        public int getItemIndex() {
            return this.itemIndex;
        }

        protected String computeName() {
            String string = "[" + this.itemIndex + "]";
            if (this.isLoop()) {
                return string + " " + MessageFormat.format(LOOP_TO_STRING, BrowserUtils.getFullNodeName(this.getLoopTo()));
            }
            return string;
        }

        protected String computeType() {
            if (!this.hasInstance()) {
                return "<" + BrowserUtils.getArrayItemType(this.getType()) + ">";
            }
            return super.computeType();
        }
    }
}

