/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawEngine;
import org.netbeans.editor.DrawGraphics;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FoldMultiLineView;
import org.netbeans.editor.view.spi.EstimatedSpanView;
import org.netbeans.editor.view.spi.LockView;
import org.netbeans.editor.view.spi.ViewLayoutState;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.lib.editor.view.GapDocumentView;

class DrawEngineLineView
extends View
implements ViewLayoutState,
EstimatedSpanView {
    private static final Logger LOG = Logger.getLogger(DrawEngineLineView.class.getName());
    private static final boolean loggable = LOG.isLoggable(Level.FINEST);
    private static final long PERF_TRESHOLD = Long.getLong("DrawEngineLineView.PERF_TRESHOLD", -1L);
    private static final int X_MAJOR_AXIS_BIT = 1;
    private static final int MAJOR_AXIS_PREFERENCE_CHANGED_BIT = 2;
    private static final int MINOR_AXIS_PREFERENCE_CHANGED_BIT = 4;
    private static final int VIEW_SIZE_INVALID_BIT = 8;
    private static final int UPDATE_LAYOUT_PENDING_BIT = 16;
    private static final int ESTIMATED_SPAN_BIT = 32;
    protected static final int LAST_USED_BIT = 32;
    private static final int ANY_INVALID = 14;
    private int statusBits;
    private int viewRawIndex;
    private double layoutMajorAxisRawOffset;
    private float layoutMajorAxisPreferredSpan;
    private float layoutMinorAxisPreferredSpan;
    private ViewToModelDG viewToModelDG;
    private static final int MARKERS_DIST;
    private int[] markers = new int[]{0};
    private int markersLength = this.markers.length;

    public DrawEngineLineView(Element element) {
        super(element);
    }

    private int getBaseX(int n) {
        return n + this.getEditorUI().getTextMargin().left;
    }

    private JTextComponent getComponent() {
        return (JTextComponent)this.getContainer();
    }

    private BaseTextUI getBaseTextUI() {
        return (BaseTextUI)this.getComponent().getUI();
    }

    private EditorUI getEditorUI() {
        return this.getBaseTextUI().getEditorUI();
    }

    private ModelToViewDG getModelToViewDG() {
        return new ModelToViewDG();
    }

    private ViewToModelDG getViewToModelDG() {
        if (this.viewToModelDG == null) {
            this.viewToModelDG = new ViewToModelDG();
        }
        return this.viewToModelDG;
    }

    public boolean isEstimatedSpan() {
        return this.isStatusBitsNonZero(32);
    }

    public void setEstimatedSpan(boolean bl) {
        if (this.isEstimatedSpan() != bl) {
            if (bl) {
                this.setStatusBits(32);
            } else {
                this.clearStatusBits(32);
                this.getParent().preferenceChanged(this, true, true);
            }
        }
    }

    protected boolean isFragment() {
        return false;
    }

    private int getEOLffset() {
        return super.getEndOffset() - 1;
    }

    private int getAdjustedEOLOffset() {
        return Math.min(this.getEndOffset(), this.getEOLffset());
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.resetMarkers(documentEvent.getOffset());
        this.preferenceChanged(this, true, false);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.resetMarkers(documentEvent.getOffset());
        this.preferenceChanged(this, true, false);
    }

    public float getAlignment(int n) {
        return 0.0f;
    }

    public void paint(Graphics graphics, Shape shape) {
        if (!(this.getDocument() instanceof BaseDocument)) {
            return;
        }
        this.setEstimatedSpan(false);
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        int n = this.getStartOffset();
        int n2 = this.getAdjustedEOLOffset();
        try {
            if (this.isFragment()) {
                Rectangle rectangle2 = graphics.getClipBounds();
                Rectangle rectangle3 = new Rectangle(rectangle2);
                Rectangle rectangle4 = this.modelToView(n, shape, Position.Bias.Forward).getBounds();
                Rectangle rectangle5 = this.modelToView(n2, shape, Position.Bias.Forward).getBounds();
                View view = this.getParent();
                if (view instanceof FoldMultiLineView && !this.equals(view.getView(view.getViewCount() - 1))) {
                    rectangle3.width = Math.min(rectangle2.width, rectangle5.x);
                    if (rectangle3.width + rectangle3.x > rectangle5.x) {
                        rectangle3.width -= rectangle3.width + rectangle3.x - rectangle5.x;
                    }
                    graphics.setClip(rectangle3);
                }
                int n3 = rectangle4.x - this.getEditorUI().getTextMargin().left - rectangle.x;
                graphics.translate(-n3, 0);
                DrawEngine.getDrawEngine().draw(this, new DrawGraphics.GraphicsDG(graphics), this.getEditorUI(), n, n2, this.getBaseX(rectangle.x), rectangle.y, Integer.MAX_VALUE);
                graphics.translate(n3, 0);
                graphics.setClip(rectangle2);
            } else {
                JTextComponent jTextComponent = this.getComponent();
                if (jTextComponent != null) {
                    long l = 0L;
                    long l2 = 0L;
                    if (loggable) {
                        l = System.currentTimeMillis();
                    }
                    Rectangle rectangle6 = graphics.getClipBounds();
                    int n4 = this.viewToModel(rectangle6.x, rectangle6.y, rectangle, null);
                    int n5 = this.viewToModel(rectangle6.x + rectangle6.width, rectangle6.y, rectangle, null);
                    n4 = Math.max(n4 - 1, this.getStartOffset());
                    n5 = Math.min(n5 + 1, this.getAdjustedEOLOffset());
                    Rectangle rectangle7 = this.modelToView(n4, rectangle, Position.Bias.Forward).getBounds();
                    DrawEngine.getDrawEngine().draw(this, new DrawGraphics.GraphicsDG(graphics), this.getEditorUI(), n4, n5, rectangle7.x, rectangle7.y, Integer.MAX_VALUE);
                    if (loggable && (l2 = System.currentTimeMillis()) - l > PERF_TRESHOLD) {
                        LOG.finest("paint: <" + n4 + ", " + n5 + ">, " + "DrawEngine.startX = " + rectangle7.x + ", DrawEngine.startY = " + rectangle7.y + ", " + "shape = [" + rectangle.x + ", " + rectangle.y + ", " + rectangle.width + ", " + rectangle.height + "], " + "clip = [" + rectangle6.x + ", " + rectangle6.y + ", " + rectangle6.width + ", " + rectangle6.height + "] " + "took " + (l2 - l) + " msec");
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.INFO, "Painting the view failed", badLocationException);
        }
    }

    public float getPreferredSpan(int n) {
        switch (n) {
            case 1: {
                return this.getEditorUI().getLineHeight();
            }
            case 0: {
                int n2 = Math.max(0, this.getEndOffset() - 1);
                Shape shape = this.modelToView(n2, new Rectangle(), Position.Bias.Forward, false);
                int n3 = shape.getBounds().x + shape.getBounds().width;
                return Math.max((float)n3, 1.0f);
            }
        }
        return 1.0f;
    }

    public void highlightsChanged(int n, int n2) {
        this.checkViewAccess();
        this.resetMarkers(n);
        this.preferenceChanged(this, true, false);
    }

    private void resetMarkers(int n) {
        this.markersLength = n < this.getStartOffset() || n > this.getEndOffset() ? 1 : Math.min(this.markersLength, (n - this.getStartOffset()) / MARKERS_DIST + 1);
        if (loggable) {
            LOG.finest("resetMarkers: <" + this.getStartOffset() + ", " + this.getEndOffset() + ">, offset = " + n + " -> markersLength = " + this.markersLength);
        }
    }

    private Rectangle getModel2ViewRect(int n, int n2, int n3, int n4, int n5) {
        Rectangle rectangle;
        long l = 0L;
        long l2 = 0L;
        EditorUI editorUI = this.getEditorUI();
        View view = this.getParent();
        if (view instanceof GapDocumentView && ((GapDocumentView)view).isPendingUpdate() || this.isEstimatedSpan()) {
            rectangle = new Rectangle(this.getBaseX(n3), n4, 1, editorUI.getLineHeight());
        } else {
            if (loggable) {
                l = System.currentTimeMillis();
            }
            int n6 = (n5 - n) / MARKERS_DIST;
            int n7 = Math.min(n6, this.markersLength - 1);
            int n8 = this.markers[n7];
            int n9 = n + n7 * MARKERS_DIST;
            rectangle = new Rectangle(this.getBaseX(n8), n4, 1, editorUI.getLineHeight());
            try {
                ModelToViewDG modelToViewDG = this.getModelToViewDG();
                modelToViewDG.setRectangle(rectangle);
                if (this.markers.length <= n6) {
                    int[] nArray = new int[n6 + 1];
                    System.arraycopy(this.markers, 0, nArray, 0, this.markers.length);
                    this.markers = nArray;
                }
                while (n7 < n6) {
                    DrawEngine.getDrawEngine().draw(this, modelToViewDG, editorUI, n9, n9 + MARKERS_DIST, n8, n4, n9 + MARKERS_DIST);
                    n9 += MARKERS_DIST;
                    this.markers[n7 + 1] = n8 = rectangle.x;
                    ++n7;
                }
                if (n6 >= this.markersLength) {
                    this.markersLength = n6 + 1;
                }
                DrawEngine.getDrawEngine().draw(this, modelToViewDG, editorUI, n9, n2, this.getBaseX(n8 + n3), n4, n5);
                modelToViewDG.setRectangle(null);
            }
            catch (BadLocationException badLocationException) {
                LOG.log(Level.INFO, "Model-to-view translation failed", badLocationException);
                rectangle = new Rectangle(this.getBaseX(n3), n4, 1, editorUI.getLineHeight());
            }
            if (loggable) {
                l2 = System.currentTimeMillis();
            }
        }
        if (loggable && l2 - l > PERF_TRESHOLD) {
            LOG.finest("m2v: <" + n + ", " + n2 + ">, targetOffset = " + n5 + ", " + "[" + n3 + ", " + n4 + "] " + "-> [" + rectangle.getBounds().x + ", " + rectangle.getBounds().y + ", " + rectangle.getBounds().width + ", " + rectangle.getBounds().height + "]" + " took " + (l2 - l) + " msec");
        }
        return rectangle;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) {
        return this.modelToView(n, shape, bias, true);
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias, boolean bl) {
        assert (shape != null) : "The shape parameter must not be null";
        this.checkViewAccess();
        if (!(this.getDocument() instanceof BaseDocument)) {
            return new Rectangle();
        }
        if (bl) {
            this.setEstimatedSpan(false);
        }
        if (bias == Position.Bias.Forward && (n < super.getStartOffset() || n >= super.getEndOffset()) || bias == Position.Bias.Backward && (n <= super.getStartOffset() || n > super.getEndOffset())) {
            BadLocationException badLocationException = new BadLocationException("Invalid offset = " + n + ", bias = " + bias + ", outside of the view <" + super.getStartOffset() + ", " + super.getEndOffset() + ">" + ", isFragment = " + this.isFragment() + (this.isFragment() ? ", fragment boundaries <" + this.getStartOffset() + ", " + this.getEndOffset() + ">" : ""), n);
            LOG.log(Level.INFO, null, badLocationException);
            return new Rectangle(this.getBaseX(shape.getBounds().x), shape.getBounds().y, 1, this.getEditorUI().getLineHeight());
        }
        if (this.isFragment() && (n < this.getStartOffset() || n > this.getEndOffset())) {
            BadLocationException badLocationException = new BadLocationException("Invalid offset = " + n + ", bias = " + bias + ", outside of the fragment view" + " <" + this.getStartOffset() + ", " + this.getEndOffset() + ">", n);
            LOG.log(Level.INFO, null, badLocationException);
            return new Rectangle(this.getBaseX(shape.getBounds().x), shape.getBounds().y, 1, this.getEditorUI().getLineHeight());
        }
        if (bias == Position.Bias.Backward) {
            --n;
        }
        Rectangle rectangle = this.getModel2ViewRect(this.getStartOffset(), this.getEndOffset(), shape.getBounds().x, shape.getBounds().y, n);
        return rectangle;
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        assert (shape != null) : "The shape parameter must not be null";
        this.checkViewAccess();
        if (!(this.getDocument() instanceof BaseDocument)) {
            return 0;
        }
        long l = 0L;
        long l2 = 0L;
        int n = this.getStartOffset();
        if (biasArray != null) {
            biasArray[0] = Position.Bias.Forward;
        }
        if (!this.isEstimatedSpan() && f > (float)shape.getBounds().x) {
            if (loggable) {
                l = System.currentTimeMillis();
            }
            EditorUI editorUI = this.getEditorUI();
            int n2 = Math.max(0, (int)f - shape.getBounds().x - editorUI.getTextMargin().left);
            int n3 = ArrayUtilities.binarySearch((int[])this.markers, (int)0, (int)(this.markersLength - 1), (int)n2);
            if (n3 >= 0) {
                n = this.getStartOffset() + n3 * MARKERS_DIST;
            } else {
                n3 = -n3 - 2;
                int n4 = this.markers[n3];
                int n5 = this.getStartOffset() + n3 * MARKERS_DIST;
                try {
                    ViewToModelDG viewToModelDG = this.getViewToModelDG();
                    while (true) {
                        int n6 = Math.min(this.getAdjustedEOLOffset(), n5 + MARKERS_DIST - 1);
                        viewToModelDG.setTargetX(n2);
                        viewToModelDG.setEOLOffset(n6);
                        DrawEngine.getDrawEngine().draw(this, viewToModelDG, editorUI, n5, n6, n4, shape.getBounds().y, -1);
                        if (viewToModelDG.getX() >= n2 || viewToModelDG.getOffset() >= this.getAdjustedEOLOffset()) break;
                        n5 += MARKERS_DIST;
                        n4 = viewToModelDG.getX();
                        if (n3 + 1 >= this.markers.length) {
                            int[] nArray = new int[this.markers.length + 10];
                            System.arraycopy(this.markers, 0, nArray, 0, this.markers.length);
                            this.markers = nArray;
                        }
                        this.markers[++n3] = n4;
                        this.markersLength = n3 + 1;
                    }
                    n = Math.min(viewToModelDG.getOffset(), this.getAdjustedEOLOffset());
                }
                catch (BadLocationException badLocationException) {
                    LOG.log(Level.INFO, "View-to-model translation failed", badLocationException);
                }
            }
            if (loggable) {
                l2 = System.currentTimeMillis();
            }
        }
        if (loggable && l2 - l > PERF_TRESHOLD) {
            LOG.finest("v2m: [" + f + ", " + f2 + "], " + "[" + shape.getBounds().x + ", " + shape.getBounds().y + ", " + shape.getBounds().width + ", " + shape.getBounds().height + "] " + "-> " + n + " took " + (l2 - l) + " msec");
        }
        return n;
    }

    private void checkViewAccess() {
        LockView lockView = LockView.get(this);
        if (lockView != null && lockView.getLockThread() != Thread.currentThread()) {
            throw new IllegalStateException("View access without view lock");
        }
    }

    public View createFragment(int n, int n2) {
        Element element = this.getElement();
        return n >= 0 && n >= element.getStartOffset() && n < element.getEndOffset() && n2 > 0 && n2 <= element.getEndOffset() && n2 > element.getStartOffset() && (n != element.getStartOffset() || n2 != element.getEndOffset()) ? new FragmentView(this.getElement(), n - element.getStartOffset(), n2 - n) : this;
    }

    public double getLayoutMajorAxisPreferredSpan() {
        return this.layoutMajorAxisPreferredSpan;
    }

    public float getLayoutMajorAxisPreferredSpanFloat() {
        return this.layoutMajorAxisPreferredSpan;
    }

    protected void setLayoutMajorAxisPreferredSpan(float f) {
        this.layoutMajorAxisPreferredSpan = f;
    }

    public double getLayoutMajorAxisRawOffset() {
        return this.layoutMajorAxisRawOffset;
    }

    public void setLayoutMajorAxisRawOffset(double d) {
        this.layoutMajorAxisRawOffset = d;
    }

    public float getLayoutMinorAxisAlignment() {
        return this.getAlignment(this.getMinorAxis());
    }

    public float getLayoutMinorAxisMaximumSpan() {
        return this.getLayoutMinorAxisPreferredSpan();
    }

    public float getLayoutMinorAxisMinimumSpan() {
        return this.getLayoutMinorAxisPreferredSpan();
    }

    public float getLayoutMinorAxisPreferredSpan() {
        return this.layoutMinorAxisPreferredSpan;
    }

    protected void setLayoutMinorAxisPreferredSpan(float f) {
        this.layoutMinorAxisPreferredSpan = f;
    }

    public View getView() {
        return this;
    }

    public int getViewRawIndex() {
        return this.viewRawIndex;
    }

    public void setViewRawIndex(int n) {
        this.viewRawIndex = n;
    }

    public boolean isFlyweight() {
        return false;
    }

    public ViewLayoutState selectLayoutMajorAxis(int n) {
        if (n == 0) {
            this.setStatusBits(1);
        } else {
            this.clearStatusBits(1);
        }
        return this;
    }

    protected final ViewLayoutState.Parent getLayoutStateParent() {
        View view = this.getView().getParent();
        return view instanceof ViewLayoutState.Parent ? (ViewLayoutState.Parent)((Object)view) : null;
    }

    public void updateLayout() {
        float f;
        if (this.isLayoutValid()) {
            return;
        }
        ViewLayoutState.Parent parent = this.getLayoutStateParent();
        if (parent == null) {
            return;
        }
        if (this.isStatusBitsNonZero(4)) {
            this.clearStatusBits(4);
            int n = this.getMinorAxis();
            if (this.minorAxisUpdateLayout(n)) {
                parent.minorAxisPreferenceChanged(this);
            }
        }
        if (this.isStatusBitsNonZero(2)) {
            this.clearStatusBits(2);
            float f2 = this.getLayoutMajorAxisPreferredSpanFloat();
            f = this.getPreferredSpan(this.getMajorAxis());
            this.setLayoutMajorAxisPreferredSpan(f);
            double d = f - f2;
            if (d != 0.0) {
                parent.majorAxisPreferenceChanged(this, d);
            }
        }
        if (this.isStatusBitsNonZero(8)) {
            float f3;
            this.clearStatusBits(8);
            float f4 = (float)this.getLayoutMajorAxisPreferredSpan();
            float f5 = parent.getMinorAxisSpan(this);
            if (this.isXMajorAxis()) {
                f3 = f4;
                f = f5;
            } else {
                f3 = f5;
                f = f4;
            }
            this.setSize(f3, f);
        }
        this.updateLayout();
    }

    protected boolean minorAxisUpdateLayout(int n) {
        boolean bl = false;
        float f = this.getPreferredSpan(n);
        if (f != this.getLayoutMinorAxisPreferredSpan()) {
            this.setLayoutMinorAxisPreferredSpan(f);
            bl = true;
        }
        return bl;
    }

    public void viewPreferenceChanged(boolean bl, boolean bl2) {
        if (this.isXMajorAxis()) {
            if (bl) {
                this.setStatusBits(2);
            }
            if (bl2) {
                this.setStatusBits(4);
            }
        } else {
            if (bl) {
                this.setStatusBits(4);
            }
            if (bl2) {
                this.setStatusBits(2);
            }
        }
        this.setStatusBits(8);
    }

    public void markViewSizeInvalid() {
        this.setStatusBits(8);
    }

    public boolean isLayoutValid() {
        return !this.isStatusBitsNonZero(14);
    }

    protected final boolean isXMajorAxis() {
        return this.isStatusBitsNonZero(1);
    }

    protected final int getMajorAxis() {
        return this.isXMajorAxis() ? 0 : 1;
    }

    protected final int getMinorAxis() {
        return this.isXMajorAxis() ? 1 : 0;
    }

    protected final int getStatusBits(int n) {
        return this.statusBits & n;
    }

    protected final boolean isStatusBitsNonZero(int n) {
        return this.getStatusBits(n) != 0;
    }

    protected final void setStatusBits(int n) {
        this.statusBits |= n;
    }

    protected final void clearStatusBits(int n) {
        this.statusBits &= ~n;
    }

    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        switch (n2) {
            case 7: {
                n = super.getNextVisualPositionFrom(n, bias, shape, n2, biasArray);
                if (!Character.isLowSurrogate(DocumentUtilities.getText((Document)this.getDocument()).charAt(n))) break;
                return super.getNextVisualPositionFrom(n, bias, shape, n2, biasArray);
            }
            case 3: {
                n = super.getNextVisualPositionFrom(n, bias, shape, n2, biasArray);
                if (!Character.isLowSurrogate(DocumentUtilities.getText((Document)this.getDocument()).charAt(n))) break;
                return super.getNextVisualPositionFrom(n, bias, shape, n2, biasArray);
            }
            default: {
                n = super.getNextVisualPositionFrom(n, bias, shape, n2, biasArray);
            }
        }
        return n;
    }

    static {
        int n = 128;
        try {
            n = (Integer)Class.forName("org.netbeans.editor.DrawEngineTest").getField("TEST_MARKERS_DIST").get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        MARKERS_DIST = n;
        LOG.fine("DrawEngineLineView.MARKERS_DIST = " + MARKERS_DIST);
    }

    private static final class FragmentView
    extends DrawEngineLineView {
        private Position startPos;
        private Position endPos;

        public FragmentView(Element element, int n, int n2) {
            super(element);
            try {
                Document document = element.getDocument();
                this.startPos = document.createPosition(super.getStartOffset() + n);
                this.endPos = document.createPosition(this.startPos.getOffset() + n2);
            }
            catch (BadLocationException badLocationException) {
                LOG.log(Level.INFO, "Can't create fragment view, offset = " + n + ", length = " + n2, badLocationException);
            }
        }

        protected boolean isFragment() {
            return true;
        }

        public int getStartOffset() {
            return this.startPos.getOffset();
        }

        public int getEndOffset() {
            return this.endPos.getOffset();
        }
    }

    private final class ModelToViewDG
    extends DrawGraphics.SimpleDG {
        private Rectangle r;

        private ModelToViewDG() {
        }

        public Rectangle getRectangle() {
            return this.r;
        }

        public void setRectangle(Rectangle rectangle) {
            this.r = rectangle;
        }

        public boolean targetOffsetReached(int n, char c, int n2, int n3, DrawContext drawContext) {
            this.r.x = n2;
            this.r.y = this.getY();
            this.r.width = n3;
            this.r.height = DrawEngineLineView.this.getEditorUI().getLineHeight();
            return false;
        }
    }

    private final class ViewToModelDG
    extends DrawGraphics.SimpleDG {
        private int targetX;
        private int offset;
        private int eolOffset;

        private ViewToModelDG() {
        }

        public void setTargetX(int n) {
            this.targetX = n;
        }

        public void setEOLOffset(int n) {
            this.eolOffset = n;
            this.offset = n;
        }

        public int getOffset() {
            return this.offset;
        }

        public boolean targetOffsetReached(int n, char c, int n2, int n3, DrawContext drawContext) {
            if (n <= this.eolOffset) {
                if (n2 + n3 < this.targetX) {
                    this.offset = n;
                    return true;
                }
                this.offset = n;
                if (this.targetX > n2 + n3 / 2) {
                    Document document = DrawEngineLineView.this.getDocument();
                    if (c != '\n' && document != null && n < document.getLength()) {
                        ++this.offset;
                    }
                }
                return false;
            }
            return false;
        }
    }
}

