/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.dd.api.web.WebAppMetadata;
import org.netbeans.modules.j2ee.dd.api.web.model.FilterInfo;
import org.netbeans.modules.j2ee.dd.api.web.model.ServletInfo;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.wizards.BaseWizardPanel;
import org.netbeans.modules.web.wizards.DeployData;
import org.netbeans.modules.web.wizards.DeployDataExtraPanel;
import org.netbeans.modules.web.wizards.DeployDataPanel;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.FilterMappingData;
import org.netbeans.modules.web.wizards.ServletData;
import org.netbeans.modules.web.wizards.TargetEvaluator;
import org.netbeans.modules.web.wizards.Utilities;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletPanel
implements WizardDescriptor.FinishablePanel {
    private transient BaseWizardPanel wizardPanel;
    private transient TemplateWizard wizard;
    private ChangeListener listener;
    private DeployData deployData;
    private transient TargetEvaluator evaluator;

    private ServletPanel(TargetEvaluator targetEvaluator, TemplateWizard templateWizard, boolean bl) {
        this.evaluator = targetEvaluator;
        this.wizard = templateWizard;
        this.deployData = targetEvaluator.getDeployData();
        this.wizardPanel = bl ? new DeployDataPanel(targetEvaluator, templateWizard) : new DeployDataExtraPanel(targetEvaluator, templateWizard);
    }

    public boolean isFinishPanel() {
        return true;
    }

    public static ServletPanel createServletPanel(TargetEvaluator targetEvaluator, TemplateWizard templateWizard) {
        return new ServletPanel(targetEvaluator, templateWizard, true);
    }

    public static ServletPanel createFilterPanel(TargetEvaluator targetEvaluator, TemplateWizard templateWizard) {
        return new ServletPanel(targetEvaluator, templateWizard, false);
    }

    public Component getComponent() {
        return this.wizardPanel;
    }

    public boolean isValid() {
        WebModule webModule;
        if (!this.deployData.isValid()) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)this.deployData.getErrorMessage());
            return false;
        }
        if (Utilities.isJavaEE6(this.wizard) && (webModule = Utilities.findWebModule(this.wizard)) != null && this.deployData instanceof ServletData) {
            ServletData servletData = (ServletData)this.deployData;
            String string = servletData.getName();
            if (servletData.fileType == FileType.SERVLET) {
                for (ServletInfo servletInfo : this.getServlets(webModule)) {
                    if (!servletInfo.getName().equals(string)) continue;
                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ServletData.class, (String)"MSG_servlet_name_defined", (Object)string, (Object)servletInfo.getServletClass()));
                    return false;
                }
                for (ServletInfo servletInfo : this.getServlets(webModule)) {
                    List list = servletInfo.getUrlPatterns();
                    for (String string2 : list) {
                        for (String string3 : servletData.getUrlMappings()) {
                            if (!string2.equals(string3)) continue;
                            this.wizard.putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(ServletData.class, (String)"MSG_servlet_mapping_defined", (Object)string3, (Object)servletInfo.getServletClass()));
                            return true;
                        }
                    }
                }
            } else if (servletData.fileType == FileType.FILTER) {
                for (FilterInfo filterInfo : this.getFilters(webModule)) {
                    if (!filterInfo.getName().equals(string)) continue;
                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ServletData.class, (String)"MSG_filter_name_defined", (Object)string, (Object)filterInfo.getFilterClass()));
                    return false;
                }
                for (FilterInfo filterInfo : this.getFilters(webModule)) {
                    List list = filterInfo.getUrlPatterns();
                    for (String string4 : list) {
                        for (FilterMappingData filterMappingData : servletData.getFilterMappings()) {
                            if (!string4.equals(filterMappingData.getPattern())) continue;
                            this.wizard.putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(ServletData.class, (String)"MSG_filter_mapping_defined", (Object)filterMappingData.getPattern(), (Object)filterInfo.getFilterClass()));
                            return true;
                        }
                    }
                }
            }
        }
        this.wizard.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    private List<ServletInfo> getServlets(WebModule webModule) {
        try {
            List list = (List)webModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<WebAppMetadata, List<ServletInfo>>(){

                public List<ServletInfo> run(WebAppMetadata webAppMetadata) throws Exception {
                    return webAppMetadata.getServlets();
                }
            });
            return list;
        }
        catch (MetadataModelException metadataModelException) {
            Logger.global.log(Level.WARNING, "getServlets failed", metadataModelException);
        }
        catch (IOException iOException) {
            Logger.global.log(Level.WARNING, "getServlets failed", iOException);
        }
        return Collections.emptyList();
    }

    private List<FilterInfo> getFilters(WebModule webModule) {
        try {
            List list = (List)webModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<WebAppMetadata, List<FilterInfo>>(){

                public List<FilterInfo> run(WebAppMetadata webAppMetadata) throws Exception {
                    return webAppMetadata.getFilters();
                }
            });
            return list;
        }
        catch (MetadataModelException metadataModelException) {
            Logger.global.log(Level.WARNING, "getFilters failed", metadataModelException);
        }
        catch (IOException iOException) {
            Logger.global.log(Level.WARNING, "getFilters failed", iOException);
        }
        return Collections.emptyList();
    }

    public HelpCtx getHelp() {
        if (this.evaluator.getFileType() == FileType.SERVLET) {
            return this.wizardPanel.getHelp();
        }
        return null;
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listener != null) {
            throw new IllegalStateException();
        }
        if (this.wizardPanel != null) {
            this.wizardPanel.addChangeListener(changeListener);
        }
        this.listener = changeListener;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listener = null;
        if (this.wizardPanel != null) {
            this.wizardPanel.removeChangeListener(changeListener);
        }
    }

    public void readSettings(Object object) {
        if (object instanceof TemplateWizard) {
            TemplateWizard templateWizard = (TemplateWizard)object;
            String string = templateWizard.getTargetName();
            FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)templateWizard);
            Project project = Templates.getProject((WizardDescriptor)templateWizard);
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
            String string2 = null;
            for (int i = 0; i < sourceGroupArray.length && string2 == null; ++i) {
                if (WebModule.getWebModule((FileObject)sourceGroupArray[i].getRootFolder()) == null) continue;
                string2 = FileUtil.getRelativePath((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject);
            }
            string2 = string2 != null ? string2.replace('/', '.') : "";
            if (string == null) {
                this.evaluator.setClassName(templateWizard.getTemplate().getName(), string2);
            } else {
                this.evaluator.setClassName(string, string2);
            }
        }
        this.wizardPanel.setData();
    }

    public void storeSettings(Object object) {
    }
}

