/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.migration.archiver.XMLInputStream;
import org.netbeans.modules.dbschema.util.NameUtil;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class SchemaElementUtil {
    private static FileObject schemaFO = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchemaElement forName(String string, Object object) {
        SchemaElement schemaElement = SchemaElement.getLastSchema();
        if (schemaElement != null && schemaElement.getName().getFullName().equals(string) && schemaFO == null) {
            return schemaElement;
        }
        Map map = SchemaElement.schemaCache;
        synchronized (map) {
            Object object2;
            String string2 = "";
            if (schemaFO != null) {
                try {
                    string2 = schemaFO.getURL().toString();
                }
                catch (Exception exception) {
                    Logger.getLogger("global").log(Level.INFO, null, exception);
                }
            }
            if ((schemaElement = schemaFO == null ? (SchemaElement)SchemaElement.schemaCache.get(string) : (SchemaElement)SchemaElement.schemaCache.get(string + "#" + string2)) != null) {
                return schemaElement;
            }
            FileObject fileObject = null;
            if (schemaFO == null) {
                if (object instanceof FileObject) {
                    fileObject = SchemaElementUtil.findResource((FileObject)object, string);
                } else if (object instanceof FileObject[]) {
                    object2 = (DataObject)object;
                    for (int i = 0; fileObject == null && i < ((DataObject)object2).length; ++i) {
                        fileObject = SchemaElementUtil.findResource((FileObject)object2[i], string);
                    }
                } else if (object != null) {
                    throw new UnsupportedOperationException("Cannot lookup schema " + string + " in context of type " + object.getClass() + " expected FileObject, FileObject[], or null.");
                }
            } else {
                fileObject = schemaFO;
            }
            if (fileObject != null && fileObject.isValid()) {
                try {
                    object2 = DataObject.find((FileObject)fileObject);
                    if (object2 != null) {
                        schemaElement = (SchemaElement)object2.getCookie(SchemaElement.class);
                    }
                }
                catch (ClassCastException classCastException) {
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Logger.getLogger("global").log(Level.INFO, null, dataObjectNotFoundException);
                }
                if (schemaElement == null) {
                    try {
                        TableElement[] tableElementArray;
                        StatusDisplayer.getDefault().setStatusText(ResourceBundle.getBundle("org.netbeans.modules.dbschema.resources.Bundle").getString("RetrievingSchema"));
                        object2 = fileObject.getInputStream();
                        XMLInputStream xMLInputStream = new XMLInputStream((InputStream)object2);
                        schemaElement = (SchemaElement)xMLInputStream.readObject();
                        if (!schemaElement.isCompatibleVersion()) {
                            tableElementArray = MessageFormat.format(ResourceBundle.getBundle("org.netbeans.modules.dbschema.resources.Bundle").getString("PreviousVersion"), string);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)tableElementArray, 0));
                        }
                        xMLInputStream.close();
                        schemaElement.setName(DBIdentifier.create(string));
                        if (schemaFO == null) {
                            SchemaElement.addToCache(schemaElement);
                        } else {
                            SchemaElement.schemaCache.put(string + "#" + string2, schemaElement);
                            SchemaElement.setLastSchema(schemaElement);
                        }
                        tableElementArray = schemaElement.getTables();
                        int n = tableElementArray != null ? tableElementArray.length : 0;
                        for (int i = 0; i < n; ++i) {
                            tableElementArray[i].setDeclaringSchema(schemaElement);
                        }
                    }
                    catch (Exception exception) {
                        Logger.getLogger("global").log(Level.INFO, null, exception);
                        StatusDisplayer.getDefault().setStatusText(ResourceBundle.getBundle("org.netbeans.modules.dbschema.resources.Bundle").getString("CannotRetrieve"));
                    }
                }
            } else {
                Logger.getLogger("global").log(Level.FINE, ResourceBundle.getBundle("org.netbeans.modules.dbschema.resources.Bundle").getString("SchemaNotFound"));
            }
            return schemaElement;
        }
    }

    public static SchemaElement forName(FileObject fileObject) {
        schemaFO = fileObject;
        SchemaElement schemaElement = SchemaElementUtil.forName(fileObject.getName(), null);
        schemaFO = null;
        return schemaElement;
    }

    private static FileObject findResource(FileObject fileObject, String string) {
        return fileObject.getFileObject(NameUtil.getSchemaResourceName(string));
    }
}

