/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.List;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.ruby.CompletionRequest;
import org.netbeans.modules.ruby.RubyBaseCompleter;
import org.netbeans.modules.ruby.RubyCodeCompleter;
import org.netbeans.modules.ruby.RubyCompletionItem;
import org.netbeans.modules.ruby.RubyPredefinedVariable;
import org.netbeans.modules.ruby.RubyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RubyKeywordCompleter
extends RubyBaseCompleter {
    private final boolean isSymbol;

    static boolean complete(List<? super CompletionProposal> list, CompletionRequest completionRequest, int n, boolean bl, boolean bl2) {
        RubyKeywordCompleter rubyKeywordCompleter = new RubyKeywordCompleter(list, completionRequest, n, bl, bl2);
        return rubyKeywordCompleter.complete();
    }

    private RubyKeywordCompleter(List<? super CompletionProposal> list, CompletionRequest completionRequest, int n, boolean bl, boolean bl2) {
        super(list, completionRequest, n, bl);
        this.isSymbol = bl2;
    }

    private boolean complete() {
        RubyCompletionItem.KeywordItem keywordItem;
        String string = this.request.prefix;
        if (string.equals("$")) {
            for (RubyPredefinedVariable rubyPredefinedVariable : RubyPredefinedVariable.getPredefinedVariables()) {
                keywordItem = new RubyCompletionItem.KeywordItem(rubyPredefinedVariable.getName(), rubyPredefinedVariable.getDescription(), this.anchor, this.request);
                if (this.isSymbol) {
                    keywordItem.setSymbol(true);
                }
                this.propose((CompletionProposal)keywordItem);
            }
        }
        for (RubyPredefinedVariable rubyPredefinedVariable : RubyPredefinedVariable.getPredefinedClassVariables()) {
            if (!RubyCodeCompleter.startsWith(rubyPredefinedVariable.getName(), string, this.caseSensitive)) continue;
            keywordItem = new RubyCompletionItem.KeywordItem(rubyPredefinedVariable.getName(), null, this.anchor, this.request);
            if (this.isSymbol) {
                keywordItem.setSymbol(true);
            }
            this.propose((CompletionProposal)keywordItem);
        }
        for (String string2 : RubyUtils.RUBY_KEYWORDS) {
            if (!RubyCodeCompleter.startsWith(string2, string, this.caseSensitive)) continue;
            RubyCompletionItem.KeywordItem keywordItem2 = new RubyCompletionItem.KeywordItem(string2, null, this.anchor, this.request);
            if (this.isSymbol) {
                keywordItem2.setSymbol(true);
            }
            this.propose((CompletionProposal)keywordItem2);
        }
        return false;
    }
}

