/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.ruby.RubyUtils;

final class Inflector {
    private final Set<String> uncountables = new HashSet<String>();
    private final Map<String, String> irregulars = new LinkedHashMap<String, String>();
    private final Map<Pattern, String> plurals = new LinkedHashMap<Pattern, String>();
    private final Map<Pattern, String> singulars = new LinkedHashMap<Pattern, String>();
    private static final Inflector INSTANCE = new Inflector();

    public static Inflector getDefault() {
        return INSTANCE;
    }

    private Inflector() {
        this.init();
    }

    public String pluralize(String string) {
        if (this.isEmpty(string)) {
            return string;
        }
        String string2 = string.toLowerCase(Locale.ENGLISH);
        if (this.uncountables.contains(string2)) {
            return string;
        }
        if (this.irregulars.containsKey(string2)) {
            return this.irregulars.get(string2);
        }
        for (Pattern pattern : this.plurals.keySet()) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            return matcher.replaceAll(this.plurals.get(pattern));
        }
        return string;
    }

    public String singularize(String string) {
        if (this.isEmpty(string)) {
            return string;
        }
        String string2 = string.toLowerCase(Locale.ENGLISH);
        if (this.uncountables.contains(string2)) {
            return string;
        }
        if (this.irregulars.containsValue(string2)) {
            for (Map.Entry object : this.irregulars.entrySet()) {
                if (!((String)object.getValue()).equals(string2)) continue;
                return (String)object.getKey();
            }
        }
        for (Pattern pattern : this.singulars.keySet()) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            return matcher.replaceAll(this.singulars.get(pattern));
        }
        return string;
    }

    public String tableize(String string) {
        return this.pluralize(RubyUtils.camelToUnderlinedName(string));
    }

    public String demodulize(String string) {
        int n = string.lastIndexOf("::");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 2, string.length());
    }

    private boolean isEmpty(String string) {
        return string == null || "".equals(string.trim());
    }

    private void plural(String string, String string2) {
        this.plurals.put(this.compile(string), string2);
    }

    private void singular(String string, String string2) {
        this.singulars.put(this.compile(string), string2);
    }

    private void irregular(String string, String string2) {
        this.irregulars.put(string, string2);
    }

    private Pattern compile(String string) {
        return Pattern.compile("(?i)" + string);
    }

    void uncountable(String ... stringArray) {
        for (String string : stringArray) {
            this.uncountables.add(string);
        }
    }

    private void init() {
        this.plural("(ax|test)is$", "$1es");
        this.plural("(octop|vir)us$", "$1i");
        this.plural("(alias|status)$", "$1es");
        this.plural("(bu)s$", "$1ses");
        this.plural("(buffal|tomat)o$", "$1oes");
        this.plural("([ti])um$", "$1a");
        this.plural("sis$", "ses");
        this.plural("(?:([^f])fe|([lr])f)$", "$1$2ves");
        this.plural("(hive)$", "$1s");
        this.plural("([^aeiouy]|qu)y$", "$1ies");
        this.plural("(matr|vert|ind)ix|ex$", "$1ices");
        this.plural("(x|ch|ss|sh)$", "$1es");
        this.plural("([m|l])ouse$", "$1ice");
        this.plural("^(ox)$", "$1en");
        this.plural("(quiz)$", "$1zes");
        this.plural("(.*p)erson$", "$1eople");
        this.plural("(.*c)riterion$", "$1riteria");
        this.plural("(.*m)an$", "$1en");
        this.plural("s$", "s");
        this.plural("$", "s");
        this.singular("(ax|test)es$", "$1is");
        this.singular("(n)ews$", "$1ews");
        this.singular("([ti])a$", "$1um");
        this.singular("((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)ses$", "$1$2sis");
        this.singular("(^analy)ses$", "$1sis");
        this.singular("([^f])ves$", "$1fe");
        this.singular("(hive)s$", "$1");
        this.singular("(tive)s$", "$1");
        this.singular("([lr])ves$", "$1f");
        this.singular("([^aeiouy]|qu)ies$", "$1y");
        this.singular("(s)eries$", "$1eries");
        this.singular("(m)ovies$", "$1ovie");
        this.singular("(x|ch|ss|sh)es$", "$1");
        this.singular("([m|l])ice$", "$1ouse");
        this.singular("(bus)es$", "$1");
        this.singular("(o)es$", "$1");
        this.singular("(shoe)s$", "$1");
        this.singular("(cris|ax|test)es$", "$1is");
        this.singular("(octop|vir)i$", "$1us");
        this.singular("(octop|vir)us$", "$1us");
        this.singular("(alias|status)es$", "$1");
        this.singular("^(ox)en", "$1");
        this.singular("(vert|ind)ices$", "$1ex");
        this.singular("(matr)ices$", "$1ix");
        this.singular("(quiz)zes$", "$1");
        this.singular("(database)s$", "$1");
        this.singular("(.*p)eople$", "$1erson");
        this.plural("(.*c)riteria$", "$1riterion");
        this.singular("(.*m)en$", "$1an");
        this.singular("s$", "");
        this.irregular("person", "people");
        this.irregular("man", "men");
        this.irregular("child", "children");
        this.irregular("sex", "sexes");
        this.irregular("move", "moves");
        this.irregular("cow", "kine");
        this.irregular("criterion", "criteria");
        this.uncountable("equipment", "information", "rice", "money", "species", "series", "fish", "sheep");
    }
}

