/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.lexer;

public class StateStack
implements Cloneable {
    public byte[] stack;
    private int lastIn = -1;

    public StateStack() {
        this(5);
    }

    public StateStack(int n) {
        this.stack = new byte[n];
        this.lastIn = -1;
    }

    public boolean isEmpty() {
        return this.lastIn == -1;
    }

    public int popStack() {
        byte by = this.stack[this.lastIn];
        --this.lastIn;
        return by;
    }

    public void pushStack(int n) {
        ++this.lastIn;
        if (this.lastIn == this.stack.length) {
            this.multiplySize();
        }
        this.stack[this.lastIn] = (byte)n;
    }

    private void multiplySize() {
        int n = this.stack.length;
        byte[] byArray = new byte[n * 2];
        System.arraycopy(this.stack, 0, byArray, 0, n);
        this.stack = byArray;
    }

    public int clear() {
        this.lastIn = -1;
        return -1;
    }

    public int size() {
        return this.lastIn + 1;
    }

    public StateStack createClone() {
        StateStack stateStack = new StateStack(this.size());
        stateStack.copyFrom(this);
        return stateStack;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof StateStack)) {
            return false;
        }
        StateStack stateStack = (StateStack)object;
        if (this.lastIn != stateStack.lastIn) {
            return false;
        }
        for (int i = this.lastIn; i >= 0; --i) {
            if (this.stack[i] == stateStack.stack[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 7;
        n = 31 * n + this.lastIn;
        for (int i = this.lastIn; i >= 0; --i) {
            n = 31 * n + this.stack[i];
        }
        return n;
    }

    public void copyFrom(StateStack stateStack) {
        while (stateStack.lastIn >= this.stack.length) {
            this.multiplySize();
        }
        this.lastIn = stateStack.lastIn;
        for (int i = 0; i <= stateStack.lastIn; ++i) {
            this.stack[i] = stateStack.stack[i];
        }
    }

    public boolean contains(int n) {
        for (int i = 0; i <= this.lastIn; ++i) {
            if (this.stack[i] != n) continue;
            return true;
        }
        return false;
    }

    public int get(int n) {
        return this.stack[n];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(50);
        for (int i = 0; i <= this.lastIn; ++i) {
            stringBuffer.append(" stack[" + i + "]= " + this.stack[i]);
        }
        return stringBuffer.toString();
    }
}

