/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.beaninfo.editors.HtmlBrowser;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class IDESettings {
    public static final String PROP_WWWBROWSER = "WWWBrowser";
    public static final String PROP_EXTERNAL_WWWBROWSER = "ExternalWWWBrowser";

    static Preferences getPreferences() {
        return NbPreferences.forModule(IDESettings.class);
    }

    public static HtmlBrowser.Factory getWWWBrowser() {
        return IDESettings.getBrowser(PROP_WWWBROWSER, false);
    }

    public static HtmlBrowser.Factory getExternalWWWBrowser() {
        return IDESettings.getBrowser(PROP_EXTERNAL_WWWBROWSER, true);
    }

    public static void setWWWBrowser(HtmlBrowser.Factory factory) {
        IDESettings.setBrowser(PROP_WWWBROWSER, factory);
        if (IDESettings.isExternal(factory)) {
            IDESettings.setExternalWWWBrowser(factory);
        }
    }

    public static void setExternalWWWBrowser(HtmlBrowser.Factory factory) {
        IDESettings.setBrowser(PROP_EXTERNAL_WWWBROWSER, factory);
    }

    private static void setBrowser(String string, HtmlBrowser.Factory factory) {
        try {
            if (factory == null) {
                IDESettings.getPreferences().put(string, "");
                return;
            }
            Lookup.Item item = Lookup.getDefault().lookupItem(new Lookup.Template(HtmlBrowser.Factory.class, null, (Object)factory));
            if (item != null) {
                IDESettings.getPreferences().put(string, item.getId());
            } else {
                Logger.getLogger(IDESettings.class.getName()).warning("IDESettings: Cannot find browser in lookup");
                IDESettings.getPreferences().put(string, "");
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    private static HtmlBrowser.Factory getBrowser(String string, boolean bl) {
        block8: {
            try {
                String string2 = IDESettings.getPreferences().get(string, null);
                if (string2 instanceof String && !"".equals(string2)) {
                    Lookup.Item item = Lookup.getDefault().lookupItem(new Lookup.Template(HtmlBrowser.Factory.class, string2, null));
                    return item == null ? null : (HtmlBrowser.Factory)item.getInstance();
                }
                if (string2 != null && !"".equals(string2)) break block8;
                Lookup.Result result = Lookup.getDefault().lookupResult(HtmlBrowser.Factory.class);
                for (HtmlBrowser.Factory factory : result.allInstances()) {
                    FileObject fileObject = FileUtil.getConfigFile((String)"Services/Browsers");
                    DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
                    DataObject[] dataObjectArray = dataFolder.getChildren();
                    for (int i = 0; i < dataObjectArray.length; ++i) {
                        Object object = null;
                        try {
                            InstanceCookie instanceCookie;
                            if (Boolean.TRUE.equals(dataObjectArray[i].getPrimaryFile().getAttribute("hidden")) || bl && Boolean.TRUE.equals(dataObjectArray[i].getPrimaryFile().getAttribute("internal")) || (instanceCookie = (InstanceCookie)dataObjectArray[i].getCookie(InstanceCookie.class)) == null || (object = instanceCookie.instanceCreate()) == null || !object.equals(factory)) continue;
                            return factory;
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(IDESettings.class.getName()).log(Level.WARNING, null, iOException);
                            continue;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            Logger.getLogger(IDESettings.class.getName()).log(Level.WARNING, null, classNotFoundException);
                        }
                    }
                }
                return null;
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    private static boolean isExternal(HtmlBrowser.Factory factory) {
        FileObject fileObject = FileUtil.getConfigFile((String)"Services/Browsers");
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        DataObject[] dataObjectArray = dataFolder.getChildren();
        for (int i = 0; i < dataObjectArray.length; ++i) {
            Object object = null;
            try {
                InstanceCookie instanceCookie;
                if (Boolean.TRUE.equals(dataObjectArray[i].getPrimaryFile().getAttribute("hidden")) || !Boolean.TRUE.equals(dataObjectArray[i].getPrimaryFile().getAttribute("internal")) || (instanceCookie = (InstanceCookie)dataObjectArray[i].getCookie(InstanceCookie.class)) == null || (object = instanceCookie.instanceCreate()) == null || !object.equals(factory)) continue;
                return false;
            }
            catch (IOException iOException) {
                Logger.getLogger(IDESettings.class.getName()).log(Level.WARNING, null, iOException);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger(IDESettings.class.getName()).log(Level.WARNING, null, classNotFoundException);
            }
        }
        return false;
    }

    private static HtmlBrowser.FactoryEditor createHtmlBrowserFactoryEditor() {
        return new HtmlBrowser.FactoryEditor(){

            public void setValue(Object object) {
                IDESettings.setWWWBrowser((HtmlBrowser.Factory)object);
            }

            public Object getValue() {
                return IDESettings.getWWWBrowser();
            }
        };
    }
}

