/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators.impl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.DataFilterListener;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataUtil;
import org.netbeans.modules.dlight.extras.api.ViewportAware;
import org.netbeans.modules.dlight.extras.api.ViewportModel;
import org.netbeans.modules.dlight.indicators.DataRowToTimeSeries;
import org.netbeans.modules.dlight.indicators.TimeSeriesIndicatorConfiguration;
import org.netbeans.modules.dlight.indicators.graph.GraphPanel;
import org.netbeans.modules.dlight.indicators.graph.Legend;
import org.netbeans.modules.dlight.indicators.graph.RepairPanel;
import org.netbeans.modules.dlight.indicators.graph.TimeSeriesDataContainer;
import org.netbeans.modules.dlight.indicators.graph.TimeSeriesIndicatorConfigurationAccessor;
import org.netbeans.modules.dlight.indicators.graph.TimeSeriesPlot;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.netbeans.modules.dlight.spi.indicator.IndicatorActionsProvider;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.util.UIUtilities;
import org.netbeans.modules.dlight.util.ui.DLightUIPrefs;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimeSeriesIndicator
extends Indicator<TimeSeriesIndicatorConfiguration>
implements ViewportAware,
DataFilterListener {
    private static final Logger log = DLightLogger.getLogger(TimeSeriesIndicator.class);
    private final DataRowToTimeSeries dataRowHandler;
    private final TimeSeriesDataContainer data;
    private GraphPanel<TimeSeriesPlot, Legend> panel;
    private TimeSeriesPlot graph;
    private Legend legend;
    private JButton button;
    private final int graphCount;
    private int tickCounter;
    private List<Action> popupActions;
    private volatile boolean isInitialized = false;
    private final TimeSeriesIndicatorConfiguration configuration;
    private final UILock uiLock = new UILock();

    public TimeSeriesIndicator(TimeSeriesIndicatorConfiguration timeSeriesIndicatorConfiguration) {
        super((IndicatorConfiguration)timeSeriesIndicatorConfiguration);
        this.configuration = timeSeriesIndicatorConfiguration;
        TimeSeriesIndicatorConfigurationAccessor timeSeriesIndicatorConfigurationAccessor = TimeSeriesIndicatorConfigurationAccessor.getDefault();
        this.dataRowHandler = timeSeriesIndicatorConfigurationAccessor.getDataRowHandler(timeSeriesIndicatorConfiguration);
        this.graphCount = timeSeriesIndicatorConfigurationAccessor.getTimeSeriesDescriptors(timeSeriesIndicatorConfiguration).size();
        this.data = new TimeSeriesDataContainer(timeSeriesIndicatorConfigurationAccessor.getGranularity(timeSeriesIndicatorConfiguration), timeSeriesIndicatorConfigurationAccessor.getAggregation(timeSeriesIndicatorConfiguration), this.graphCount, timeSeriesIndicatorConfigurationAccessor.getLastNonNull(timeSeriesIndicatorConfiguration));
        this.data.put(0L, new float[this.graphCount]);
    }

    protected void targetStarted() {
        this.legend.updateWithInfoProvided(this.getColumnsProvided());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initUI() {
        UILock uILock = this.uiLock;
        synchronized (uILock) {
            this.graph = TimeSeriesIndicator.createGraph(this.configuration, this.data);
            TimeSeriesIndicatorConfigurationAccessor timeSeriesIndicatorConfigurationAccessor = TimeSeriesIndicatorConfigurationAccessor.getDefault();
            this.legend = new Legend(timeSeriesIndicatorConfigurationAccessor.getTimeSeriesDescriptors(this.configuration), timeSeriesIndicatorConfigurationAccessor.getDetailDescriptors(this.configuration));
            this.button = this.getDefaultAction().isEnabled() ? new JButton(this.getDefaultAction()) : null;
            this.panel = new GraphPanel<TimeSeriesPlot, Legend>(timeSeriesIndicatorConfigurationAccessor.getTitle(this.configuration), this.graph, this.legend, this.graph.getHorizontalAxis(), this.graph.getVerticalAxis(), this.button);
            this.panel.setPopupActions(this.popupActions);
            this.isInitialized = true;
        }
    }

    private static TimeSeriesPlot createGraph(TimeSeriesIndicatorConfiguration timeSeriesIndicatorConfiguration, TimeSeriesDataContainer timeSeriesDataContainer) {
        TimeSeriesIndicatorConfigurationAccessor timeSeriesIndicatorConfigurationAccessor = TimeSeriesIndicatorConfigurationAccessor.getDefault();
        TimeSeriesPlot timeSeriesPlot = new TimeSeriesPlot(timeSeriesIndicatorConfigurationAccessor.getGraphScale(timeSeriesIndicatorConfiguration), timeSeriesIndicatorConfigurationAccessor.getLabelRenderer(timeSeriesIndicatorConfiguration), timeSeriesIndicatorConfigurationAccessor.getTimeSeriesDescriptors(timeSeriesIndicatorConfiguration), timeSeriesDataContainer);
        timeSeriesPlot.setBorder(BorderFactory.createLineBorder(DLightUIPrefs.getColor((String)"indicator.border.color")));
        Dimension dimension = new Dimension(DLightUIPrefs.getInt((String)"indicator.graph.width"), DLightUIPrefs.getInt((String)"indicator.graph.height"));
        timeSeriesPlot.setMinimumSize(dimension);
        timeSeriesPlot.setPreferredSize(dimension);
        Dimension dimension2 = new Dimension(DLightUIPrefs.getInt((String)"indicator.y_axis.width"), DLightUIPrefs.getInt((String)"indicator.y_axis.height"));
        timeSeriesPlot.getVerticalAxis().setMinimumSize(dimension2);
        timeSeriesPlot.getVerticalAxis().setPreferredSize(dimension2);
        Dimension dimension3 = new Dimension(DLightUIPrefs.getInt((String)"indicator.x_axis.width"), DLightUIPrefs.getInt((String)"indicator.x_axis.height"));
        timeSeriesPlot.getHorizontalAxis().setMinimumSize(dimension3);
        timeSeriesPlot.getHorizontalAxis().setPreferredSize(dimension3);
        return timeSeriesPlot;
    }

    public ViewportModel getViewportModel() {
        return this.graph.getViewportModel();
    }

    public void setViewportModel(ViewportModel viewportModel) {
        this.graph.setViewportModel(viewportModel);
    }

    protected void repairNeeded(boolean bl) {
        if (bl) {
            final RepairPanel repairPanel = new RepairPanel(this.getRepairActionProvider().getValidationStatus());
            repairPanel.setPopupActions(this.popupActions);
            repairPanel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    final Future future = TimeSeriesIndicator.this.getRepairActionProvider().asyncRepair();
                    DLightExecutorService.submit((Callable)new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            UIThread.invoke((Runnable)new Runnable(){

                                public void run() {
                                    repairPanel.setEnabled(false);
                                }
                            });
                            Boolean bl = (Boolean)future.get();
                            UIThread.invoke((Runnable)new Runnable(){

                                public void run() {
                                    repairPanel.setEnabled(true);
                                }
                            });
                            return bl;
                        }
                    }, (String)"Click On Indicator task");
                }
            });
            UIThread.invoke((Runnable)new Runnable(){

                public void run() {
                    TimeSeriesIndicator.this.panel.setOverlay(repairPanel);
                }
            });
        } else {
            final JEditorPane jEditorPane = UIUtilities.createJEditorPane((String)this.getRepairActionProvider().getMessage(this.getRepairActionProvider().getValidationStatus()), (boolean)false, (Color)DLightUIPrefs.getColor((String)"indicator.legend.font.color"));
            UIThread.invoke((Runnable)new Runnable(){

                public void run() {
                    TimeSeriesIndicator.this.panel.setOverlay(jEditorPane);
                }
            });
        }
    }

    protected void tick() {
        ++this.tickCounter;
        this.data.grow(this.tickCounter);
        this.refresh();
    }

    public void updated(List<DataRow> list) {
        for (DataRow dataRow : list) {
            try {
                float[] fArray = this.dataRowHandler.getData(dataRow);
                if (fArray == null) continue;
                long l = DataUtil.getTimestamp((DataRow)dataRow);
                this.data.put(0L <= l ? l : 1000000000L * (long)this.tickCounter, fArray);
            }
            catch (Exception exception) {
                if (!log.isLoggable(Level.WARNING)) continue;
                log.log(Level.WARNING, "Exception while updating indicator", exception);
            }
        }
    }

    public void suggestRepaint() {
        this.refresh();
    }

    private void refresh() {
        for (Map.Entry<String, String> entry : this.dataRowHandler.getDetails().entrySet()) {
            this.legend.updateDetail(entry.getKey(), entry.getValue());
        }
        this.graph.repaintAll();
    }

    public void reset() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JComponent getComponent() {
        UILock uILock = this.uiLock;
        synchronized (uILock) {
            if (!this.isInitialized) {
                this.initUI();
            }
        }
        return this.panel;
    }

    public void dataFiltersChanged(List<DataFilter> list, boolean bl) {
        this.graph.dataFiltersChanged(list, bl);
    }

    public void setIndicatorActionsProviderContext(Lookup lookup) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        for (IndicatorActionsProvider indicatorActionsProvider : Lookup.getDefault().lookupAll(IndicatorActionsProvider.class)) {
            arrayList.addAll(indicatorActionsProvider.getIndicatorActions(lookup));
        }
        if (this.panel != null) {
            this.panel.setPopupActions(arrayList);
        }
        this.popupActions = arrayList;
    }

    private static final class UILock {
        private UILock() {
        }
    }
}

