/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.xml.cookies;

import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.netbeans.api.xml.cookies.XMLProcessorDetail;
import org.netbeans.spi.xml.cookies.Util;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultXMLProcessorDetail
extends XMLProcessorDetail {
    private int columnNumber;
    private int lineNumber;
    private String publicId;
    private String systemId;
    private Exception exception;

    public DefaultXMLProcessorDetail(SAXParseException sAXParseException) {
        if (sAXParseException == null) {
            throw new NullPointerException();
        }
        this.exception = sAXParseException;
        this.columnNumber = sAXParseException.getColumnNumber();
        this.lineNumber = sAXParseException.getLineNumber();
        this.publicId = sAXParseException.getPublicId();
        this.systemId = sAXParseException.getSystemId();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("DefaultXMLProcessorDetail: SAXParseException");
            Util.THIS.debug("    exception= " + this.exception);
            Util.THIS.debug("    columnNumber= " + this.columnNumber);
            Util.THIS.debug("    lineNumber= " + this.lineNumber);
            Util.THIS.debug("    publicId= " + this.publicId);
            Util.THIS.debug("    systemId= " + this.systemId);
        }
    }

    public DefaultXMLProcessorDetail(TransformerException transformerException) {
        if (transformerException == null) {
            throw new NullPointerException();
        }
        this.exception = transformerException;
        SourceLocator sourceLocator = transformerException.getLocator();
        if (sourceLocator != null) {
            this.columnNumber = sourceLocator.getColumnNumber();
            this.lineNumber = sourceLocator.getLineNumber();
            this.publicId = sourceLocator.getPublicId();
            this.systemId = sourceLocator.getSystemId();
            if (this.lineNumber == -1) {
                this.tryWrappedLocator(transformerException);
            }
        } else {
            this.columnNumber = -1;
            this.lineNumber = -1;
            this.publicId = null;
            this.systemId = null;
            this.tryWrappedLocator(transformerException);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("DefaultXMLProcessorDetail: TransformerException");
            Util.THIS.debug("    exception= " + this.exception);
            Util.THIS.debug("    columnNumber= " + this.columnNumber);
            Util.THIS.debug("    lineNumber= " + this.lineNumber);
            Util.THIS.debug("    publicId= " + this.publicId);
            Util.THIS.debug("    systemId= " + this.systemId);
        }
    }

    private void tryWrappedLocator(Exception exception) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("DefaultXMLProcessorDetail.tryWrappedLocator: " + exception);
        }
        Throwable throwable = null;
        if (exception instanceof TransformerException) {
            throwable = ((TransformerException)exception).getException();
        } else if (exception instanceof SAXException) {
            throwable = ((SAXException)exception).getException();
        } else {
            return;
        }
        if (throwable instanceof SAXParseException) {
            SAXParseException sAXParseException = (SAXParseException)throwable;
            if (sAXParseException.getLineNumber() == -1) {
                this.tryWrappedLocator(sAXParseException);
            } else {
                this.columnNumber = sAXParseException.getColumnNumber();
                this.lineNumber = sAXParseException.getLineNumber();
                this.publicId = sAXParseException.getPublicId();
                this.systemId = sAXParseException.getSystemId();
            }
        } else if (throwable instanceof TransformerException) {
            TransformerException transformerException = (TransformerException)throwable;
            SourceLocator sourceLocator = transformerException.getLocator();
            if (sourceLocator == null) {
                this.tryWrappedLocator(transformerException);
            } else if (sourceLocator.getLineNumber() == -1) {
                this.tryWrappedLocator(transformerException);
            } else {
                this.columnNumber = sourceLocator.getColumnNumber();
                this.lineNumber = sourceLocator.getLineNumber();
                this.publicId = sourceLocator.getPublicId();
                this.systemId = sourceLocator.getSystemId();
            }
        } else if (throwable instanceof SAXException) {
            this.tryWrappedLocator((SAXException)throwable);
        }
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public Exception getException() {
        return this.exception;
    }
}

