/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUsingDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUsingDirective;
import org.netbeans.modules.cnd.api.model.deep.CsmDeclarationStatement;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.services.CsmUsingResolver;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.impl.services.UsingResolverImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileElementsCollector {
    private final CsmFile destFile;
    private int startOffset;
    private int destOffset;
    private final CsmProject onlyInProject;
    private final LinkedHashSet<CsmNamespace> globalDirectVisibleNamespaces = new LinkedHashSet();
    private final LinkedHashSet<CsmUsingDirective> globalUsingNamespaces = new LinkedHashSet();
    private final LinkedHashSet<CsmNamespaceAlias> globalNamespaceAliases = new LinkedHashSet();
    private final LinkedHashSet<CsmUsingDeclaration> globalUsingDeclarations = new LinkedHashSet();
    private LinkedHashSet<CsmNamespace> localDirectVisibleNamespaces = new LinkedHashSet();
    private LinkedHashSet<CsmUsingDirective> localUsingNamespaces = new LinkedHashSet();
    private LinkedHashSet<CsmNamespaceAlias> localNamespaceAliases = new LinkedHashSet();
    private LinkedHashSet<CsmUsingDeclaration> localUsingDeclarations = new LinkedHashSet();
    private final LinkedHashSet<CsmNamespaceDefinition> globalDirectVisibleNamespaceDefinitions = new LinkedHashSet();
    private LinkedHashSet<CsmNamespaceDefinition> localDirectVisibleNamespaceDefinitions = new LinkedHashSet();
    private Collection<CsmDeclaration> visibleUsedDeclarations = null;
    private Collection<CsmNamespace> visibleNamespaces = null;
    private boolean mapsGathered = false;

    public FileElementsCollector(CsmFile csmFile, int n, CsmProject csmProject) {
        this.destFile = csmFile;
        this.destOffset = n;
        this.startOffset = 0;
        this.onlyInProject = csmProject;
    }

    public synchronized void incrementOffset(int n) {
        if (this.mapsGathered) {
            this.startOffset = this.destOffset;
        }
        this.destOffset = n;
        if (this.startOffset < this.destOffset) {
            this.mapsGathered = false;
            this.visibleUsedDeclarations = null;
            this.visibleNamespaces = null;
            this.localDirectVisibleNamespaceDefinitions = new LinkedHashSet();
            this.localDirectVisibleNamespaces = new LinkedHashSet();
            this.localUsingNamespaces = new LinkedHashSet();
            this.localNamespaceAliases = new LinkedHashSet();
            this.localUsingDeclarations = new LinkedHashSet();
        } else if (this.startOffset > this.destOffset) {
            throw new IllegalArgumentException("Start offset " + this.startOffset + " > destination offset " + this.destOffset);
        }
    }

    public Collection<CsmUsingDeclaration> getUsingDeclarations() {
        this.initMaps();
        LinkedHashSet<CsmUsingDeclaration> linkedHashSet = new LinkedHashSet<CsmUsingDeclaration>();
        linkedHashSet.addAll(this.globalUsingDeclarations);
        linkedHashSet.addAll(this.localUsingDeclarations);
        return Collections.unmodifiableCollection(linkedHashSet);
    }

    public Collection<CsmUsingDirective> getUsingDirectives() {
        this.initMaps();
        LinkedHashSet<CsmUsingDirective> linkedHashSet = new LinkedHashSet<CsmUsingDirective>();
        linkedHashSet.addAll(this.globalUsingNamespaces);
        linkedHashSet.addAll(this.localUsingNamespaces);
        return Collections.unmodifiableCollection(linkedHashSet);
    }

    public Collection<CsmNamespaceAlias> getNamespaceAliases() {
        this.initMaps();
        LinkedHashSet<CsmNamespaceAlias> linkedHashSet = new LinkedHashSet<CsmNamespaceAlias>();
        linkedHashSet.addAll(this.globalNamespaceAliases);
        linkedHashSet.addAll(this.localNamespaceAliases);
        return Collections.unmodifiableCollection(linkedHashSet);
    }

    public Collection<CsmDeclaration> getUsedDeclarations() {
        this.initMaps();
        return this._getUsedDeclarations();
    }

    private synchronized Collection<CsmDeclaration> _getUsedDeclarations() {
        Collection collection = this.visibleUsedDeclarations;
        if (collection == null) {
            collection = CsmUsingResolver.extractDeclarations(this.globalUsingDeclarations);
            collection.addAll(CsmUsingResolver.extractDeclarations(this.localUsingDeclarations));
            this.visibleUsedDeclarations = collection;
        }
        return Collections.unmodifiableCollection(collection);
    }

    public Collection<CsmNamespace> getVisibleNamespaces() {
        this.initMaps();
        return this._getVisibleNamespaces();
    }

    public synchronized Collection<CsmNamespace> _getVisibleNamespaces() {
        Collection<CsmNamespace> collection = this.visibleNamespaces;
        if (collection == null) {
            collection = UsingResolverImpl.extractNamespaces(this.globalUsingNamespaces, this.destFile.getProject());
            collection.addAll(UsingResolverImpl.extractNamespaces(this.localUsingNamespaces, this.destFile.getProject()));
            collection.addAll(this.globalDirectVisibleNamespaces);
            collection.addAll(this.localDirectVisibleNamespaces);
            this.visibleNamespaces = collection;
        }
        return Collections.unmodifiableCollection(collection);
    }

    private synchronized void initMaps() {
        if (this.mapsGathered) {
            return;
        }
        this.mapsGathered = true;
        this.gatherFileMaps(this.destFile);
    }

    protected void gatherFileMaps(CsmFile csmFile) {
        this.gatherFileMaps(new HashSet<CsmFile>(), csmFile, this.startOffset, this.destOffset);
    }

    protected void gatherFileMaps(Set<CsmFile> set, CsmFile csmFile, int n, int n2) {
        if (set.contains(csmFile)) {
            return;
        }
        set.add(csmFile);
        CsmSelect.CsmFilter csmFilter = CsmSelect.getFilterBuilder().createOffsetFilter(n, n2);
        Iterator iterator = CsmSelect.getIncludes((CsmFile)csmFile, (CsmSelect.CsmFilter)csmFilter);
        while (iterator.hasNext()) {
            CsmFile csmFile2;
            CsmInclude csmInclude = (CsmInclude)iterator.next();
            if (csmInclude.getStartOffset() < n || csmInclude.getEndOffset() >= n2 || (csmFile2 = csmInclude.getIncludeFile()) == null || this.onlyInProject != null && csmFile2.getProject() != this.onlyInProject) continue;
            this.gatherFileMaps(set, csmFile2, 0, Integer.MAX_VALUE);
        }
        this.gatherDeclarationsMaps(CsmSelect.getDeclarations((CsmFile)csmFile, (CsmSelect.CsmFilter)csmFilter), n, n2, true);
    }

    protected void gatherDeclarationsMaps(Iterable iterable, int n, int n2, boolean bl) {
        this.gatherDeclarationsMaps(iterable.iterator(), n, n2, bl);
    }

    protected void gatherDeclarationsMaps(Iterator iterator, int n, int n2, boolean bl) {
        while (iterator.hasNext()) {
            CsmOffsetable csmOffsetable = (CsmOffsetable)iterator.next();
            try {
                int n3 = csmOffsetable.getStartOffset();
                int n4 = csmOffsetable.getEndOffset();
                if (n4 < n) continue;
                if (n3 >= n2) break;
                if (CsmKindUtilities.isScopeElement((CsmObject)csmOffsetable)) {
                    this.gatherScopeElementMaps((CsmScopeElement)csmOffsetable, n4, n2, bl);
                    continue;
                }
                if (!FileImpl.reportErrors) continue;
                System.err.println("Expected CsmScopeElement, got " + csmOffsetable);
            }
            catch (NullPointerException nullPointerException) {
                if (!FileImpl.reportErrors) continue;
                System.err.println("Unexpected NULL element in declarations collection");
                DiagnosticExceptoins.register(nullPointerException);
            }
        }
    }

    protected void gatherScopeElementMaps(CsmScopeElement csmScopeElement, int n, int n2, boolean bl) {
        CsmDeclaration.Kind kind;
        CsmDeclaration.Kind kind2 = kind = CsmKindUtilities.isDeclaration((CsmObject)csmScopeElement) ? ((CsmDeclaration)csmScopeElement).getKind() : null;
        if (kind == CsmDeclaration.Kind.NAMESPACE_DEFINITION) {
            CsmNamespaceDefinition csmNamespaceDefinition = (CsmNamespaceDefinition)csmScopeElement;
            if (csmNamespaceDefinition.getName().length() == 0) {
                if (bl) {
                    this.globalDirectVisibleNamespaces.add(csmNamespaceDefinition.getNamespace());
                } else {
                    this.localDirectVisibleNamespaces.add(csmNamespaceDefinition.getNamespace());
                }
            }
            if (n2 < n) {
                this.localDirectVisibleNamespaces.remove(csmNamespaceDefinition.getNamespace());
                this.localDirectVisibleNamespaces.add(csmNamespaceDefinition.getNamespace());
                this.gatherLocalNamespaceElementsFromMaps(csmNamespaceDefinition, 0, n2, bl);
                this.gatherDeclarationsMaps(csmNamespaceDefinition.getDeclarations(), 0, n2, false);
            }
            if (bl) {
                this.globalDirectVisibleNamespaceDefinitions.add(csmNamespaceDefinition);
            } else {
                this.localDirectVisibleNamespaceDefinitions.add(csmNamespaceDefinition);
            }
        } else if (kind == CsmDeclaration.Kind.NAMESPACE_ALIAS) {
            CsmNamespaceAlias csmNamespaceAlias = (CsmNamespaceAlias)csmScopeElement;
            if (bl) {
                this.globalNamespaceAliases.add(csmNamespaceAlias);
            } else {
                this.localNamespaceAliases.add(csmNamespaceAlias);
            }
        } else if (kind == CsmDeclaration.Kind.USING_DECLARATION) {
            CsmUsingDeclaration csmUsingDeclaration = (CsmUsingDeclaration)csmScopeElement;
            if (bl) {
                this.globalUsingDeclarations.add(csmUsingDeclaration);
            } else {
                this.localUsingDeclarations.add(csmUsingDeclaration);
            }
        } else if (kind == CsmDeclaration.Kind.USING_DIRECTIVE) {
            CsmUsingDirective csmUsingDirective = (CsmUsingDirective)csmScopeElement;
            if (bl) {
                this.globalUsingNamespaces.add(csmUsingDirective);
            } else {
                this.localUsingNamespaces.add(csmUsingDirective);
            }
        } else if (CsmKindUtilities.isDeclarationStatement((CsmObject)csmScopeElement)) {
            CsmDeclarationStatement csmDeclarationStatement = (CsmDeclarationStatement)csmScopeElement;
            if (csmDeclarationStatement.getStartOffset() < n2) {
                this.gatherDeclarationsMaps(((CsmDeclarationStatement)csmScopeElement).getDeclarators(), 0, n2, false);
            }
        } else if (CsmKindUtilities.isScope((CsmObject)csmScopeElement) && n2 < n) {
            this.gatherDeclarationsMaps(((CsmScope)csmScopeElement).getScopeElements(), 0, n2, false);
        }
    }

    protected void gatherLocalNamespaceElementsFromMaps(CsmNamespaceDefinition csmNamespaceDefinition, int n, int n2, boolean bl) {
        CharSequence charSequence = csmNamespaceDefinition.getQualifiedName();
        if (bl) {
            for (CsmNamespaceDefinition csmNamespaceDefinition2 : this.globalDirectVisibleNamespaceDefinitions) {
                if (!csmNamespaceDefinition2.getQualifiedName().equals(charSequence)) continue;
                this.gatherDeclarationsMaps(csmNamespaceDefinition2.getDeclarations(), 0, Integer.MAX_VALUE, false);
            }
        } else {
            LinkedHashSet<CsmNamespaceDefinition> linkedHashSet = new LinkedHashSet<CsmNamespaceDefinition>(this.localDirectVisibleNamespaceDefinitions);
            for (CsmNamespaceDefinition csmNamespaceDefinition3 : linkedHashSet) {
                if (!csmNamespaceDefinition3.getQualifiedName().equals(charSequence)) continue;
                this.gatherDeclarationsMaps(csmNamespaceDefinition3.getDeclarations(), 0, Integer.MAX_VALUE, false);
            }
        }
    }
}

