/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.webservices.ui.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.websvc.core.webservices.ui.panels.ClientExplorerPanel;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ProjectFileExplorer
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private DialogDescriptor descriptor;
    private ExplorerManager manager;
    private BeanTreeView treeView;
    private DataObject selectedFolder;
    private Project[] projects = OpenProjects.getDefault().getOpenProjects();
    private Children rootChildren = new Children.Array();
    private Node explorerClientRoot = new AbstractNode(this.rootChildren);
    private List<Node> projectNodeList = new ArrayList<Node>();
    private JCheckBox dontCopyCB;
    private JLabel jLblTreeView;

    public ProjectFileExplorer() {
        this.manager = new ExplorerManager();
        this.initComponents();
        this.initUserComponents();
    }

    private void initComponents() {
        this.dontCopyCB = new JCheckBox();
        this.jLblTreeView = new JLabel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.dontCopyCB, (String)NbBundle.getMessage(ProjectFileExplorer.class, (String)"TXT_DONOTCOPY"));
        this.dontCopyCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectFileExplorer.this.dontCopyCBActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add((Component)this.dontCopyCB, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLblTreeView, (String)NbBundle.getMessage(ProjectFileExplorer.class, (String)"LBL_SelectProjectLocation"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add((Component)this.jLblTreeView, gridBagConstraints);
    }

    private String getTreeViewLabel(boolean bl) {
        if (bl) {
            return NbBundle.getMessage(ProjectFileExplorer.class, (String)"TXT_DONOTCOPY_TOOLTIP");
        }
        return NbBundle.getMessage(ProjectFileExplorer.class, (String)"LBL_SelectProjectLocation");
    }

    private void dontCopyCBActionPerformed(ActionEvent actionEvent) {
        if (this.dontCopyCB.isSelected()) {
            this.descriptor.setValid(true);
            this.treeView.setEnabled(false);
            this.jLblTreeView.setText(this.getTreeViewLabel(true));
        } else if (this.getSelectedFile() == null) {
            this.descriptor.setValid(false);
            this.treeView.setEnabled(true);
            this.jLblTreeView.setText(this.getTreeViewLabel(false));
        } else {
            this.descriptor.setValid(true);
            this.treeView.setEnabled(true);
            this.jLblTreeView.setText(this.getTreeViewLabel(false));
        }
    }

    private void initUserComponents() {
        this.treeView = new BeanTreeView();
        this.treeView.setRootVisible(false);
        this.treeView.setPopupAllowed(false);
        this.treeView.setSelectionMode(1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.treeView, gridBagConstraints);
        this.jLblTreeView.setLabelFor(this.treeView.getViewport().getView());
        this.treeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientExplorerPanel.class, (String)"ACSD_AvailableWebServicesTree"));
        this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientExplorerPanel.class, (String)"ACSD_AvailableWebServicesTree"));
        this.dontCopyCB.setToolTipText(NbBundle.getMessage(ProjectFileExplorer.class, (String)"TXT_DONOTCOPY_TOOLTIP"));
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void addNotify() {
        super.addNotify();
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        for (int i = 0; i < this.projects.length; ++i) {
            try {
                Project project = this.projects[i];
                FileObject fileObject = project.getProjectDirectory();
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                Node node = dataObject.getNodeDelegate();
                FilterNode filterNode = new FilterNode(node);
                this.projectNodeList.add((Node)filterNode);
                continue;
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
            }
        }
        Node[] nodeArray = new Node[this.projectNodeList.size()];
        this.projectNodeList.toArray(nodeArray);
        this.rootChildren.add(nodeArray);
        this.manager.setRootContext(this.explorerClientRoot);
        this.descriptor.setValid(false);
    }

    public void removeNotify() {
        this.manager.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeNotify();
    }

    public void setDescriptor(DialogDescriptor dialogDescriptor) {
        this.descriptor = dialogDescriptor;
    }

    public boolean dontCopy() {
        return this.dontCopyCB.isSelected();
    }

    public DataObject getSelectedFolder() {
        return this.selectedFolder;
    }

    private DataObject getSelectedFile() {
        Node node;
        DataObject dataObject;
        Node[] nodeArray = this.manager.getSelectedNodes();
        if (nodeArray != null && nodeArray.length > 0 && (dataObject = (DataObject)(node = nodeArray[0]).getLookup().lookup(DataObject.class)) != null && dataObject.getPrimaryFile().isFolder()) {
            return dataObject;
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.manager && "selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            DataObject dataObject = this.getSelectedFile();
            if (dataObject != null) {
                this.selectedFolder = dataObject;
                this.descriptor.setValid(true);
            } else {
                this.selectedFolder = null;
                this.descriptor.setValid(false);
            }
        }
    }
}

