/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.projects;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.persistence.api.PersistenceLocation;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.support.SourceGroups;
import org.netbeans.modules.websvc.spi.jaxws.client.ProjectJAXWSClientSupport;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class J2SEProjectJAXWSClientSupport
extends ProjectJAXWSClientSupport {
    private Project project;
    private static final String WSDL_FOLDER = "wsdl";
    private static final String KEY_PROXY_HOST = "http.proxyHost";
    private static final String KEY_PROXY_PORT = "http.proxyPort";
    private static final String KEY_NON_PROXY_HOSTS = "http.nonProxyHosts";
    private static final String KEY_HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String KEY_HTTPS_PROXY_PORT = "https.proxyPort";
    private static final String KEY_HTTPS_NON_PROXY_HOSTS = "https.nonProxyHosts";
    private static final String HTTP_PROXY_HOST_OPTION = "-Dhttp.proxyHost";
    private static final String HTTP_PROXY_PORT_OPTION = "-Dhttp.proxyPort";
    private static final String HTTP_NON_PROXY_HOSTS_OPTION = "-Dhttp.nonProxyHosts";
    private static final String HTTPS_PROXY_HOST_OPTION = "-Dhttps.proxyHost";
    private static final String HTTPS_PROXY_PORT_OPTION = "-Dhttps.proxyPort";
    private static final String HTTPS_NON_PROXY_HOSTS_OPTION = "-Dhttps.nonProxyHosts";
    private static final String RUN_JVM_ARGS = "run.jvmargs";

    public J2SEProjectJAXWSClientSupport(Project project) {
        super(project);
        this.project = project;
    }

    public FileObject getWsdlFolder(boolean bl) throws IOException {
        if (bl) {
            FileObject fileObject = PersistenceLocation.createLocation((Project)this.project);
            if (fileObject != null) {
                return FileUtil.createFolder((FileObject)fileObject, (String)WSDL_FOLDER);
            }
        } else {
            FileObject fileObject = PersistenceLocation.getLocation((Project)this.project);
            if (fileObject != null) {
                return fileObject.getFileObject(WSDL_FOLDER);
            }
        }
        return null;
    }

    public String addServiceClient(String string, String string2, String string3, boolean bl) {
        String string4 = super.addServiceClient(string, string2, string3, false);
        if (string4 != null) {
            this.addJVMOptions(string);
        }
        return string4;
    }

    protected void addJaxWs20Library() {
        ClassPath classPath;
        Library library;
        FileObject fileObject;
        ClassPath classPath2 = null;
        SourceGroup[] sourceGroupArray = SourceGroups.getJavaSourceGroups((Project)this.project);
        if (sourceGroupArray != null && sourceGroupArray.length > 0) {
            fileObject = sourceGroupArray[0].getRootFolder();
            library = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
            classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
            classPath2 = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{library, classPath});
            try {
                this.addJaxWsApiEndorsed(fileObject);
            }
            catch (IOException iOException) {
                Logger.getLogger(J2SEProjectJAXWSClientSupport.class.getName()).log(Level.FINE, "Cannot add JAX-WS-ENDORSED classpath", iOException);
            }
        }
        fileObject = null;
        if (classPath2 != null) {
            fileObject = classPath2.findResource("javax/xml/ws/WebServiceFeature.class");
        }
        if (fileObject == null) {
            library = LibraryManager.getDefault().getLibrary("metro");
            if (sourceGroupArray.length > 0 && library != null) {
                try {
                    ProjectClassPathModifier.addLibraries((Library[])new Library[]{library}, (FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/compile");
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().log(iOException.getMessage());
                }
                classPath = null;
                if (classPath2 != null) {
                    classPath = classPath2.findResource("com/sun/xml/rpc/tools/ant/Wscompile.class");
                }
                if (classPath != null) {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2SEProjectJAXWSClientSupport.class, (String)"MSG_RemoveJAX-RPC"), 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
            }
        }
    }

    private void addJVMOptions(final String string) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                EditableProperties editableProperties = null;
                EditableProperties editableProperties2 = null;
                try {
                    editableProperties = WSUtils.getEditableProperties((Project)J2SEProjectJAXWSClientSupport.this.project, (String)"nbproject/project.properties");
                    editableProperties2 = WSUtils.getEditableProperties((Project)J2SEProjectJAXWSClientSupport.this.project, (String)"nbproject/private/private.properties");
                    assert (editableProperties != null);
                    assert (editableProperties2 != null);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
                boolean bl = J2SEProjectJAXWSClientSupport.this.addJVMProxyOptions(editableProperties);
                if (bl) {
                    try {
                        WSUtils.storeEditableProperties((Project)J2SEProjectJAXWSClientSupport.this.project, (String)"nbproject/project.properties", (EditableProperties)editableProperties);
                        ProjectManager.getDefault().saveProject(J2SEProjectJAXWSClientSupport.this.project);
                    }
                    catch (IOException iOException) {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2SEProjectJAXWSClientSupport.class, (String)"MSG_ErrorSavingOnWSClientAdd", (Object)string, (Object)iOException.getLocalizedMessage()), 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    }
                }
            }
        });
    }

    private boolean addJVMProxyOptions(EditableProperties editableProperties) {
        assert (editableProperties != null);
        boolean bl = false;
        String string = System.getProperty(KEY_PROXY_HOST);
        if (string != null && string.length() > 0) {
            String string2 = System.getProperty(KEY_PROXY_PORT);
            if (string2 == null || string2.length() == 0) {
                string2 = "8080";
            }
            String string3 = "";
            string3 = this.getDefaultNonProxyHosts();
            String string4 = editableProperties.getProperty(RUN_JVM_ARGS);
            if (string4 == null || string4.length() == 0) {
                string4 = "-Dhttp.proxyHost=" + string + " " + HTTP_PROXY_PORT_OPTION + "=" + string2 + " " + HTTP_NON_PROXY_HOSTS_OPTION + "=" + string3 + " " + HTTPS_PROXY_HOST_OPTION + "=" + string + " " + HTTPS_PROXY_PORT_OPTION + "=" + string2 + " " + HTTPS_NON_PROXY_HOSTS_OPTION + "=" + string3;
                bl = true;
            } else {
                if (string4.indexOf(HTTP_PROXY_HOST_OPTION) < 0) {
                    string4 = string4 + " -Dhttp.proxyHost=" + string;
                    bl = true;
                }
                if (string4.indexOf(HTTP_PROXY_PORT_OPTION) < 0) {
                    string4 = string4 + " -Dhttp.proxyPort=" + string2;
                    bl = true;
                }
                if (string4.indexOf(HTTP_NON_PROXY_HOSTS_OPTION) < 0) {
                    string4 = string4 + " -Dhttp.nonProxyHosts=" + string3;
                    bl = true;
                }
                if (string4.indexOf(HTTPS_PROXY_HOST_OPTION) < 0) {
                    string4 = string4 + " -Dhttps.proxyHost=" + string;
                    bl = true;
                }
                if (string4.indexOf(HTTPS_PROXY_PORT_OPTION) < 0) {
                    string4 = string4 + " -Dhttps.proxyPort=" + string2;
                    bl = true;
                }
                if (string4.indexOf(HTTPS_NON_PROXY_HOSTS_OPTION) < 0) {
                    string4 = string4 + " -Dhttps.nonProxyHosts=" + string3;
                    bl = true;
                }
            }
            if (bl) {
                editableProperties.setProperty(RUN_JVM_ARGS, string4);
            }
        }
        return bl;
    }

    public void addJaxWsApiEndorsed(FileObject fileObject) throws IOException {
        String string = System.getProperty("java.version");
        if (string.compareTo("1.6") >= 0) {
            WSUtils.addJaxWsApiEndorsed((Project)this.project, (FileObject)fileObject);
        }
    }

    private String getDefaultNonProxyHosts() {
        String string = "localhost|127.0.0.1";
        String string2 = "";
        try {
            string2 = InetAddress.getLocalHost().getHostName();
            if (!string2.equals("localhost")) {
                string = string + "|" + string2;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        try {
            String string3 = InetAddress.getLocalHost().getCanonicalHostName();
            if (!string3.equals("localhost") && !string3.equals(string2)) {
                string = string + "|" + string3;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return string;
    }
}

