/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.modules.derby.DerbyOptions;
import org.netbeans.modules.derby.ui.DerbyPropertiesPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class Util {
    private static final String DERBY_CLIENT = "derbyclient.jar";

    private Util() {
    }

    public static boolean hasInstallLocation() {
        return Util.getCheckedLocation() != null;
    }

    public static boolean checkInstallLocation() {
        if (!Util.hasInstallLocation()) {
            Util.showInformation(NbBundle.getMessage(Util.class, (String)"MSG_DerbyLocationIncorrect"));
            return false;
        }
        return true;
    }

    private static File getCheckedLocation() {
        File file = new File(DerbyOptions.getDefault().getLocation());
        if (file.isAbsolute() && file.isDirectory() && file.exists()) {
            return file;
        }
        return null;
    }

    public static File getDerbyFile(String string) {
        File file = Util.getCheckedLocation();
        if (file != null) {
            return new File(file, string);
        }
        return null;
    }

    public static boolean ensureSystemHome() {
        if (DerbyOptions.getDefault().getSystemHome().length() <= 0) {
            return (Boolean)Mutex.EVENT.writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){

                public Boolean run() {
                    return DerbyPropertiesPanel.showDerbyProperties();
                }
            });
        }
        return true;
    }

    public static void showInformation(final String string) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        });
    }

    public static boolean isDerbyInstallLocation(File file) {
        File file2 = new File(file, "lib");
        if (!file2.exists()) {
            return false;
        }
        File[] fileArray = file2.listFiles();
        if (fileArray == null || fileArray.length <= 0) {
            return false;
        }
        for (File file3 : fileArray) {
            if (!file3.getName().equals(DERBY_CLIENT)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractZip(File file, FileObject fileObject) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string = zipEntry.getName();
                if (zipEntry.isDirectory()) {
                    FileUtil.createFolder((FileObject)fileObject, (String)string);
                    continue;
                }
                FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string);
                FileLock fileLock = fileObject2.lock();
                try {
                    OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                    try {
                        FileUtil.copy((InputStream)zipInputStream, (OutputStream)outputStream);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
        }
        finally {
            fileInputStream.close();
        }
    }
}

