/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.slides;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.view.ui.slides.CommandManager;

public class ResizeGestureRecognizer
implements AWTEventListener {
    static final int RESIZE_BUFFER = 8;
    private boolean isResizing = false;
    private Component comp;
    private String side;
    private CommandManager mgr;
    private GlassPane glass;
    private Component oldGlass;
    private int state;
    private Point startPoint;
    private static final int STATE_NOOP = 0;
    private static final int STATE_START = 1;
    private static final int STATE_DRAGGING = 2;

    void attachResizeRecognizer(String string, Component component) {
        this.update(string, component);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 48L);
    }

    void detachResizeRecognizer(String string, Component component) {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        this.update(null, null);
    }

    public ResizeGestureRecognizer(CommandManager commandManager) {
        this.mgr = commandManager;
        this.glass = new GlassPane();
    }

    public void update(String string, Component component) {
        this.side = string;
        this.comp = component;
        this.state = 0;
        this.resetState();
    }

    private boolean isInResizeArea(MouseEvent mouseEvent) {
        int n;
        if (this.comp == null || this.side == null || SwingUtilities.getRoot(this.comp) == null && SwingUtilities.getWindowAncestor(this.comp) == null) {
            return false;
        }
        Point point = new Point(0, 0);
        point = SwingUtilities.convertPoint(this.comp, point, SwingUtilities.getRoot(this.comp));
        Component component = mouseEvent.getComponent();
        if (!component.isDisplayable()) {
            return false;
        }
        Point point2 = SwingUtilities.convertPoint(component, mouseEvent.getPoint(), SwingUtilities.getRoot(component));
        if ("bottom".equals(this.side) && point2.x > point.x && point2.x < point.x + this.comp.getBounds().width && Math.abs(point2.y - point.y) < 8) {
            return true;
        }
        if ("left".equals(this.side) && point2.y > point.y && point2.y < point.y + this.comp.getBounds().height && Math.abs(point2.x - (n = this.comp.getBounds().width + point.x)) < 8) {
            return true;
        }
        return "right".equals(this.side) && point2.y > point.y && point2.y < point.y + this.comp.getBounds().height && Math.abs(point2.x - point.x) < 8;
    }

    private int resize(MouseEvent mouseEvent, Point point) {
        if (this.comp == null || this.side == null) {
            return 0;
        }
        Point point2 = SwingUtilities.convertPoint(this.comp, new Point(0, 0), SwingUtilities.getRoot(this.comp));
        Point point3 = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), SwingUtilities.getRoot(mouseEvent.getComponent()));
        if ("bottom".equals(this.side) && point3.x > point2.x && point3.x < point2.x + this.comp.getBounds().width) {
            return point3.y - point.y;
        }
        if (("left".equals(this.side) || "right".equals(this.side)) && point3.y > point2.y && point3.y < point2.y + this.comp.getBounds().height) {
            return point3.x - point.x;
        }
        return 0;
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        if (!(aWTEvent.getSource() instanceof Component)) {
            return;
        }
        if (this.comp == null || this.side == null) {
            this.state = 0;
            this.resetState();
            return;
        }
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        if (mouseEvent.getSource() instanceof JPopupMenu || mouseEvent.getSource() instanceof JMenuItem) {
            return;
        }
        if (mouseEvent.getID() == 503) {
            boolean bl;
            boolean bl2 = bl = mouseEvent.getModifiersEx() == 0;
            if (bl && this.isInResizeArea(mouseEvent)) {
                if (this.state == 0) {
                    this.state = 1;
                    JRootPane jRootPane = SwingUtilities.getRootPane(this.comp);
                    this.oldGlass = jRootPane.getGlassPane();
                    this.glass.setCursor(this.side);
                    this.comp.setCursor("bottom".equals(this.side) ? Cursor.getPredefinedCursor(8) : Cursor.getPredefinedCursor(11));
                    jRootPane.setGlassPane(this.glass);
                    this.glass.setVisible(true);
                }
                return;
            }
            if (this.state != 0) {
                this.resetState();
            }
            return;
        }
        if (mouseEvent.getID() == 501 && this.state == 1) {
            boolean bl;
            boolean bl3 = bl = (mouseEvent.getModifiersEx() & 0x400) == 1024;
            if (bl && this.isInResizeArea(mouseEvent)) {
                this.state = 2;
                this.startPoint = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), SwingUtilities.getRoot(mouseEvent.getComponent()));
                mouseEvent.consume();
                return;
            }
            this.resetState();
            return;
        }
        if (mouseEvent.getID() == 506 && this.state == 2) {
            int n;
            boolean bl;
            boolean bl4 = bl = (mouseEvent.getModifiersEx() & 0x400) == 1024;
            if (bl && this.startPoint != null && Math.abs(n = this.resize(mouseEvent, this.startPoint)) > 3) {
                this.startPoint = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), SwingUtilities.getRoot(mouseEvent.getComponent()));
                this.mgr.slideResize(n);
            }
            return;
        }
    }

    public boolean isDragging() {
        return this.state == 2;
    }

    private void resetState() {
        JComponent jComponent;
        this.state = 0;
        JRootPane jRootPane = SwingUtilities.getRootPane(this.comp);
        this.glass.setVisible(false);
        if (jRootPane != null && this.oldGlass != null && (jComponent = (JComponent)jRootPane.getGlassPane()) instanceof GlassPane) {
            jRootPane.setGlassPane(this.oldGlass);
        }
        if (null != this.comp) {
            this.comp.setCursor(null);
        }
        this.oldGlass = null;
        this.startPoint = null;
    }

    private class GlassPane
    extends JPanel {
        private MouseListener list = new MouseAdapter(){};

        public GlassPane() {
            this.setOpaque(false);
            this.putClientProperty("dontActivate", Boolean.TRUE);
            this.addMouseListener(this.list);
        }

        public void setCursor(String string) {
            this.setCursor("bottom".equals(string) ? Cursor.getPredefinedCursor(8) : Cursor.getPredefinedCursor(11));
        }
    }
}

