/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.tools.JavaFileObject;
import org.netbeans.modules.java.preprocessorbridge.spi.VirtualSourceProvider;
import org.netbeans.modules.java.source.indexing.JavaCustomIndexer;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.usages.Pair;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VirtualSourceProviderQuery {
    private static final Lookup.Result<VirtualSourceProvider> result = Lookup.getDefault().lookupResult(VirtualSourceProvider.class);
    private static Map<String, VirtualSourceProvider> ext2prov;
    private static final LookupListener l;

    private VirtualSourceProviderQuery() {
    }

    public static boolean hasVirtualSource(File file) {
        Parameters.notNull((CharSequence)"file", (Object)file);
        String string = FileObjects.getExtension(file.getName());
        return VirtualSourceProviderQuery.getExt2ProvMap().keySet().contains(string);
    }

    public static boolean hasVirtualSource(FileObject fileObject) {
        Parameters.notNull((CharSequence)"file", (Object)fileObject);
        String string = fileObject.getExt();
        return VirtualSourceProviderQuery.getExt2ProvMap().keySet().contains(string);
    }

    public static boolean hasVirtualSource(String string) {
        Parameters.notNull((CharSequence)"extension", (Object)string);
        return VirtualSourceProviderQuery.getExt2ProvMap().keySet().contains(string);
    }

    public static boolean hasVirtualSource(Indexable indexable) {
        Parameters.notNull((CharSequence)"indexable", (Object)indexable);
        URL uRL = indexable.getURL();
        if (uRL == null) {
            return false;
        }
        String string = FileObjects.getExtension(uRL.getFile());
        return VirtualSourceProviderQuery.hasVirtualSource(string);
    }

    public static Collection<? extends JavaCustomIndexer.CompileTuple> translate(Iterable<? extends Indexable> iterable, File file) throws IOException {
        Object object;
        VirtualSourceProvider virtualSourceProvider;
        Parameters.notNull((CharSequence)"files", iterable);
        Parameters.notNull((CharSequence)"root", (Object)file);
        HashMap hashMap = new HashMap();
        Map<String, VirtualSourceProvider> map = VirtualSourceProviderQuery.getExt2ProvMap();
        HashMap<File, Indexable> hashMap2 = new HashMap<File, Indexable>();
        for (Indexable object2 : iterable) {
            Object object3 = FileObjects.getExtension(object2.getURL().getPath());
            virtualSourceProvider = map.get(object3);
            if (virtualSourceProvider == null) continue;
            object = (Pair)hashMap.get(object3);
            List<File> list = null;
            if (object == null) {
                list = new LinkedList();
                hashMap.put(object3, Pair.of(virtualSourceProvider, list));
            } else {
                list = (List)((Pair)object).second;
            }
            try {
                File uRISyntaxException = new File(object2.getURL().toURI());
                list.add(uRISyntaxException);
                hashMap2.put(uRISyntaxException, object2);
            }
            catch (URISyntaxException uRISyntaxException) {
                IOException iOException = new IOException();
                iOException.initCause(uRISyntaxException);
                throw iOException;
            }
        }
        R r = new R(file, hashMap2);
        for (Object object3 : hashMap.values()) {
            virtualSourceProvider = (VirtualSourceProvider)((Pair)object3).first;
            object = (List)((Pair)object3).second;
            r.setProvider(virtualSourceProvider);
            virtualSourceProvider.translate((Iterable)object, file, (VirtualSourceProvider.Result)r);
        }
        return r.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, VirtualSourceProvider> getExt2ProvMap() {
        Object object = VirtualSourceProviderQuery.class;
        synchronized (VirtualSourceProviderQuery.class) {
            if (ext2prov != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return ext2prov;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            object = new LinkedList(result.allInstances());
            Class<VirtualSourceProviderQuery> clazz = VirtualSourceProviderQuery.class;
            synchronized (VirtualSourceProviderQuery.class) {
                if (ext2prov == null) {
                    ext2prov = new HashMap<String, VirtualSourceProvider>();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        VirtualSourceProvider virtualSourceProvider = (VirtualSourceProvider)iterator.next();
                        for (String string : virtualSourceProvider.getSupportedExtensions()) {
                            ext2prov.put(string, virtualSourceProvider);
                        }
                    }
                }
                // ** MonitorExit[var1_2] (shouldn't be in output)
                return ext2prov;
            }
        }
    }

    private static synchronized void reset() {
        ext2prov = null;
    }

    static {
        l = new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                VirtualSourceProviderQuery.reset();
            }
        };
        result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)l, result));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class R
    implements VirtualSourceProvider.Result {
        private final File root;
        private final Map<? extends File, Indexable> file2indexables;
        private final String rootURL;
        private VirtualSourceProvider currentProvider;
        final List<JavaCustomIndexer.CompileTuple> res = new LinkedList<JavaCustomIndexer.CompileTuple>();

        public R(File file, Map<? extends File, Indexable> map) throws IOException {
            assert (file != null);
            assert (map != null);
            this.root = file;
            String string = file.toURI().toURL().toString();
            if (!string.endsWith("/")) {
                string = string + '/';
            }
            this.rootURL = string;
            this.file2indexables = map;
        }

        public List<JavaCustomIndexer.CompileTuple> getResult() {
            this.currentProvider = null;
            return this.res;
        }

        void setProvider(VirtualSourceProvider virtualSourceProvider) {
            assert (virtualSourceProvider != null);
            this.currentProvider = virtualSourceProvider;
        }

        public void add(File file, String string, String string2, CharSequence charSequence) {
            try {
                String string3 = string2 + JavaFileObject.Kind.SOURCE.extension;
                Indexable indexable = this.file2indexables.get(file);
                assert (indexable != null) : "Unknown file: " + file.getAbsolutePath();
                this.res.add(new JavaCustomIndexer.CompileTuple(FileObjects.memoryFileObject(string, string3, new URI(this.rootURL + FileObjects.convertPackage2Folder(string) + '/' + string3), System.currentTimeMillis(), charSequence), indexable, true, this.currentProvider.index()));
            }
            catch (URISyntaxException uRISyntaxException) {
                Exceptions.printStackTrace((Throwable)uRISyntaxException);
            }
        }
    }
}

