/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.codegen.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreeCellRenderer;
import org.netbeans.modules.cnd.refactoring.codegen.ui.ElementNode;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CheckRenderer
extends JPanel
implements TreeCellRenderer {
    private TristateCheckBox check;
    private JLabel label;
    private static final JList LIST_FOR_COLORS = new JList();

    public CheckRenderer() {
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.check = new TristateCheckBox();
        this.label = new JLabel();
        this.add((Component)this.check, "West");
        this.add((Component)this.label, "Center");
        this.check.setOpaque(false);
        this.label.setOpaque(false);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setOpaque(true);
        Node node = Visualizer.findNode((Object)object);
        ElementNode.Description description = (ElementNode.Description)node.getLookup().lookup(ElementNode.Description.class);
        if (description != null) {
            this.check.setVisible(description.isSelectable() || description.hasSelectableSubs());
            if (description.isSelectable()) {
                this.check.setSelected(description.isSelected());
            } else {
                this.check.setState(this.getCheckState(description.getSubs()));
            }
        }
        if (bl) {
            this.label.setForeground(LIST_FOR_COLORS.getSelectionForeground());
            jPanel.setOpaque(true);
            jPanel.setBackground(LIST_FOR_COLORS.getSelectionBackground());
        } else {
            this.label.setForeground(jTree.getForeground());
            jPanel.setOpaque(false);
        }
        this.label.setText(node.getHtmlDisplayName());
        this.label.setIcon(new ImageIcon(node.getIcon(1)));
        jPanel.add((Component)this.check, "West");
        jPanel.add((Component)this.label, "Center");
        jPanel.setPreferredSize(new Dimension(this.label.getPreferredSize().width + this.check.getPreferredSize().width, jPanel.getPreferredSize().height));
        return jPanel;
    }

    private State getCheckState(List<ElementNode.Description> list) {
        if (null == list) {
            return State.OTHER;
        }
        int n = 0;
        int n2 = 0;
        for (ElementNode.Description description : list) {
            if (!description.isSelectable()) continue;
            if (description.isSelected()) {
                ++n;
            } else {
                ++n2;
            }
            if (n <= 0 || n2 <= 0) continue;
            return State.OTHER;
        }
        return n > 0 ? State.SELECTED : State.NOT_SELECTED;
    }

    public Rectangle getCheckBounds() {
        return (Rectangle)this.check.getBounds().clone();
    }

    private static class TristateCheckBox
    extends JCheckBox {
        private final TristateDecorator model = new TristateDecorator(this.getModel());

        public TristateCheckBox() {
            super(null, null);
            this.setModel(this.model);
            this.setState(State.OTHER);
        }

        public void addMouseListener(MouseListener mouseListener) {
        }

        public void setState(State state) {
            this.model.setState(state);
        }

        public State getState() {
            return this.model.getState();
        }

        public void setSelected(boolean bl) {
            if (bl) {
                this.setState(State.SELECTED);
            } else {
                this.setState(State.NOT_SELECTED);
            }
        }

        private class TristateDecorator
        implements ButtonModel {
            private final ButtonModel other;

            private TristateDecorator(ButtonModel buttonModel) {
                this.other = buttonModel;
            }

            private void setState(State state) {
                if (state == State.NOT_SELECTED) {
                    this.other.setArmed(false);
                    this.setPressed(false);
                    this.setSelected(false);
                } else if (state == State.SELECTED) {
                    this.other.setArmed(false);
                    this.setPressed(false);
                    this.setSelected(true);
                } else {
                    this.other.setArmed(true);
                    this.setPressed(true);
                    this.setSelected(true);
                }
            }

            private State getState() {
                if (this.isSelected() && !this.isArmed()) {
                    return State.SELECTED;
                }
                if (this.isSelected() && this.isArmed()) {
                    return State.OTHER;
                }
                return State.NOT_SELECTED;
            }

            public void setArmed(boolean bl) {
            }

            public void setEnabled(boolean bl) {
                TristateCheckBox.this.setFocusable(bl);
                this.other.setEnabled(bl);
            }

            public boolean isArmed() {
                return this.other.isArmed();
            }

            public boolean isSelected() {
                return this.other.isSelected();
            }

            public boolean isEnabled() {
                return this.other.isEnabled();
            }

            public boolean isPressed() {
                return this.other.isPressed();
            }

            public boolean isRollover() {
                return this.other.isRollover();
            }

            public void setSelected(boolean bl) {
                this.other.setSelected(bl);
            }

            public void setPressed(boolean bl) {
                this.other.setPressed(bl);
            }

            public void setRollover(boolean bl) {
                this.other.setRollover(bl);
            }

            public void setMnemonic(int n) {
                this.other.setMnemonic(n);
            }

            public int getMnemonic() {
                return this.other.getMnemonic();
            }

            public void setActionCommand(String string) {
                this.other.setActionCommand(string);
            }

            public String getActionCommand() {
                return this.other.getActionCommand();
            }

            public void setGroup(ButtonGroup buttonGroup) {
                this.other.setGroup(buttonGroup);
            }

            public void addActionListener(ActionListener actionListener) {
                this.other.addActionListener(actionListener);
            }

            public void removeActionListener(ActionListener actionListener) {
                this.other.removeActionListener(actionListener);
            }

            public void addItemListener(ItemListener itemListener) {
                this.other.addItemListener(itemListener);
            }

            public void removeItemListener(ItemListener itemListener) {
                this.other.removeItemListener(itemListener);
            }

            public void addChangeListener(ChangeListener changeListener) {
                this.other.addChangeListener(changeListener);
            }

            public void removeChangeListener(ChangeListener changeListener) {
                this.other.removeChangeListener(changeListener);
            }

            public Object[] getSelectedObjects() {
                return this.other.getSelectedObjects();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        SELECTED,
        NOT_SELECTED,
        OTHER;

    }
}

