/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.navigator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentModel;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.model.SVGFileModel;
import org.netbeans.modules.mobility.svgcore.navigator.FilterActions;
import org.netbeans.modules.mobility.svgcore.navigator.FiltersDescription;
import org.netbeans.modules.mobility.svgcore.navigator.FiltersManager;
import org.netbeans.modules.mobility.svgcore.navigator.SVGNavigatorNode;
import org.netbeans.modules.mobility.svgcore.navigator.SVGNavigatorTree;
import org.netbeans.modules.mobility.svgcore.navigator.TapPanel;
import org.netbeans.modules.mobility.svgcore.view.source.SVGSourceMultiViewElement;
import org.netbeans.modules.mobility.svgcore.view.svg.AnimationCookie;
import org.netbeans.modules.mobility.svgcore.view.svg.SelectionCookie;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public class SVGNavigatorContent
extends JPanel
implements SceneManager.SelectionListener {
    public static final String ATTRIBUTES_FILTER = "attrs";
    public static final String ID_FILTER = "id";
    public static final String ANIMATION_FILTER = "anim";
    private static SVGNavigatorContent navigatorContentInstance = null;
    private final JPanel emptyPanel;
    private final JLabel msgLabel;
    private SVGDataObject peerDO = null;
    private NavigatorContentPanel navigatorPanel = null;
    private boolean blockNotification = false;
    private final WeakHashMap uiCache = new WeakHashMap();

    public static synchronized SVGNavigatorContent getDefault() {
        if (navigatorContentInstance == null) {
            navigatorContentInstance = new SVGNavigatorContent();
        }
        return navigatorContentInstance;
    }

    private SVGNavigatorContent() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.emptyPanel = new JPanel();
        this.emptyPanel.setBackground(Color.WHITE);
        this.emptyPanel.setLayout(new BorderLayout());
        this.msgLabel = new JLabel();
        this.emptyPanel.add((Component)this.msgLabel, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectionChanged(SVGObject[] sVGObjectArray, SVGObject[] sVGObjectArray2, boolean bl) {
        this.blockNotification = true;
        try {
            this.select(sVGObjectArray != null ? sVGObjectArray[0].getElementId() : null);
        }
        finally {
            this.blockNotification = false;
        }
    }

    public synchronized void navigate(final SVGDataObject sVGDataObject) {
        if (sVGDataObject != this.peerDO) {
            NavigatorContentPanel navigatorContentPanel;
            if (this.peerDO != null) {
                this.peerDO.getSceneManager().removeSelectionListener(this);
            }
            this.peerDO = sVGDataObject;
            WeakReference weakReference = (WeakReference)this.uiCache.get((Object)sVGDataObject);
            if (weakReference != null) {
                NavigatorContentPanel navigatorContentPanel2 = (NavigatorContentPanel)weakReference.get();
                if (navigatorContentPanel2 != null) {
                    System.out.println("panel is cached");
                    if (navigatorContentPanel2.m_model == sVGDataObject.getModel().getModel()) {
                        navigatorContentPanel = navigatorContentPanel2;
                    } else {
                        this.uiCache.remove((Object)sVGDataObject);
                        navigatorContentPanel = null;
                    }
                } else {
                    navigatorContentPanel = null;
                }
            } else {
                navigatorContentPanel = null;
            }
            if (sVGDataObject != null) {
                sVGDataObject.getSceneManager().addSelectionListener(this);
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        NavigatorContentPanel navigatorContentPanel2;
                        SVGNavigatorContent.this.showWaitPanel();
                        if (navigatorContentPanel == null) {
                            try {
                                if (sVGDataObject.getModel().getModel() == null) {
                                    SVGNavigatorContent.this.showCannotNavigate();
                                    return;
                                }
                                navigatorContentPanel2 = new NavigatorContentPanel(sVGDataObject);
                                SVGNavigatorContent.this.uiCache.put(sVGDataObject, new WeakReference<NavigatorContentPanel>(navigatorContentPanel2));
                            }
                            catch (Exception exception) {
                                SceneManager.log(Level.WARNING, "Navigator panel creation failed", exception);
                                SVGNavigatorContent.this.showCannotNavigate();
                                return;
                            }
                        } else {
                            navigatorContentPanel2 = navigatorContentPanel;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                SVGNavigatorContent.this.setContent(sVGDataObject, navigatorContentPanel2);
                            }
                        });
                    }
                });
            } else {
                this.setContent(null, null);
            }
        }
    }

    synchronized void setContent(SVGDataObject sVGDataObject, NavigatorContentPanel navigatorContentPanel) {
        this.navigatorPanel = navigatorContentPanel;
        this.removeAll();
        if (navigatorContentPanel != null) {
            this.add((Component)navigatorContentPanel, "Center");
        }
        this.validate();
        this.repaint();
    }

    synchronized void select(String string) {
        if (this.navigatorPanel != null) {
            this.navigatorPanel.tree.selectNode(string, null);
        }
    }

    public void release() {
        this.removeAll();
        this.peerDO = null;
        this.repaint();
    }

    public void showCannotNavigate() {
        this.removeAll();
        this.msgLabel.setIcon(null);
        this.msgLabel.setForeground(Color.GRAY);
        this.msgLabel.setText(NbBundle.getMessage(SVGNavigatorContent.class, (String)"LBL_CannotNavigate"));
        this.msgLabel.setHorizontalAlignment(0);
        this.add((Component)this.emptyPanel, "Center");
        this.repaint();
    }

    private void showWaitPanel() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SVGNavigatorContent.this.removeAll();
                SVGNavigatorContent.this.msgLabel.setIcon(null);
                SVGNavigatorContent.this.msgLabel.setForeground(Color.GRAY);
                SVGNavigatorContent.this.msgLabel.setHorizontalAlignment(2);
                SVGNavigatorContent.this.msgLabel.setText(NbBundle.getMessage(SVGNavigatorContent.class, (String)"LBL_Wait"));
                SVGNavigatorContent.this.add((Component)SVGNavigatorContent.this.emptyPanel, "North");
                SVGNavigatorContent.this.repaint();
            }
        });
    }

    private class NavigatorContentPanel
    extends JPanel
    implements FiltersManager.FilterChangeListener {
        private final SVGDataObject m_doj;
        private final SVGNavigatorTree tree;
        private final FiltersManager m_filters;
        final DocumentModel m_model;
        private final SVGFileModel.ModelListener modelListener = new SVGFileModel.ModelListener(){

            public void modelChanged() {
                NavigatorContentPanel.this.tree.repaint();
            }
        };

        private String getElementId(DocumentElement documentElement) {
            if (documentElement.getStartOffset() < documentElement.getEndOffset()) {
                return this.m_doj.getModel().getElementId(documentElement);
            }
            SceneManager.log(Level.SEVERE, "Deleted element found: " + documentElement);
            return null;
        }

        public NavigatorContentPanel(SVGDataObject sVGDataObject) throws Exception {
            Object object;
            this.m_doj = sVGDataObject;
            this.m_model = sVGDataObject.getModel().getModel();
            this.setLayout(new BorderLayout());
            this.tree = new SVGNavigatorTree(sVGDataObject);
            ToolTipManager.sharedInstance().registerComponent(this.tree);
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    int n = NavigatorContentPanel.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (n != -1) {
                        TreePath treePath = NavigatorContentPanel.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                        SVGNavigatorNode sVGNavigatorNode = (SVGNavigatorNode)treePath.getLastPathComponent();
                        DocumentElement documentElement = sVGNavigatorNode.getDocumentElement();
                        if (mouseEvent.getClickCount() == 2) {
                            SVGSourceMultiViewElement.selectElement(NavigatorContentPanel.this.m_doj, documentElement.getStartOffset(), true);
                        }
                    }
                }
            };
            this.tree.addMouseListener(mouseAdapter);
            final DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
            defaultTreeSelectionModel.setSelectionMode(1);
            this.tree.setSelectionModel(defaultTreeSelectionModel);
            defaultTreeSelectionModel.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    if (!SVGNavigatorContent.this.blockNotification) {
                        SelectionCookie selectionCookie;
                        Lookup lookup;
                        Object object;
                        TreePath treePath = treeSelectionEvent.getPath();
                        int n = -1;
                        String string = null;
                        if (treePath != null && !defaultTreeSelectionModel.isSelectionEmpty()) {
                            object = (SVGNavigatorNode)treePath.getLastPathComponent();
                            lookup = ((SVGNavigatorNode)object).getDocumentElement();
                            string = NavigatorContentPanel.this.getElementId((DocumentElement)lookup);
                            n = lookup.getStartOffset();
                        }
                        if ((object = NavigatorContentPanel.this.m_doj.getMTVC()) != null && (selectionCookie = (SelectionCookie)(lookup = object.getLookup()).lookup(SelectionCookie.class)) != null && string != null) {
                            selectionCookie.updateSelection(NavigatorContentPanel.this.m_doj, string, n, false);
                        }
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.tree);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            this.add((Component)jScrollPane, "Center");
            MouseAdapter mouseAdapter2 = new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 1 && mouseEvent.getModifiers() == 4) {
                        Object object;
                        JPopupMenu jPopupMenu = new JPopupMenu();
                        final AnimationCookie animationCookie = (AnimationCookie)NavigatorContentPanel.this.getCookie(AnimationCookie.class);
                        final DocumentElement documentElement = NavigatorContentPanel.this.getElementAt(mouseEvent.getX(), mouseEvent.getY());
                        boolean bl = NavigatorContentPanel.this.m_doj.getSceneManager().isReadOnly();
                        if (animationCookie != null && documentElement != null && SVGFileModel.isAnimation(documentElement)) {
                            object = new JMenuItem(NbBundle.getMessage(SVGNavigatorContent.class, (String)"LBL_AnimStart"));
                            ((AbstractButton)object).addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    String string = NavigatorContentPanel.this.getElementId(documentElement);
                                    if (string != null) {
                                        animationCookie.startAnimation(NavigatorContentPanel.this.m_doj, string);
                                    }
                                }
                            });
                            ((JMenuItem)object).setEnabled(bl);
                            jPopupMenu.add((JMenuItem)object);
                            JMenuItem jMenuItem = new JMenuItem(NbBundle.getMessage(SVGNavigatorContent.class, (String)"LBL_AnimStop"));
                            jMenuItem.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    String string = NavigatorContentPanel.this.getElementId(documentElement);
                                    if (string != null) {
                                        animationCookie.stopAnimation(NavigatorContentPanel.this.m_doj, string);
                                    }
                                }
                            });
                            jMenuItem.setEnabled(bl);
                            jPopupMenu.add(jMenuItem);
                        }
                        object = new FilterActions(NavigatorContentPanel.this.m_filters).createMenuItems();
                        for (int i = 0; i < ((JMenuItem[])object).length; ++i) {
                            jPopupMenu.add(object[i]);
                        }
                        jPopupMenu.pack();
                        jPopupMenu.show(NavigatorContentPanel.this.tree, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            };
            this.tree.addMouseListener(mouseAdapter2);
            TreeNode treeNode = (TreeNode)this.tree.getTreeModel().getRoot();
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                object = treeNode.getChildAt(i);
                if (object.getChildCount() <= 0) continue;
                this.tree.expandPath(new TreePath(new TreeNode[]{treeNode, object}));
            }
            TapPanel tapPanel = new TapPanel();
            object = new JLabel(NbBundle.getMessage(SVGNavigatorContent.class, (String)"LBL_Filter"));
            ((JComponent)object).setBorder(new EmptyBorder(0, 5, 5, 0));
            tapPanel.add((Component)object);
            tapPanel.setOrientation(2);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
            String string = Utilities.keyToString((KeyStroke)keyStroke);
            tapPanel.setToolTipText(NbBundle.getMessage(SVGNavigatorContent.class, (String)"TIP_TapPanel", (Object)string));
            this.m_filters = this.createFilters();
            this.m_filters.hookChangeListener(this);
            tapPanel.add(this.m_filters.getComponent());
            this.add((Component)tapPanel, "South");
            sVGDataObject.getModel().addModelListener(this.modelListener);
        }

        protected Node.Cookie getCookie(Class clazz) {
            Node.Cookie cookie = null;
            TopComponent topComponent = this.m_doj.getMTVC();
            if (topComponent != null) {
                cookie = (Node.Cookie)topComponent.getLookup().lookup(clazz);
            }
            return cookie;
        }

        protected DocumentElement getElementAt(int n, int n2) {
            DocumentElement documentElement = null;
            int n3 = this.tree.getRowForLocation(n, n2);
            if (n3 != -1) {
                TreePath treePath = this.tree.getPathForLocation(n, n2);
                SVGNavigatorNode sVGNavigatorNode = (SVGNavigatorNode)treePath.getLastPathComponent();
                documentElement = sVGNavigatorNode.getDocumentElement();
            }
            return documentElement;
        }

        private FiltersManager createFilters() {
            FiltersDescription filtersDescription = new FiltersDescription();
            filtersDescription.addFilter(SVGNavigatorContent.ATTRIBUTES_FILTER, NbBundle.getMessage(SVGNavigatorContent.class, (String)"LBL_ShowAttributes"), NbBundle.getMessage(SVGNavigatorContent.class, (String)"LBL_ShowAttributesTip"), SVGNavigatorTree.showAttributes, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/mobility/svgcore/resources/a.png", (boolean)false), null);
            filtersDescription.addFilter(SVGNavigatorContent.ID_FILTER, NbBundle.getMessage(SVGNavigatorContent.class, (String)"LBL_ShowId"), NbBundle.getMessage(SVGNavigatorContent.class, (String)"LBL_ShowIdTip"), SVGNavigatorTree.showIdOnly, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/mobility/svgcore/resources/filterIdentified.png", (boolean)false), null);
            filtersDescription.addFilter(SVGNavigatorContent.ANIMATION_FILTER, NbBundle.getMessage(SVGNavigatorContent.class, (String)"LBL_ShowAnimation"), NbBundle.getMessage(SVGNavigatorContent.class, (String)"LBL_ShowAnimationTip"), SVGNavigatorTree.showAnimationsOnly, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/mobility/svgcore/resources/filterAnimations.png", (boolean)false), null);
            return FiltersDescription.createManager(filtersDescription);
        }

        public void filterStateChanged(ChangeEvent changeEvent) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = this.m_filters.isSelected(SVGNavigatorContent.ATTRIBUTES_FILTER);
            if (bl3 != SVGNavigatorTree.showAttributes) {
                SVGNavigatorTree.showAttributes = bl3;
                bl2 = true;
            }
            if ((bl3 = this.m_filters.isSelected(SVGNavigatorContent.ID_FILTER)) != SVGNavigatorTree.showIdOnly) {
                bl = true;
                SVGNavigatorTree.showIdOnly = bl3;
            }
            if ((bl3 = this.m_filters.isSelected(SVGNavigatorContent.ANIMATION_FILTER)) != SVGNavigatorTree.showAnimationsOnly) {
                bl = true;
                SVGNavigatorTree.showAnimationsOnly = bl3;
            }
            if (bl) {
                this.tree.filterChanged();
            } else if (bl2) {
                this.tree.validate();
                this.tree.repaint();
            }
        }
    }
}

