/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.kenai;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.FieldPosition;
import java.text.MessageFormat;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.issuetable.Filter;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiSupport;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.ui.query.QueryAction;
import org.netbeans.modules.kenai.ui.spi.QueryResultHandle;
import org.openide.util.NbBundle;

public class QueryResultHandleImpl
extends QueryResultHandle
implements ActionListener {
    private final Query query;
    private final String label;
    private final String tooltip;
    private final Filter filter;
    private final QueryResultHandle.ResultType type;
    private static MessageFormat totalFormat = new MessageFormat(NbBundle.getMessage(QueryResultHandleImpl.class, (String)"LBL_QueryResultTotal"));
    private static MessageFormat unseenFormat = new MessageFormat(NbBundle.getMessage(QueryResultHandleImpl.class, (String)"LBL_QueryResultUnseen"));
    private static MessageFormat newFormat = new MessageFormat(NbBundle.getMessage(QueryResultHandleImpl.class, (String)"LBL_QueryResultNew"));
    private static MessageFormat totalTooltipFormat = new MessageFormat(NbBundle.getMessage(QueryResultHandleImpl.class, (String)"LBL_QueryResultTotalTooltip"));
    private static MessageFormat unseenTooltipFormat = new MessageFormat(NbBundle.getMessage(QueryResultHandleImpl.class, (String)"LBL_QueryResultUnseenTooltip"));
    private static MessageFormat newTooltipFormat = new MessageFormat(NbBundle.getMessage(QueryResultHandleImpl.class, (String)"LBL_QueryResultNewTooltip"));

    QueryResultHandleImpl(Query query, String string, String string2, Filter filter, QueryResultHandle.ResultType resultType) {
        this.query = query;
        this.label = string;
        this.tooltip = string2;
        this.filter = filter;
        this.type = resultType;
    }

    public String getText() {
        return this.label;
    }

    public String getToolTipText() {
        return this.tooltip;
    }

    public QueryResultHandle.ResultType getResultType() {
        return this.type;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        BugtrackingConnector[] bugtrackingConnectorArray;
        for (BugtrackingConnector bugtrackingConnector : bugtrackingConnectorArray = BugtrackingManager.getInstance().getConnectors()) {
            KenaiSupport kenaiSupport = (KenaiSupport)bugtrackingConnector.getLookup().lookup(KenaiSupport.class);
            kenaiSupport.setFilter(this.query, this.filter);
        }
        QueryAction.openQuery(this.query, null, true);
    }

    static QueryResultHandleImpl forStatus(Query query, int n) {
        switch (n) {
            case 14: {
                Issue[] issueArray = query.getIssues(n);
                int n2 = issueArray != null ? issueArray.length : 0;
                return new QueryResultHandleImpl(query, totalFormat.format(new Object[]{n2}, new StringBuffer(), (FieldPosition)null).toString(), QueryResultHandleImpl.getTotalTooltip(n2), Filter.getAllFilter(query), QueryResultHandle.ResultType.NAMED_RESULT);
            }
            case 12: {
                int n3 = 0;
                Issue[] issueArray = query.getIssues(12);
                if (issueArray == null || issueArray.length == 0) {
                    return null;
                }
                n3 = issueArray.length;
                String string = unseenFormat.format(new Object[]{n3}, new StringBuffer(), (FieldPosition)null).toString();
                String string2 = QueryResultHandleImpl.getUnseenTooltip(n3);
                return new QueryResultHandleImpl(query, string, string2, Filter.getNotSeenFilter(), QueryResultHandle.ResultType.NAMED_RESULT);
            }
            case 4: {
                int n4 = 0;
                Issue[] issueArray = query.getIssues(4);
                if (issueArray == null || issueArray.length == 0) {
                    return null;
                }
                n4 = issueArray.length;
                String string = QueryResultHandleImpl.getNewTooltip(n4);
                String string3 = newFormat.format(new Object[]{n4}, new StringBuffer(), (FieldPosition)null).toString();
                return new QueryResultHandleImpl(query, string3, string, Filter.getNewFilter(query), QueryResultHandle.ResultType.NAMED_RESULT);
            }
        }
        throw new IllegalStateException("wrong status value [" + n + "]");
    }

    static QueryResultHandle getAllChangedResult(Query query) {
        int n = 0;
        Issue[] issueArray = query.getIssues(12);
        n = issueArray != null ? issueArray.length : 0;
        return new QueryResultHandleImpl(query, Integer.toString(n), QueryResultHandleImpl.getUnseenTooltip(n), Filter.getNotSeenFilter(), QueryResultHandle.ResultType.ALL_CHANGES_RESULT);
    }

    private static String getTotalTooltip(int n) {
        if (n == 1) {
            return NbBundle.getMessage(QueryResultHandleImpl.class, (String)"LBL_QueryResultTotal1Tooltip");
        }
        return totalTooltipFormat.format(new Object[]{n}, new StringBuffer(), (FieldPosition)null).toString();
    }

    private static String getNewTooltip(int n) {
        if (n == 1) {
            return NbBundle.getMessage(QueryResultHandleImpl.class, (String)"LBL_QueryResultNew1Tooltip");
        }
        return newTooltipFormat.format(new Object[]{n}, new StringBuffer(), (FieldPosition)null).toString();
    }

    private static String getUnseenTooltip(int n) {
        if (n == 1) {
            return NbBundle.getMessage(QueryResultHandleImpl.class, (String)"LBL_QueryResultUnseen1Tooltip");
        }
        return unseenTooltipFormat.format(new Object[]{n}, new StringBuffer(), (FieldPosition)null).toString();
    }
}

