/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.kenai;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.kenai.KenaiRepositoryUtils;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.util.KenaiUtil;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.ui.spi.Dashboard;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public abstract class KenaiRepositories {
    private static KenaiRepositories instance;

    protected KenaiRepositories() {
    }

    public static KenaiRepositories getInstance() {
        if (instance == null && (instance = (KenaiRepositories)Lookup.getDefault().lookup(KenaiRepositories.class)) == null) {
            instance = new DefaultImpl();
        }
        return instance;
    }

    public Repository[] getRepositories() {
        return this.getRepositories(false);
    }

    public abstract Repository[] getRepositories(boolean var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultImpl
    extends KenaiRepositories {
        private DefaultImpl() {
        }

        @Override
        public Repository[] getRepositories(boolean bl) {
            KenaiProject[] kenaiProjectArray = bl ? DefaultImpl.union(this.getDashboardProjects(), this.getProjectsViewProjects()) : this.getDashboardProjects();
            Repository[] repositoryArray = new Repository[kenaiProjectArray.length];
            int n = 0;
            for (KenaiProject kenaiProject : kenaiProjectArray) {
                Repository repository = KenaiRepositoryUtils.getInstance().getRepository(kenaiProject);
                if (repository == null) continue;
                repositoryArray[n++] = repository;
            }
            return DefaultImpl.stripTrailingNulls(repositoryArray);
        }

        private KenaiProject[] getDashboardProjects() {
            ProjectHandle[] projectHandleArray = Dashboard.getDefault().getOpenProjects();
            if (projectHandleArray == null || projectHandleArray.length == 0) {
                return new KenaiProject[0];
            }
            int n = 0;
            KenaiProject[] kenaiProjectArray = new KenaiProject[projectHandleArray.length];
            for (ProjectHandle projectHandle : projectHandleArray) {
                KenaiProject kenaiProject = KenaiUtil.getKenaiProject(projectHandle);
                if (kenaiProject != null) {
                    kenaiProjectArray[n++] = kenaiProject;
                    continue;
                }
                BugtrackingManager.LOG.warning("No Kenai project is available for ProjectHandle [" + projectHandle.getId() + ", " + projectHandle.getDisplayName() + "]");
            }
            return DefaultImpl.stripTrailingNulls(kenaiProjectArray);
        }

        private KenaiProject[] getProjectsViewProjects() {
            Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
            if (projectArray.length == 0) {
                return new KenaiProject[0];
            }
            int n = 0;
            KenaiProject[] kenaiProjectArray = new KenaiProject[projectArray.length];
            for (Project project : projectArray) {
                KenaiProject kenaiProject = DefaultImpl.getKenaiProject(project);
                if (kenaiProject == null) continue;
                kenaiProjectArray[n++] = kenaiProject;
            }
            return DefaultImpl.stripTrailingNulls(kenaiProjectArray);
        }

        private static KenaiProject getKenaiProject(Project project) {
            KenaiProject kenaiProject;
            FileObject fileObject = project.getProjectDirectory();
            Object object = fileObject.getAttribute("ProvidedExtensions.RemoteLocation");
            if (!(object instanceof String)) {
                return null;
            }
            try {
                kenaiProject = KenaiProject.forRepository((String)((String)object));
            }
            catch (KenaiException kenaiException) {
                kenaiProject = null;
                BugtrackingManager.LOG.warning("No Kenai project is available for bugtracking repository  [" + object + "]");
            }
            return kenaiProject;
        }

        private static KenaiProject[] union(KenaiProject[] ... kenaiProjectArray) {
            KenaiProject[] kenaiProjectArray22;
            int n = 0;
            KenaiProject[] kenaiProjectArray3 = null;
            for (KenaiProject[] kenaiProjectArray22 : kenaiProjectArray) {
                if (kenaiProjectArray22.length == 0) continue;
                n += kenaiProjectArray22.length;
                kenaiProjectArray3 = kenaiProjectArray22;
            }
            assert (n == 0 == (kenaiProjectArray3 == null));
            if (n == 0) {
                return new KenaiProject[0];
            }
            if (n == kenaiProjectArray3.length) {
                return kenaiProjectArray3;
            }
            int n2 = 0;
            ArrayList<String> arrayList = new ArrayList<String>(n);
            KenaiProject[] kenaiProjectArray4 = new KenaiProject[n];
            kenaiProjectArray22 = kenaiProjectArray;
            int n3 = kenaiProjectArray22.length;
            for (int i = 0; i < n3; ++i) {
                KenaiProject kenaiProject;
                for (KenaiProject kenaiProject2 : kenaiProject = kenaiProjectArray22[i]) {
                    if (arrayList.contains(kenaiProject2.getName())) continue;
                    kenaiProjectArray4[n2++] = kenaiProject2;
                    arrayList.add(kenaiProject2.getName());
                }
            }
            return DefaultImpl.stripTrailingNulls(kenaiProjectArray4);
        }

        private static <T> T[] stripTrailingNulls(T[] TArray) {
            int n;
            for (n = TArray.length; n > 0 && TArray[n - 1] == null; --n) {
            }
            if (n == TArray.length) {
                return TArray;
            }
            Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n);
            if (n != 0) {
                System.arraycopy(TArray, 0, objectArray, 0, n);
            }
            return objectArray;
        }
    }
}

