/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.extrahints;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.jrubyparser.ast.HashNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.StrNode;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateHashKeys
extends RubyAstRule {
    public boolean appliesTo(RuleContext ruleContext) {
        return true;
    }

    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.HASHNODE);
    }

    public void run(RubyRuleContext rubyRuleContext, List<Hint> list) {
        HashKey hashKey;
        Node node;
        int n;
        Node node2 = rubyRuleContext.node;
        AstPath astPath = rubyRuleContext.path;
        ParserResult parserResult = rubyRuleContext.parserResult;
        HashSet<HashKey> hashSet = new HashSet<HashKey>();
        HashSet<HashKey> hashSet2 = null;
        HashNode hashNode = (HashNode)node2;
        ListNode listNode = hashNode.getListNode();
        List list2 = listNode.childNodes();
        int n2 = list2.size();
        for (n = 0; n < n2; n += 2) {
            node = (Node)list2.get(n);
            hashKey = this.getHashKey(node);
            if (hashKey == null) continue;
            if (hashSet.contains(hashKey)) {
                if (hashSet2 == null) {
                    hashSet2 = new HashSet<HashKey>(5);
                }
                hashSet2.add(hashKey);
                continue;
            }
            hashSet.add(hashKey);
        }
        if (hashSet2 != null) {
            n2 = list2.size();
            for (n = 0; n < n2; n += 2) {
                OffsetRange offsetRange;
                OffsetRange offsetRange2;
                node = (Node)list2.get(n);
                hashKey = this.getHashKey(node);
                if (hashKey == null || !hashSet2.contains(hashKey) || (offsetRange2 = LexUtilities.getLexerOffsets((Parser.Result)parserResult, (OffsetRange)(offsetRange = AstUtilities.getNameRange((Node)node)))) == null) continue;
                List list3 = Collections.emptyList();
                String string = NbBundle.getMessage(DuplicateHashKeys.class, (String)"DuplicateHashName", (Object)hashKey.getValue());
                Hint hint = new Hint((Rule)this, string, RubyUtils.getFileObject((Parser.Result)parserResult), offsetRange2, list3, 1000);
                list.add(hint);
            }
        }
    }

    private HashKey getHashKey(Node node) {
        NodeType nodeType = node.getNodeType();
        if (nodeType == NodeType.SYMBOLNODE) {
            return new HashKey(((INameNode)node).getName(), nodeType);
        }
        if (nodeType == NodeType.STRNODE) {
            return new HashKey(((StrNode)node).getValue(), nodeType);
        }
        return null;
    }

    public String getId() {
        return "DuplicateHashKeys";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(DuplicateHashKeys.class, (String)"DuplicateHashKeys");
    }

    public String getDescription() {
        return NbBundle.getMessage(DuplicateHashKeys.class, (String)"DuplicateHashKeysDesc");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public boolean showInTasklist() {
        return true;
    }

    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    private static final class HashKey {
        private final String value;
        private final NodeType type;

        public HashKey(String string, NodeType nodeType) {
            this.value = string;
            this.type = nodeType;
        }

        public NodeType getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            HashKey hashKey = (HashKey)object;
            if (this.value == null ? hashKey.value != null : !this.value.equals(hashKey.value)) {
                return false;
            }
            return this.type == hashKey.type;
        }

        public int hashCode() {
            int n = 3;
            n = 53 * n + (this.value != null ? this.value.hashCode() : 0);
            n = 53 * n + (this.type != null ? this.type.hashCode() : 0);
            return n;
        }
    }
}

