/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.php.dbgp.breakpoints.FunctionBreakpoint;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class DbgpMethodBreakpointPanel
extends JPanel
implements Controller {
    private static final long serialVersionUID = 4967178020173186468L;
    private static final String EMPTY_METHOD_NAME = "LBL_EmptyMethodName";
    private static final String METHOD_RETURN = NbBundle.getMessage(DbgpMethodBreakpointPanel.class, (String)"LBL_MethodReturn");
    private static final String METHOD_CALL = NbBundle.getMessage(DbgpMethodBreakpointPanel.class, (String)"LBL_MethodCall");
    private JLabel myMethodLbl;
    private JTextField myMethodName;
    private JLabel myStopOnLbl;
    private JComboBox myStopType;
    private static final ComboBoxModel METHOD_TYPES_MODEL = new DefaultComboBoxModel<MethodType>(MethodType.values());

    public DbgpMethodBreakpointPanel() {
        this.initComponents();
        this.myStopOnLbl.setVisible(false);
        this.myStopType.setVisible(false);
    }

    public boolean cancel() {
        return true;
    }

    public boolean ok() {
        String string = this.myMethodName.getText();
        if (string == null || string.trim().length() == 0) {
            String string2 = NbBundle.getMessage(DbgpMethodBreakpointPanel.class, (String)EMPTY_METHOD_NAME);
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return false;
        }
        MethodType methodType = (MethodType)((Object)METHOD_TYPES_MODEL.getSelectedItem());
        FunctionBreakpoint functionBreakpoint = new FunctionBreakpoint(methodType.getType(), string);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)functionBreakpoint);
        return true;
    }

    private void initComponents() {
        this.myMethodLbl = new JLabel();
        this.myStopOnLbl = new JLabel();
        this.myMethodName = new JTextField();
        this.myStopType = new JComboBox();
        this.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(DbgpMethodBreakpointPanel.class, (String)"LBL_Settings")));
        this.myMethodLbl.setLabelFor(this.myMethodName);
        Mnemonics.setLocalizedText((JLabel)this.myMethodLbl, (String)NbBundle.getMessage(DbgpMethodBreakpointPanel.class, (String)"LBL_MethodName"));
        this.myStopOnLbl.setLabelFor(this.myStopType);
        Mnemonics.setLocalizedText((JLabel)this.myStopOnLbl, (String)NbBundle.getMessage(DbgpMethodBreakpointPanel.class, (String)"LBL_StopOn"));
        this.myMethodName.setText("");
        this.myStopType.setModel(METHOD_TYPES_MODEL);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.myStopOnLbl).add(31, 31, 31)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.myMethodLbl).addPreferredGap(0))).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.myStopType, -2, -1, -2).add((Component)this.myMethodName, -1, 189, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.myMethodLbl).add((Component)this.myMethodName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.myStopOnLbl).add((Component)this.myStopType, -2, -1, -2))));
        this.myMethodLbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DbgpMethodBreakpointPanel.class, (String)"DbgpMethodBreakpointPanel.myMethodLbl.AccessibleContext.accessibleName"));
        this.myMethodLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DbgpMethodBreakpointPanel.class, (String)"DbgpMethodBreakpointPanel.myMethodLbl.AccessibleContext.accessibleDescription"));
        this.myStopOnLbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DbgpMethodBreakpointPanel.class, (String)"DbgpMethodBreakpointPanel.myStopOnLbl.AccessibleContext.accessibleName"));
        this.myStopOnLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DbgpMethodBreakpointPanel.class, (String)"DbgpMethodBreakpointPanel.myStopOnLbl.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DbgpMethodBreakpointPanel.class, (String)"A11_SettingsName"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MethodType
    extends Enum<MethodType> {
        public static final /* enum */ MethodType CALL = new MethodType(FunctionBreakpoint.Type.CALL);
        public static final /* enum */ MethodType RETURN = new MethodType(FunctionBreakpoint.Type.RETURN);
        private final FunctionBreakpoint.Type myType;
        private static final /* synthetic */ MethodType[] $VALUES;

        public static MethodType[] values() {
            return (MethodType[])$VALUES.clone();
        }

        public static MethodType valueOf(String string) {
            return Enum.valueOf(MethodType.class, string);
        }

        private MethodType(FunctionBreakpoint.Type type) {
            this.myType = type;
        }

        FunctionBreakpoint.Type getType() {
            return this.myType;
        }

        public String toString() {
            if (this == CALL) {
                return METHOD_CALL;
            }
            if (this == RETURN) {
                return METHOD_RETURN;
            }
            assert (false);
            return null;
        }

        static {
            $VALUES = new MethodType[]{CALL, RETURN};
        }
    }
}

