/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.toolsui;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightConfigurationManager;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.dlight.api.tool.impl.DLightConfigurationManagerAccessor;
import org.netbeans.modules.dlight.api.tool.impl.DLightConfigurationSupport;
import org.netbeans.modules.dlight.toolsui.DLightToolUIWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLightConfigurationUIWrapper {
    private DLightConfiguration dlightConfiguration;
    private boolean custom;
    private String name;
    private String displayName;
    private List<DLightToolUIWrapper> tools;
    private boolean modified;
    private DLightConfiguration copyOf;

    public DLightConfigurationUIWrapper(DLightConfiguration dLightConfiguration, List<DLightTool> list) {
        this.dlightConfiguration = dLightConfiguration;
        this.name = dLightConfiguration.getConfigurationName();
        this.displayName = dLightConfiguration.getDisplayedName();
        this.custom = DLightConfigurationSupport.getInstance().canRemoveConfiguration(dLightConfiguration.getConfigurationName());
        this.copyOf = null;
        this.initWrapper(list);
    }

    public DLightConfigurationUIWrapper(String string, String string2, List<DLightTool> list) {
        DLightConfigurationManagerAccessor dLightConfigurationManagerAccessor = DLightConfigurationManagerAccessor.getDefault();
        DLightConfigurationManager dLightConfigurationManager = DLightConfigurationManager.getInstance();
        this.dlightConfiguration = dLightConfigurationManagerAccessor.getDefaultConfiguration(dLightConfigurationManager);
        this.name = string;
        this.displayName = string2;
        this.custom = true;
        this.copyOf = null;
        this.initWrapper(list);
    }

    private void initWrapper(List<DLightTool> list) {
        this.tools = new ArrayList<DLightToolUIWrapper>();
        List list2 = this.dlightConfiguration.getToolsSet();
        boolean bl = false;
        for (DLightTool dLightTool : list) {
            DLightTool dLightTool2 = DLightConfigurationUIWrapper.findTool(list2, dLightTool.getID());
            dLightTool2 = dLightTool2 == null ? dLightTool : dLightTool2;
            if (dLightTool2 == null || !dLightTool2.isVisible()) continue;
            boolean bl2 = this.dlightConfiguration.getToolByID(dLightTool.getID()) != null;
            boolean bl3 = dLightTool2.isEnabled() ? DLightConfigurationUIWrapper.inList(dLightTool, list2) : false;
            this.tools.add(new DLightToolUIWrapper(dLightTool2, bl3, bl2));
        }
    }

    private static DLightTool findTool(List<DLightTool> list, String string) {
        for (DLightTool dLightTool : list) {
            if (!dLightTool.getID().equals(string)) continue;
            return dLightTool;
        }
        return null;
    }

    private static boolean inList(DLightTool dLightTool, List<DLightTool> list) {
        for (DLightTool dLightTool2 : list) {
            if (!dLightTool2.getID().equals(dLightTool.getID())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public DLightConfiguration getDLightConfiguration() {
        return this.dlightConfiguration;
    }

    public void setDLightConfiguration(DLightConfiguration dLightConfiguration) {
        this.dlightConfiguration = dLightConfiguration;
    }

    public List<DLightToolUIWrapper> getTools() {
        return this.tools;
    }

    public DLightToolUIWrapper getToolUIWrapper(DLightTool dLightTool) {
        for (DLightToolUIWrapper dLightToolUIWrapper : this.getTools()) {
            if (!dLightToolUIWrapper.getDLightTool().getID().equals(dLightTool.getID())) continue;
            return dLightToolUIWrapper;
        }
        return null;
    }

    public void setTools(List<DLightToolUIWrapper> list) {
        this.tools = list;
    }

    public void setToolEnabled(DLightToolUIWrapper dLightToolUIWrapper, boolean bl) {
        dLightToolUIWrapper.setEnabled(bl);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public DLightConfigurationUIWrapper copy() {
        ArrayList<DLightTool> arrayList = new ArrayList<DLightTool>(this.getTools().size());
        for (DLightToolUIWrapper dLightToolUIWrapper : this.getTools()) {
            arrayList.add(dLightToolUIWrapper.getDLightTool());
        }
        DLightConfigurationUIWrapper dLightConfigurationUIWrapper = new DLightConfigurationUIWrapper(this.getDLightConfiguration(), arrayList);
        dLightConfigurationUIWrapper.setModified(false);
        return dLightConfigurationUIWrapper;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public DLightConfiguration getCopyOf() {
        return this.copyOf;
    }

    public void setCopyOf(DLightConfiguration dLightConfiguration) {
        this.copyOf = dLightConfiguration;
    }
}

