/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.cplusplus;

import java.awt.event.ActionEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.Filter;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.modules.cnd.editor.cplusplus.CCKit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CKit
extends CCKit {
    private static String START_BLOCK_COMMENT = "/*";
    private static String END_BLOCK_COMMENT = "*/";
    private static String insertStartCommentString = START_BLOCK_COMMENT + "\n";
    private static String insertEndCommentString = END_BLOCK_COMMENT + "\n";

    @Override
    public String getContentType() {
        return "text/x-c";
    }

    @Override
    protected Language<CppTokenId> getLanguage() {
        return CppTokenId.languageC();
    }

    @Override
    protected Filter<CppTokenId> getFilter() {
        return CndLexerUtilities.getGccCFilter();
    }

    @Override
    protected Action getCommentAction() {
        return new CCommentAction();
    }

    @Override
    protected Action getUncommentAction() {
        return new CUncommentAction();
    }

    @Override
    protected Action getToggleCommentAction() {
        return new CToggleCommentAction();
    }

    private static final class CToggleCommentAction
    extends ExtKit.ToggleCommentAction {
        private CToggleCommentAction() {
            super("//");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (this.allComments(jTextComponent)) {
                CUncommentAction.doCStyleUncomment(jTextComponent);
            } else {
                CCommentAction.doCStyleComment(jTextComponent);
            }
        }

        private boolean allComments(final JTextComponent jTextComponent) {
            final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            baseDocument.render(new Runnable(){

                public void run() {
                    Caret caret = jTextComponent.getCaret();
                    Token token = null;
                    try {
                        TokenSequence tokenSequence;
                        int n;
                        int n2;
                        if (Utilities.isSelectionShowing((Caret)caret)) {
                            n2 = jTextComponent.getSelectionStart();
                            n = jTextComponent.getSelectionEnd();
                            if (n > 0 && Utilities.getRowStart((BaseDocument)baseDocument, (int)n) == n) {
                                --n;
                            }
                        } else {
                            n = n2 = jTextComponent.getSelectionStart();
                        }
                        if ((tokenSequence = CndLexerUtilities.getCppTokenSequence((Document)baseDocument, (int)n2, (boolean)true, (boolean)false)) == null) {
                            return;
                        }
                        token = tokenSequence.token();
                        while (tokenSequence.offset() < n && token.id() == CppTokenId.WHITESPACE && tokenSequence.moveNext()) {
                            token = tokenSequence.token();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        jTextComponent.getToolkit().beep();
                    }
                    atomicBoolean.set(token != null && token.id() == CppTokenId.BLOCK_COMMENT);
                }
            });
            return atomicBoolean.get();
        }
    }

    private static final class CUncommentAction
    extends ExtKit.UncommentAction {
        private CUncommentAction() {
            super("//");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            CUncommentAction.doCStyleUncomment(jTextComponent);
        }

        private static void doCStyleUncomment(final JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                baseDocument.runAtomicAsUser(new Runnable(){

                    public void run() {
                        Caret caret = jTextComponent.getCaret();
                        try {
                            TokenSequence tokenSequence;
                            int n;
                            int n2;
                            if (Utilities.isSelectionShowing((Caret)caret)) {
                                n2 = jTextComponent.getSelectionStart();
                                n = jTextComponent.getSelectionEnd();
                                if (n > 0 && Utilities.getRowStart((BaseDocument)baseDocument, (int)n) == n) {
                                    --n;
                                }
                            } else {
                                n = n2 = jTextComponent.getSelectionStart();
                            }
                            if ((tokenSequence = CndLexerUtilities.getCppTokenSequence((Document)baseDocument, (int)n2, (boolean)true, (boolean)false)) == null) {
                                return;
                            }
                            Token token = tokenSequence.token();
                            int n3 = tokenSequence.offset();
                            while (n3 < n && token.id() == CppTokenId.WHITESPACE && tokenSequence.moveNext()) {
                                token = tokenSequence.token();
                                n3 = tokenSequence.offset();
                            }
                            if (token.id() == CppTokenId.BLOCK_COMMENT) {
                                int n4 = n3;
                                int n5 = n4 + token.length();
                                int n6 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n4);
                                int n7 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n6);
                                String string = baseDocument.getText(n6, n7 - n6);
                                if (!START_BLOCK_COMMENT.equals(string.trim())) {
                                    n6 = n4;
                                    n7 = n6 + START_BLOCK_COMMENT.length();
                                } else {
                                    n7 = n7 < baseDocument.getLength() - 1 ? n7 + 1 : baseDocument.getLength();
                                }
                                int n8 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n5);
                                int n9 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n8);
                                String string2 = baseDocument.getText(n8, n9 - n8);
                                if (!END_BLOCK_COMMENT.equals(string2.trim())) {
                                    n9 = n5;
                                    n8 = n9 - END_BLOCK_COMMENT.length();
                                } else {
                                    n9 = n9 < baseDocument.getLength() - 1 ? n9 + 1 : baseDocument.getLength();
                                }
                                baseDocument.remove(n8, n9 - n8);
                                baseDocument.remove(n6, n7 - n6);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            jTextComponent.getToolkit().beep();
                        }
                    }
                });
            }
        }
    }

    private static final class CCommentAction
    extends ExtKit.CommentAction {
        private CCommentAction() {
            super("//");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            CCommentAction.doCStyleComment(jTextComponent);
        }

        private static void doCStyleComment(final JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                baseDocument.runAtomic(new Runnable(){

                    public void run() {
                        Caret caret = jTextComponent.getCaret();
                        try {
                            int n;
                            int n2;
                            String string = insertEndCommentString;
                            if (Utilities.isSelectionShowing((Caret)caret)) {
                                n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)jTextComponent.getSelectionStart());
                                n = jTextComponent.getSelectionEnd();
                                if (n > 0 && Utilities.getRowStart((BaseDocument)baseDocument, (int)n) == n) {
                                    --n;
                                }
                                int n3 = Utilities.getRowCount((BaseDocument)baseDocument, (int)n2, (int)n);
                                n = Utilities.getRowStart((BaseDocument)baseDocument, (int)n2, (int)n3);
                            } else {
                                n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)jTextComponent.getSelectionStart());
                                n = Utilities.getRowStart((BaseDocument)baseDocument, (int)n2, (int)1);
                                if (n == -1) {
                                    n = baseDocument.getLength();
                                    string = "\n" + insertEndCommentString;
                                }
                            }
                            baseDocument.insertString(n, string, null);
                            baseDocument.insertString(n2, insertStartCommentString, null);
                        }
                        catch (BadLocationException badLocationException) {
                            jTextComponent.getToolkit().beep();
                        }
                    }
                });
            }
        }
    }
}

