/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.weblogic9.ui.wizard.ServerPropertiesPanel;
import org.netbeans.modules.j2ee.weblogic9.ui.wizard.WLInstantiatingIterator;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ServerPropertiesVisual
extends JPanel {
    private static final String DEFAULT_USERNAME = "weblogic";
    private static final String DEFAULT_PASSWORD = "weblogic";
    private transient WLInstantiatingIterator instantiatingIterator;
    private final Vector listeners = new Vector();
    private JTextField domainPathField;
    private JLabel domainPathLabel;
    private JTextField hostField;
    private JLabel hostLabel;
    private JPanel jPanel1;
    private JComboBox localInstancesCombo;
    private JLabel localInstancesLabel;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JTextField portField;
    private JLabel portLabel;
    private JTextField usernameField;
    private JLabel usernameLabel;

    public ServerPropertiesVisual(WLInstantiatingIterator wLInstantiatingIterator) {
        this.instantiatingIterator = wLInstantiatingIterator;
        this.setName(NbBundle.getMessage(ServerPropertiesPanel.class, (String)"SERVER_PROPERTIES_STEP"));
        this.initComponents();
    }

    public boolean valid(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        wizardDescriptor.putProperty("WizardPanel_infoMessage", null);
        if (!this.isValidDomainRoot(this.domainPathField.getText())) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)WLInstantiatingIterator.decorateMessage(NbBundle.getMessage(ServerPropertiesVisual.class, (String)"ERR_INVALID_DOMAIN_ROOT")));
            return false;
        }
        if (InstanceProperties.getInstanceProperties((String)this.getUrl()) != null) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)WLInstantiatingIterator.decorateMessage(NbBundle.getMessage(ServerPropertiesVisual.class, (String)"ERR_ALREADY_REGISTERED")));
            return false;
        }
        if (this.hostField.getText().trim().length() < 1) {
            wizardDescriptor.putProperty("WizardPanel_infoMessage", (Object)WLInstantiatingIterator.decorateMessage(NbBundle.getMessage(ServerPropertiesVisual.class, (String)"ERR_INVALID_HOST")));
        }
        if (this.portField.getText().trim().length() < 1) {
            wizardDescriptor.putProperty("WizardPanel_infoMessage", (Object)WLInstantiatingIterator.decorateMessage(NbBundle.getMessage(ServerPropertiesVisual.class, (String)"ERR_EMPTY_PORT")));
        }
        if (!this.portField.getText().trim().matches("[0-9]+")) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)WLInstantiatingIterator.decorateMessage(NbBundle.getMessage(ServerPropertiesVisual.class, (String)"ERR_INVALID_PORT")));
        }
        this.instantiatingIterator.setUrl(this.getUrl());
        this.instantiatingIterator.setDomainRoot(this.domainPathField.getText());
        this.instantiatingIterator.setUsername(this.usernameField.getText());
        this.instantiatingIterator.setPassword(new String(this.passwordField.getPassword()));
        return true;
    }

    private String getUrl() {
        return "deployer:WebLogic:http://" + this.hostField.getText() + ":" + this.portField.getText() + ":" + this.instantiatingIterator.getServerRoot() + ":" + this.domainPathField.getText();
    }

    private boolean isValidDomainRoot(String string) {
        String[] stringArray = new String[]{"servers", "config", "config/config.xml", "init-info/domain-info.xml"};
        boolean bl = this.hasChildren(string, stringArray);
        String[] stringArray2 = new String[]{"servers", "config", "config/config.xml", "domain-info.xml"};
        boolean bl2 = this.hasChildren(string, stringArray2);
        return bl || bl2;
    }

    private boolean hasChildren(String string, String[] stringArray) {
        if (string == null) {
            return false;
        }
        if (stringArray == null) {
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (new File(string + File.separator + stringArray[i]).exists()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getRegisteredDomains(String string) {
        Vector<String> vector = new Vector<String>();
        if (string == null) {
            return new String[0];
        }
        String string2 = "/common/nodemanager/nodemanager.domains";
        File file = new File(string + string2);
        BufferedReader bufferedReader = null;
        try {
            String string3;
            bufferedReader = new LineNumberReader(new InputStreamReader(new FileInputStream(file)));
            while ((string3 = ((LineNumberReader)bufferedReader).readLine()) != null) {
                if (string3.startsWith("#")) continue;
                String string4 = string3.split("=")[1].replaceAll("\\\\\\\\", "/").replaceAll("\\\\:", ":");
                vector.add(string4);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger("global").log(Level.INFO, null, fileNotFoundException);
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getServerInstances() {
        Vector<Instance> vector = new Vector<Instance>();
        String[] stringArray = this.getRegisteredDomains(this.instantiatingIterator.getServerRoot());
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i] + "/config/config.xml";
            InputStream inputStream = null;
            Document document = null;
            try {
                inputStream = new FileInputStream(new File(string));
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
                Element element = document.getDocumentElement();
                NodeList nodeList = element.getChildNodes();
                for (int j = 0; j < nodeList.getLength(); ++j) {
                    Node node = nodeList.item(j);
                    if (!node.getNodeName().matches("(?:[a-z]+\\:)?server")) continue;
                    NodeList nodeList2 = node.getChildNodes();
                    String string2 = "";
                    String string3 = "";
                    String string4 = "";
                    for (int k = 0; k < nodeList2.getLength(); ++k) {
                        Node node2 = nodeList2.item(k);
                        if (node2.getNodeName().matches("(?:[a-z]+\\:)?name")) {
                            string2 = node2.getFirstChild().getNodeValue();
                        }
                        if (node2.getNodeName().matches("(?:[a-z]+\\:)?listen-port")) {
                            string3 = node2.getFirstChild().getNodeValue();
                        }
                        if (!node2.getNodeName().matches("(?:[a-z]+\\:)?listen-address") || !node2.hasChildNodes()) continue;
                        string4 = node2.getFirstChild().getNodeValue();
                    }
                    if (string2 == null || string2.equals("")) continue;
                    string3 = string3 == null || string3.equals("") ? "7001" : string3;
                    string4 = string4 == null || string4.equals("") ? "localhost" : string4;
                    vector.add(new Instance(string2, string4, string3, stringArray[i]));
                }
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Logger.getLogger("global").log(Level.INFO, null, fileNotFoundException);
                continue;
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
                continue;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                Logger.getLogger("global").log(Level.INFO, null, parserConfigurationException);
                continue;
            }
            catch (SAXException sAXException) {
                Logger.getLogger("global").log(Level.INFO, null, sAXException);
                continue;
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger("global").log(Level.INFO, null, iOException);
                }
            }
        }
        return vector;
    }

    public void updateInstancesList() {
        this.localInstancesCombo.setModel(new InstancesModel(this.getServerInstances()));
        this.updateInstanceInfo();
    }

    private void updateInstanceInfo() {
        Instance instance = (Instance)this.localInstancesCombo.getSelectedItem();
        if (instance != null) {
            this.domainPathField.setText(instance.getDomainPath());
            this.hostField.setText(instance.getHost());
            this.portField.setText(instance.getPort());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        if (this.listeners != null) {
            Vector vector = this.listeners;
            synchronized (vector) {
                this.listeners.remove(changeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.add(changeListener);
        }
    }

    private void fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        this.fireChangeEvent(changeEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent(ChangeEvent changeEvent) {
        Vector vector;
        Vector vector2 = this.listeners;
        synchronized (vector2) {
            vector = (Vector)this.listeners.clone();
        }
        for (int i = 0; i < vector.size(); ++i) {
            ChangeListener changeListener = (ChangeListener)vector.elementAt(i);
            changeListener.stateChanged(changeEvent);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        UpdateListener updateListener = new UpdateListener();
        this.localInstancesLabel = new JLabel();
        this.localInstancesCombo = new JComboBox(new InstancesModel(this.getServerInstances()));
        this.domainPathLabel = new JLabel();
        this.domainPathField = new JTextField();
        this.hostLabel = new JLabel();
        this.hostField = new JTextField();
        this.portLabel = new JLabel();
        this.portField = new JTextField();
        this.usernameLabel = new JLabel();
        this.usernameField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordField = new JPasswordField();
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.localInstancesLabel.setHorizontalAlignment(11);
        this.localInstancesLabel.setLabelFor(this.localInstancesCombo);
        Mnemonics.setLocalizedText((JLabel)this.localInstancesLabel, (String)NbBundle.getMessage(ServerPropertiesVisual.class, (String)"LBL_LOCAL_INSTANCE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.localInstancesLabel, gridBagConstraints);
        this.localInstancesCombo.addItemListener(new LocalInstancesItemListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        this.jPanel1.add((Component)this.localInstancesCombo, gridBagConstraints);
        this.localInstancesCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerPropertiesVisual.class, (String)"ACSD_ServerPropertiesPanel_localInstancesCombo"));
        this.domainPathLabel.setHorizontalAlignment(11);
        this.domainPathLabel.setLabelFor(this.domainPathField);
        Mnemonics.setLocalizedText((JLabel)this.domainPathLabel, (String)NbBundle.getMessage(ServerPropertiesVisual.class, (String)"LBL_DOMAIN_LOCATION"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.domainPathLabel, gridBagConstraints);
        this.domainPathField.setColumns(20);
        this.domainPathField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        this.jPanel1.add((Component)this.domainPathField, gridBagConstraints);
        this.domainPathField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerPropertiesVisual.class, (String)"ACSD_ServerPropertiesPanel_domainPathField"));
        this.hostLabel.setHorizontalAlignment(11);
        this.hostLabel.setLabelFor(this.hostField);
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)NbBundle.getMessage(ServerPropertiesVisual.class, (String)"LBL_HOST"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.hostLabel, gridBagConstraints);
        this.hostField.setEditable(false);
        this.hostField.getDocument().addDocumentListener(updateListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        this.jPanel1.add((Component)this.hostField, gridBagConstraints);
        this.hostField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerPropertiesVisual.class, (String)"ACSD_ServerPropertiesPanel_hostField"));
        this.portLabel.setHorizontalAlignment(11);
        this.portLabel.setLabelFor(this.portField);
        Mnemonics.setLocalizedText((JLabel)this.portLabel, (String)NbBundle.getMessage(ServerPropertiesVisual.class, (String)"LBL_PORT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.portLabel, gridBagConstraints);
        this.portField.setColumns(15);
        this.portField.setEditable(false);
        this.portField.getDocument().addDocumentListener(updateListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        this.jPanel1.add((Component)this.portField, gridBagConstraints);
        this.portField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerPropertiesVisual.class, (String)"ACSD_ServerPropertiesPanel_portField"));
        this.usernameLabel.setHorizontalAlignment(11);
        this.usernameLabel.setLabelFor(this.usernameField);
        Mnemonics.setLocalizedText((JLabel)this.usernameLabel, (String)NbBundle.getMessage(ServerPropertiesVisual.class, (String)"LBL_USERNAME"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.usernameLabel, gridBagConstraints);
        this.usernameField.setColumns(15);
        this.usernameField.setText("weblogic");
        this.usernameField.getDocument().addDocumentListener(updateListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        this.jPanel1.add((Component)this.usernameField, gridBagConstraints);
        this.usernameField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerPropertiesVisual.class, (String)"ACSD_ServerPropertiesPanel_usernameField"));
        this.passwordLabel.setHorizontalAlignment(11);
        this.passwordLabel.setLabelFor(this.passwordField);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(ServerPropertiesVisual.class, (String)"LBL_PASSWORD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.passwordLabel, gridBagConstraints);
        this.passwordField.setColumns(15);
        this.passwordField.setText("weblogic");
        this.passwordField.getDocument().addDocumentListener(updateListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.passwordField, gridBagConstraints);
        this.passwordField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerPropertiesVisual.class, (String)"ACSD_ServerPropertiesPanel_passwordField"));
        this.add((Component)this.jPanel1, "North");
    }

    private static class Instance {
        private String name;
        private String host;
        private String port;
        private String domainPath;

        public Instance(String string, String string2, String string3, String string4) {
            this.name = string;
            this.host = string2;
            this.port = string3;
            this.domainPath = string4;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String string) {
            this.host = string;
        }

        public String getPort() {
            return this.port;
        }

        public void setPort(String string) {
            this.port = string;
        }

        public String getDomainPath() {
            return this.domainPath;
        }

        public void setDomainPath(String string) {
            this.domainPath = string;
        }

        public String toString() {
            return this.name + " [" + this.host + ":" + this.port + "]";
        }
    }

    private static class InstancesModel
    extends AbstractListModel
    implements ComboBoxModel {
        private Vector instances;
        private int selectedIndex = 0;

        public InstancesModel(Vector vector) {
            this.instances = vector;
            this.selectedIndex = 0;
        }

        public void setSelectedItem(Object object) {
            this.selectedIndex = this.instances.indexOf(object);
        }

        public Object getElementAt(int n) {
            return this.instances.elementAt(n);
        }

        public int getSize() {
            return this.instances.size();
        }

        public Object getSelectedItem() {
            if (this.instances.size() == 0) {
                return null;
            }
            if (this.selectedIndex == -1) {
                return null;
            }
            return this.instances.elementAt(this.selectedIndex);
        }
    }

    private class LocalInstancesItemListener
    implements ItemListener {
        private LocalInstancesItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ServerPropertiesVisual.this.updateInstanceInfo();
            ServerPropertiesVisual.this.isValid();
        }
    }

    private class UpdateListener
    implements DocumentListener {
        private UpdateListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            ServerPropertiesVisual.this.fireChangeEvent();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            ServerPropertiesVisual.this.fireChangeEvent();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            ServerPropertiesVisual.this.fireChangeEvent();
        }
    }
}

