/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.php.project.connections.TransferFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TransferInfo {
    private final Set<TransferFile> transfered = new HashSet<TransferFile>();
    private final Map<TransferFile, String> failed = new HashMap<TransferFile, String>();
    private final Map<TransferFile, String> partiallyFailed = new HashMap<TransferFile, String>();
    private final Map<TransferFile, String> ignored = new HashMap<TransferFile, String>();
    private long runtime;

    public Set<TransferFile> getTransfered() {
        return Collections.unmodifiableSet(this.transfered);
    }

    public Map<TransferFile, String> getFailed() {
        return Collections.unmodifiableMap(this.failed);
    }

    public Map<TransferFile, String> getPartiallyFailed() {
        return Collections.unmodifiableMap(this.partiallyFailed);
    }

    public Map<TransferFile, String> getIgnored() {
        return Collections.unmodifiableMap(this.ignored);
    }

    public long getRuntime() {
        return this.runtime;
    }

    public boolean isTransfered(TransferFile transferFile) {
        return this.transfered.contains(transferFile);
    }

    public boolean isFailed(TransferFile transferFile) {
        return this.failed.containsKey(transferFile);
    }

    public boolean isPartiallyFailed(TransferFile transferFile) {
        return this.partiallyFailed.containsKey(transferFile);
    }

    public boolean isIgnored(TransferFile transferFile) {
        return this.ignored.containsKey(transferFile);
    }

    public boolean hasAnyTransfered() {
        return !this.transfered.isEmpty();
    }

    public boolean hasAnyFailed() {
        return !this.failed.isEmpty();
    }

    public boolean hasAnyPartiallyFailed() {
        return !this.partiallyFailed.isEmpty();
    }

    public boolean hasAnyIgnored() {
        return !this.ignored.isEmpty();
    }

    void addTransfered(TransferFile transferFile) {
        assert (!this.failed.containsKey(transferFile) && !this.ignored.containsKey(transferFile));
        this.transfered.add(transferFile);
    }

    void addFailed(TransferFile transferFile, String string) {
        assert (!(this.transfered.contains(transferFile) || this.ignored.containsKey(transferFile) || this.partiallyFailed.containsKey(transferFile)));
        this.failed.put(transferFile, string);
    }

    void addPartiallyFailed(TransferFile transferFile, String string) {
        assert (!this.failed.containsKey(transferFile) && !this.ignored.containsKey(transferFile));
        this.partiallyFailed.put(transferFile, string);
    }

    void addIgnored(TransferFile transferFile, String string) {
        assert (!(this.transfered.contains(transferFile) || this.failed.containsKey(transferFile) || this.partiallyFailed.containsKey(transferFile)));
        this.ignored.put(transferFile, string);
    }

    void setRuntime(long l) {
        this.runtime = l;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(" [transfered: ");
        stringBuilder.append(this.transfered);
        stringBuilder.append(", failed: ");
        stringBuilder.append(this.failed);
        stringBuilder.append(", partially failed: ");
        stringBuilder.append(this.partiallyFailed);
        stringBuilder.append(", ignored: ");
        stringBuilder.append(this.ignored);
        stringBuilder.append(", runtime: ");
        stringBuilder.append(this.runtime);
        stringBuilder.append(" ms]");
        return stringBuilder.toString();
    }
}

