/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.tools.impl;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.tools.ProcDataProviderConfiguration;
import org.netbeans.modules.dlight.tools.impl.DataRowConsumer;
import org.netbeans.modules.dlight.tools.impl.LLDataCollectorConfigurationAccessor;
import org.netbeans.modules.dlight.tools.impl.LinuxProcfsSupport;
import org.netbeans.modules.dlight.tools.impl.ProcDataProvider;
import org.netbeans.modules.dlight.util.DLightMath;

public class ProcDataProviderLinux
implements ProcDataProvider.Engine {
    private static final List<String> COLNAMES = Collections.unmodifiableList(Arrays.asList(ProcDataProviderConfiguration.USR_TIME.getColumnName(), ProcDataProviderConfiguration.SYS_TIME.getColumnName(), ProcDataProviderConfiguration.THREADS.getColumnName()));
    private static final BigInteger PERCENT = BigInteger.valueOf(100L);
    private final DataRowConsumer consumer;
    private final ServiceInfoDataStorage serviceInfoStorage;
    private final boolean decreaseThreads;
    private LinuxProcfsSupport.CpuStat prevCpuStat;
    private LinuxProcfsSupport.CpuStat currCpuStat;
    private LinuxProcfsSupport.ProcessStat prevProcessStat;
    private LinuxProcfsSupport.ProcessStat currProcessStat;

    public ProcDataProviderLinux(DataRowConsumer dataRowConsumer, ServiceInfoDataStorage serviceInfoDataStorage) {
        this.consumer = dataRowConsumer;
        this.serviceInfoStorage = serviceInfoDataStorage;
        String[] stringArray = this.serviceInfoStorage == null || serviceInfoDataStorage.getValue("service.storage.idp.names") == null ? null : serviceInfoDataStorage.getValue("service.storage.idp.names").split(":");
        List list = stringArray == null ? null : Arrays.asList(stringArray);
        this.decreaseThreads = list == null ? false : list.contains(LLDataCollectorConfigurationAccessor.getDefault().getName());
    }

    public String getCommand(int n) {
        return "while head -n1 /proc/stat && head -n1 /proc/" + n + "/stat; do sleep 1; done";
    }

    public void processLine(String string) {
        try {
            if (string.startsWith("cpu")) {
                this.prevCpuStat = this.currCpuStat;
                this.currCpuStat = LinuxProcfsSupport.parseCpuStat(string);
            } else {
                this.prevProcessStat = this.currProcessStat;
                this.currProcessStat = LinuxProcfsSupport.parseProcessStat(string);
                if (this.prevProcessStat != null) {
                    BigInteger bigInteger = this.currCpuStat.all().subtract(this.prevCpuStat.all());
                    BigInteger bigInteger2 = ProcDataProviderLinux.usrTicks(this.currProcessStat).subtract(ProcDataProviderLinux.usrTicks(this.prevProcessStat));
                    BigInteger bigInteger3 = ProcDataProviderLinux.sysTicks(this.currProcessStat).subtract(ProcDataProviderLinux.sysTicks(this.prevProcessStat));
                    long l = this.currProcessStat.num_threads();
                    if (this.decreaseThreads) {
                        --l;
                    }
                    float[] fArray = DLightMath.ensureSumLessOrEqual((float)100.0f, (float[])new float[]{ProcDataProviderLinux.percent(bigInteger2, bigInteger), ProcDataProviderLinux.percent(bigInteger3, bigInteger)});
                    DataRow dataRow = new DataRow(COLNAMES, Arrays.asList(Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), l));
                    this.consumer.consume(dataRow);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void reset() {
        this.currCpuStat = null;
        this.prevCpuStat = null;
        this.currProcessStat = null;
        this.prevProcessStat = null;
    }

    public void close() {
    }

    private static float percent(BigInteger bigInteger, BigInteger bigInteger2) {
        if (BigInteger.ZERO.compareTo(bigInteger2) < 0) {
            if (bigInteger.compareTo(BigInteger.ZERO) <= 0) {
                return 0.0f;
            }
            return bigInteger.multiply(PERCENT).divide(bigInteger2).floatValue();
        }
        return 0.0f;
    }

    private static BigInteger usrTicks(LinuxProcfsSupport.ProcessStat processStat) {
        BigInteger bigInteger = processStat.utime().add(processStat.cutime());
        if (processStat.guest_time() != null) {
            bigInteger = bigInteger.add(processStat.guest_time());
        }
        if (processStat.cguest_time() != null) {
            bigInteger = bigInteger.add(processStat.cguest_time());
        }
        return bigInteger;
    }

    private static BigInteger sysTicks(LinuxProcfsSupport.ProcessStat processStat) {
        BigInteger bigInteger = processStat.stime().add(processStat.cstime());
        if (processStat.delayacct_blkio_ticks() != null) {
            bigInteger = bigInteger.add(processStat.delayacct_blkio_ticks());
        }
        return bigInteger;
    }
}

