/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.parser;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.languages.TokenInput;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.Rule;
import org.netbeans.modules.languages.parser.ASTFeatures;
import org.netbeans.modules.languages.parser.AnalyserAnalyser;
import org.netbeans.modules.languages.parser.First;
import org.netbeans.modules.languages.parser.SyntaxError;
import org.netbeans.modules.languages.parser.TokenInputUtils;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LLSyntaxAnalyser {
    public static final String GAP_TOKEN_TYPE_NAME = "GAP";
    private Language language;
    private List<Rule> grammarRules;
    private First first;
    private Set<Integer> skipTokenTypes;
    private int traceSteps = -1;
    private boolean printFirst = false;

    private LLSyntaxAnalyser(Language language, List<Rule> list, Set<Integer> set) {
        this.language = language;
        this.grammarRules = list;
        this.skipTokenTypes = set;
    }

    public List<Rule> getRules() {
        return this.grammarRules;
    }

    public Set<Integer> getSkipTokenTypes() {
        return this.skipTokenTypes;
    }

    First getFirst() {
        return this.first;
    }

    public static LLSyntaxAnalyser create(Language language, List<Rule> list, Set<Integer> set) throws ParseException {
        LLSyntaxAnalyser lLSyntaxAnalyser = new LLSyntaxAnalyser(language, list, set);
        lLSyntaxAnalyser.initTracing();
        lLSyntaxAnalyser.first = First.create(lLSyntaxAnalyser.grammarRules, language);
        return lLSyntaxAnalyser;
    }

    public static LLSyntaxAnalyser createEmpty(Language language) {
        LLSyntaxAnalyser lLSyntaxAnalyser = new LLSyntaxAnalyser(language, Collections.<Rule>emptyList(), Collections.<Integer>emptySet());
        try {
            lLSyntaxAnalyser.first = First.create(Collections.<Rule>emptyList(), language);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        return lLSyntaxAnalyser;
    }

    public ASTNode read(TokenInput tokenInput, boolean bl, List<SyntaxError> list, boolean[] blArray) throws ParseException {
        Object object2;
        ASTNode aSTNode;
        HashMap<String, List<ASTItem>> hashMap = new HashMap<String, List<ASTItem>>();
        try {
            aSTNode = this.grammarRules.isEmpty() || tokenInput.eof() ? this.readNoGrammar(tokenInput, bl, hashMap, list, blArray) : this.read2(tokenInput, bl, hashMap, list, blArray);
        }
        catch (CancelledException cancelledException) {
            return null;
        }
        if (hashMap.isEmpty()) {
            this.inspect(aSTNode);
            return aSTNode;
        }
        ArrayList<ASTItem> arrayList = new ArrayList<ASTItem>();
        for (Object object2 : hashMap.keySet()) {
            ASTNode aSTNode2;
            String string;
            List list2 = (List)hashMap.get(object2);
            Language language = LanguagesManager.getDefault().getLanguage((String)object2);
            TokenInput tokenInput2 = TokenInputUtils.create(list2);
            ASTNode aSTNode3 = language.getAnalyser().read(tokenInput2, bl, list, blArray);
            if (aSTNode3 == null) continue;
            Feature feature = language.getFeatureList().getFeature("AST");
            if (feature != null && ((string = (String)feature.getValue("process_embedded")) == null || Boolean.valueOf(string).booleanValue()) && (aSTNode2 = (ASTNode)feature.getValue("process", SyntaxContext.create(null, ASTPath.create(aSTNode3)))) != null) {
                aSTNode3 = aSTNode2;
            }
            arrayList.add(aSTNode3);
        }
        arrayList.add(aSTNode);
        object2 = ASTNode.createCompoundASTNode(this.language, "Root", arrayList, 0);
        this.inspect((ASTItem)object2);
        return object2;
    }

    private void inspect(ASTItem aSTItem) {
        Iterator<ASTItem> iterator = new ArrayList<ASTItem>(aSTItem.getChildren()).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ASTItem aSTItem2 = iterator.next();
            if (aSTItem2 instanceof ASTNode && aSTItem instanceof ASTNode) {
                ASTNode aSTNode = (ASTNode)aSTItem2;
                if (this.removeNode(aSTNode)) {
                    ((ASTNode)aSTItem).removeChildren(aSTNode);
                    continue;
                }
                ASTItem aSTItem3 = this.replaceNode(aSTNode);
                if (aSTItem3 != null) {
                    ((ASTNode)aSTItem).setChildren(n, aSTItem3);
                    aSTItem2 = aSTItem3;
                }
            }
            ++n;
            this.inspect(aSTItem2);
        }
    }

    private ASTNode read(TokenInput tokenInput, boolean bl, Map<String, List<ASTItem>> map, List<SyntaxError> list, boolean[] blArray) throws ParseException, CancelledException {
        if (this.grammarRules.isEmpty() || tokenInput.eof()) {
            return this.readNoGrammar(tokenInput, bl, map, list, blArray);
        }
        return this.read2(tokenInput, bl, map, list, blArray);
    }

    private ASTNode read2(TokenInput tokenInput, boolean bl, Map<String, List<ASTItem>> map, List<SyntaxError> list, boolean[] blArray) throws ParseException, CancelledException {
        List<ASTItem> list2;
        Stack<Object> stack = new Stack<Object>();
        ASTNode aSTNode = null;
        ASTNode aSTNode2 = null;
        ListIterator listIterator = Collections.singletonList("S").listIterator();
        boolean bl2 = true;
        while (true) {
            Object object;
            if (blArray[0]) {
                throw new CancelledException();
            }
            int n = tokenInput.getOffset();
            list2 = this.readWhitespaces(aSTNode2, tokenInput, bl, map, list, blArray);
            if (bl2 && tokenInput.eof() && list2 != null) {
                return this.readNoGrammar(list2, n, bl, map, list, blArray);
            }
            if (aSTNode2 != null) {
                n = tokenInput.getOffset();
            }
            while (!listIterator.hasNext() && !stack.empty()) {
                aSTNode2 = (ASTNode)stack.pop();
                listIterator = (ListIterator)stack.pop();
            }
            if (!listIterator.hasNext()) break;
            String string = listIterator.next();
            if (string instanceof String) {
                ASTNode aSTNode3;
                object = string;
                int n2 = this.first.getRule(this.language.getNTID((String)object), tokenInput, this.skipTokenTypes);
                if (n2 < 0) {
                    if (!bl) {
                        if (aSTNode2 == null) {
                            aSTNode = aSTNode2 = ASTNode.create(this.language, "Root", list2, n);
                        }
                        throw new ParseException("Syntax error (nt: " + (String)object + ", tokens: " + tokenInput.next(1) + " " + tokenInput.next(2) + ".", aSTNode);
                    }
                    if (tokenInput.eof()) {
                        if (aSTNode2 == null) {
                            aSTNode = aSTNode2 = ASTNode.create(this.language, "Root", list2, n);
                        }
                        listIterator.previous();
                        listIterator = this.readError(aSTNode2, aSTNode, tokenInput, null, listIterator, stack, map, list, list2, blArray);
                        return aSTNode;
                    }
                    listIterator.previous();
                    listIterator = this.readError(aSTNode2, aSTNode, tokenInput, null, listIterator, stack, map, list, list2, blArray);
                    continue;
                }
                Rule rule = this.grammarRules.get(n2);
                Feature feature = this.language.getFeatureList().getFeature("PARSE", rule.getNT());
                if (feature != null) {
                    stack.push(listIterator);
                    stack.push(aSTNode2);
                    listIterator = Collections.EMPTY_LIST.listIterator();
                    aSTNode3 = (ASTNode)feature.getValue(new Object[]{tokenInput, stack});
                    if (aSTNode3 == null) continue;
                    aSTNode2.addChildren(aSTNode3);
                    continue;
                }
                if (aSTNode2 == null || listIterator.hasNext() || !((String)object).equals(aSTNode2.getNT())) {
                    if (((String)object).indexOf(36) > 0 || ((String)object).indexOf(35) > 0) {
                        stack.push(listIterator);
                        stack.push(aSTNode2);
                    } else {
                        if (rule.getRight().isEmpty() && this.removeEmpty(this.language, rule.getNT())) continue;
                        aSTNode3 = ASTNode.create(this.language, rule.getNT(), list2, n);
                        if (aSTNode2 != null) {
                            aSTNode2.addChildren(aSTNode3);
                            stack.push(listIterator);
                            stack.push(aSTNode2);
                        } else {
                            aSTNode = aSTNode3;
                        }
                        aSTNode2 = aSTNode3;
                    }
                }
                listIterator = rule.getRight().listIterator();
                continue;
            }
            object = (ASTToken)((Object)string);
            if (tokenInput.eof()) {
                if (!bl) {
                    throw new ParseException("Unexpected end of file.", aSTNode);
                }
                listIterator.previous();
                listIterator = this.readError(aSTNode2, aSTNode, tokenInput, (ASTToken)object, listIterator, stack, map, list, list2, blArray);
                return aSTNode;
            }
            if (!LLSyntaxAnalyser.isCompatible((ASTToken)object, tokenInput.next(1))) {
                if (tokenInput.next(1).getTypeName().equals(GAP_TOKEN_TYPE_NAME)) {
                    tokenInput.read();
                    continue;
                }
                if (!bl) {
                    throw new ParseException("Unexpected token " + tokenInput.next(1) + ". Expecting " + object, aSTNode);
                }
                listIterator.previous();
                listIterator = this.readError(aSTNode2, aSTNode, tokenInput, (ASTToken)object, listIterator, stack, map, list, list2, blArray);
                continue;
            }
            aSTNode2.addChildren(this.readEmbeddings(tokenInput.read(), bl, map, list, blArray));
        }
        if (!bl && !tokenInput.eof()) {
            throw new ParseException("Unexpected token " + tokenInput.next(1) + ".", aSTNode);
        }
        while (!tokenInput.eof()) {
            listIterator = this.readError(aSTNode2, aSTNode, tokenInput, null, listIterator, stack, map, list, list2, blArray);
        }
        if (aSTNode == null) {
            aSTNode = ASTNode.create(this.language, "Root", list2, tokenInput.getOffset());
        }
        return aSTNode;
    }

    private static boolean isCompatible(ASTToken aSTToken, ASTToken aSTToken2) {
        if (aSTToken.getTypeID() == -1) {
            return aSTToken.getIdentifier().equals(aSTToken2.getIdentifier());
        }
        if (aSTToken.getIdentifier() == null) {
            return aSTToken.getTypeID() == aSTToken2.getTypeID();
        }
        return aSTToken.getTypeID() == aSTToken2.getTypeID() && aSTToken.getIdentifier().equals(aSTToken2.getIdentifier());
    }

    private List<ASTItem> readWhitespaces(ASTNode aSTNode, TokenInput tokenInput, boolean bl, Map<String, List<ASTItem>> map, List<SyntaxError> list, boolean[] blArray) throws ParseException, CancelledException {
        ArrayList<ASTItem> arrayList = null;
        while (!tokenInput.eof() && this.skipTokenTypes.contains(tokenInput.next(1).getTypeID())) {
            if (blArray[0]) {
                throw new CancelledException();
            }
            ASTToken aSTToken = tokenInput.read();
            if (aSTNode != null) {
                aSTNode.addChildren(this.readEmbeddings(aSTToken, bl, map, list, blArray));
                continue;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<ASTItem>();
            }
            arrayList.add(this.readEmbeddings(aSTToken, bl, map, list, blArray));
        }
        return arrayList;
    }

    private ASTItem readEmbeddings(ASTToken aSTToken, boolean bl, Map<String, List<ASTItem>> map, List<SyntaxError> list, boolean[] blArray) throws ParseException, CancelledException {
        ASTNode aSTNode;
        String string;
        Feature feature;
        Object object;
        List<ASTItem> list2 = aSTToken.getChildren();
        if (list2.isEmpty()) {
            return aSTToken;
        }
        TokenInput tokenInput = TokenInputUtils.create(list2);
        String string2 = list2.get(0).getMimeType();
        Language language = (Language)list2.get(0).getLanguage();
        if (language == null) {
            return this.readNoGrammar(tokenInput, bl, map, list, blArray);
        }
        Feature feature2 = language.getFeatureList().getFeature("AST");
        if (feature2 != null && (object = (String)feature2.getValue("skip_embedded")) != null && Boolean.valueOf((String)object).booleanValue()) {
            return this.skipEmbedding(aSTToken, map, list2, string2);
        }
        object = (Language)aSTToken.getLanguage();
        if (object != null) {
            feature = ((Language)object).getPreprocessorImport();
            if (feature != null && feature.getValue("mimeType").equals(string2) && feature.getBoolean("continual", false)) {
                return this.skipEmbedding(aSTToken, map, list2, string2);
            }
            feature = ((Language)object).getTokenImports().get(aSTToken.getTypeName());
            if (feature != null && feature.getValue("mimeType").equals(string2) && feature.getBoolean("continual", false)) {
                return this.skipEmbedding(aSTToken, map, list2, string2);
            }
        }
        feature = language.getFeatureList().getFeature("AST");
        ASTNode aSTNode2 = language.getAnalyser().read(tokenInput, bl, map, list, blArray);
        if (feature != null && ((string = (String)feature.getValue("process_embedded")) == null || Boolean.valueOf(string).booleanValue()) && (aSTNode = (ASTNode)feature.getValue("process", SyntaxContext.create(null, ASTPath.create(aSTNode2)))) != null) {
            aSTNode2 = aSTNode;
        }
        return ASTToken.create((org.netbeans.api.languages.Language)object, aSTToken.getTypeID(), aSTToken.getIdentifier(), aSTToken.getOffset(), aSTToken.getLength(), Collections.singletonList(aSTNode2));
    }

    private ASTToken skipEmbedding(ASTToken aSTToken, Map<String, List<ASTItem>> map, List<ASTItem> list, String string) {
        List<ASTItem> list2 = map.get(string);
        if (list2 == null) {
            list2 = new ArrayList<ASTItem>();
            map.put(string, list2);
            list2.addAll(list.subList(0, list.size()));
            LLSyntaxAnalyser.appendGap(list2);
        } else {
            ASTToken aSTToken2 = (ASTToken)list2.get(list2.size() - 1);
            ASTToken aSTToken3 = (ASTToken)list.get(0);
            if (aSTToken2.getTypeID() == aSTToken3.getTypeID()) {
                list2.remove(list2.size() - 1);
                ASTToken aSTToken4 = LLSyntaxAnalyser.join(aSTToken2, aSTToken3);
                list2.add(aSTToken4);
                list2.addAll(list.subList(1, list.size()));
            } else {
                list2.addAll(list);
            }
            LLSyntaxAnalyser.appendGap(list2);
        }
        return ASTToken.create(aSTToken.getLanguage(), aSTToken.getTypeID(), aSTToken.getIdentifier(), aSTToken.getOffset(), aSTToken.getLength(), Collections.emptyList());
    }

    private static ASTToken join(ASTToken aSTToken, ASTToken aSTToken2) {
        List<ASTItem> list = aSTToken.getChildren();
        List<ASTItem> list2 = aSTToken2.getChildren();
        ArrayList<ASTItem> arrayList = new ArrayList<ASTItem>();
        if (list.size() > 1 && list2.size() > 0) {
            ASTToken aSTToken3 = (ASTToken)list.get(list.size() - 2);
            ASTToken aSTToken4 = (ASTToken)list2.get(0);
            if ("js_string".equals(aSTToken3.getTypeName()) && "js_string".equals(aSTToken4.getTypeName()) || "css_string".equals(aSTToken3.getTypeName()) && "css_string".equals(aSTToken4.getTypeName())) {
                arrayList.addAll(list.subList(0, list.size() - 2));
                arrayList.add(ASTToken.create(aSTToken3.getLanguage(), aSTToken3.getTypeID(), aSTToken3.getIdentifier() + aSTToken4.getIdentifier(), aSTToken3.getOffset()));
                arrayList.addAll(list2.subList(1, list2.size()));
            } else {
                arrayList.addAll(list);
                arrayList.addAll(list2);
            }
        } else {
            arrayList.addAll(list);
            arrayList.addAll(list2);
        }
        return ASTToken.create(aSTToken.getLanguage(), aSTToken.getTypeID(), "", aSTToken.getOffset(), aSTToken2.getEndOffset() - aSTToken.getOffset(), arrayList);
    }

    private static void appendGap(List<ASTItem> list) {
        ASTToken aSTToken = (ASTToken)list.get(list.size() - 1);
        if (aSTToken.getChildren().isEmpty()) {
            return;
        }
        ArrayList<ASTItem> arrayList = new ArrayList<ASTItem>(aSTToken.getChildren());
        arrayList.add(ASTToken.create(((ASTItem)arrayList.get(0)).getLanguage(), GAP_TOKEN_TYPE_NAME, "", ((ASTItem)arrayList.get(arrayList.size() - 1)).getEndOffset(), 0, null));
        list.remove(list.size() - 1);
        list.add(ASTToken.create(aSTToken.getLanguage(), aSTToken.getTypeID(), aSTToken.getIdentifier(), aSTToken.getOffset(), aSTToken.getLength(), arrayList));
    }

    private ASTNode readNoGrammar(TokenInput tokenInput, boolean bl, Map<String, List<ASTItem>> map, List<SyntaxError> list, boolean[] blArray) throws ParseException, CancelledException {
        ASTNode aSTNode = ASTNode.create(this.language, "S", tokenInput.getIndex());
        while (!tokenInput.eof()) {
            if (blArray[0]) {
                throw new CancelledException();
            }
            ASTToken aSTToken = tokenInput.read();
            aSTNode.addChildren(this.readEmbeddings(aSTToken, bl, map, list, blArray));
        }
        return aSTNode;
    }

    private ASTNode readNoGrammar(List list, int n, boolean bl, Map<String, List<ASTItem>> map, List<SyntaxError> list2, boolean[] blArray) throws ParseException, CancelledException {
        ASTNode aSTNode = ASTNode.create(this.language, "S", n);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (blArray[0]) {
                throw new CancelledException();
            }
            ASTToken aSTToken = (ASTToken)iterator.next();
            aSTNode.addChildren(this.readEmbeddings(aSTToken, bl, map, list2, blArray));
        }
        return aSTNode;
    }

    private ListIterator readError(ASTNode aSTNode, ASTNode aSTNode2, TokenInput tokenInput, ASTToken aSTToken, ListIterator listIterator, Stack stack, Map<String, List<ASTItem>> map, List<SyntaxError> list, List<ASTItem> list2, boolean[] blArray) throws ParseException, CancelledException {
        ListIterator listIterator2 = this.findError(aSTNode, aSTNode, tokenInput, aSTToken, listIterator, stack, map, list, blArray);
        if (listIterator2 != null) {
            return listIterator2;
        }
        if (aSTNode2 != aSTNode) {
            ASTNode aSTNode3 = aSTNode2;
            while (aSTNode3 != null) {
                ASTItem aSTItem;
                listIterator2 = this.findError(aSTNode3, aSTNode, tokenInput, aSTToken, listIterator, stack, map, list, blArray);
                if (listIterator2 != null) {
                    return listIterator2;
                }
                List<ASTItem> list3 = aSTNode3.getChildren();
                if (list3.isEmpty() || !((aSTItem = list3.get(list3.size() - 1)) instanceof ASTNode) || aSTItem == aSTNode) break;
                aSTNode3 = (ASTNode)aSTItem;
            }
        }
        this.createError(tokenInput, aSTToken, list, null);
        if (!tokenInput.eof()) {
            if (aSTNode != null) {
                aSTNode.addChildren(this.readEmbeddings(tokenInput.read(), true, map, list, blArray));
            } else {
                if (list2 == null) {
                    list2 = new ArrayList<ASTItem>();
                }
                list2.add(this.readEmbeddings(tokenInput.read(), true, map, list, blArray));
            }
        }
        return listIterator;
    }

    private ListIterator findError(ASTNode aSTNode, ASTNode aSTNode2, TokenInput tokenInput, ASTToken aSTToken, ListIterator listIterator, Stack stack, Map<String, List<ASTItem>> map, List<SyntaxError> list, boolean[] blArray) throws ParseException, CancelledException {
        String string = aSTNode == null ? "S" : aSTNode.getNT();
        List<Feature> list2 = this.language.getFeatureList().getFeatures("SYNTAX_ERROR", string);
        if (list2.isEmpty()) {
            return null;
        }
        boolean bl = false;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Feature object2 : list2) {
            boolean string7 = object2.getBoolean("eof", false);
            String string2 = (String)object2.getValue("next_token_type_name");
            String string3 = (String)object2.getValue("next_token_identifier");
            if (!(string7 && tokenInput.eof() || !tokenInput.eof() && string2 != null && string2.equals(tokenInput.next(1).getTypeName()) || !tokenInput.eof() && string3 != null && string3.equals(tokenInput.next(1).getIdentifier())) && (string7 || string3 != null || string2 != null)) continue;
            String string4 = (String)object2.getValue("message");
            String string5 = (String)object2.getValue("token_identifier");
            String string6 = (String)object2.getValue("nt");
            if (string5 != null) {
                hashMap.put(string5, string6);
            }
            if (string4 == null || bl) continue;
            this.createError(tokenInput, aSTToken, list, string4);
            bl = true;
        }
        if (!bl) {
            this.createError(tokenInput, aSTToken, list, null);
        }
        if (hashMap.isEmpty()) {
            if (!tokenInput.eof()) {
                aSTNode2.addChildren(this.readEmbeddings(tokenInput.read(), true, map, list, blArray));
            }
            return listIterator;
        }
        while (!tokenInput.eof() && !hashMap.containsKey(tokenInput.next(1).getIdentifier())) {
            aSTNode2.addChildren(this.readEmbeddings(tokenInput.read(), true, map, list, blArray));
        }
        if (tokenInput.eof()) {
            return listIterator;
        }
        String string7 = (String)hashMap.get(tokenInput.next(1).getIdentifier());
        if (string7 != null) {
            String string8 = aSTNode2.getNT();
            while (!string8.equals(string7) && !stack.isEmpty()) {
                string8 = ((ASTNode)stack.pop()).getNT();
                listIterator = (ListIterator)stack.pop();
            }
        }
        return listIterator;
    }

    private void createError(TokenInput tokenInput, ASTToken aSTToken, List<SyntaxError> list, String string) {
        ASTToken aSTToken2;
        ASTToken aSTToken3 = aSTToken2 = tokenInput.eof() ? ASTToken.create(null, 0, "", tokenInput.getOffset()) : tokenInput.next(1);
        if (string == null) {
            String string2;
            string = aSTToken != null ? (aSTToken.getIdentifier() != null ? MessageFormat.format(NbBundle.getMessage(LLSyntaxAnalyser.class, (String)"CTL_ID_expected"), aSTToken.getIdentifier()) : ((string2 = aSTToken.getTypeName()).contains("identifier") ? NbBundle.getMessage(LLSyntaxAnalyser.class, (String)"CTL_Identifier_expected") : (string2.contains("string") ? NbBundle.getMessage(LLSyntaxAnalyser.class, (String)"CTL_String_expected") : (string2.contains("keyword") ? NbBundle.getMessage(LLSyntaxAnalyser.class, (String)"CTL_Keyword_expected") : MessageFormat.format(NbBundle.getMessage(LLSyntaxAnalyser.class, (String)"CTL_Type_expected"), string2))))) : (tokenInput.eof() ? NbBundle.getMessage(LLSyntaxAnalyser.class, (String)"CTL_Unexpected_end_of_file") : MessageFormat.format(NbBundle.getMessage(LLSyntaxAnalyser.class, (String)"CTL_Unexpected_token_ID"), tokenInput.next(1).getIdentifier()));
        }
        list.add(new SyntaxError(aSTToken2, string));
    }

    private void initTracing() {
        Feature feature = this.language.getFeatureList().getFeature("PROPERTIES");
        if (feature == null) {
            return;
        }
        try {
            this.traceSteps = Integer.parseInt((String)feature.getValue("traceSteps"));
        }
        catch (NumberFormatException numberFormatException) {
            this.traceSteps = -2;
        }
        if (feature.getBoolean("printRules", false)) {
            AnalyserAnalyser.printRules(this.grammarRules, null);
        }
        this.printFirst = feature.getBoolean("printFirst", false);
    }

    private boolean removeNode(ASTNode aSTNode) {
        List<ASTItem> list = aSTNode.getChildren();
        if (!list.isEmpty()) {
            return false;
        }
        ASTFeatures aSTFeatures = ASTFeatures.get((Language)aSTNode.getLanguage());
        return aSTFeatures.removeEmpty || aSTFeatures.removeEmptyN == aSTFeatures.empty.contains(aSTNode.getNT());
    }

    private ASTItem replaceNode(ASTNode aSTNode) {
        ASTFeatures aSTFeatures = ASTFeatures.get((Language)aSTNode.getLanguage());
        ASTItem aSTItem = null;
        List<ASTItem> list;
        while ((list = aSTNode.getChildren()).size() == 1) {
            if (!aSTFeatures.removeSimple && aSTFeatures.removeSimpleN != aSTFeatures.simple.contains(aSTNode.getNT())) {
                return aSTItem;
            }
            aSTItem = list.get(0);
            if (!(aSTItem instanceof ASTNode)) {
                return aSTItem;
            }
            aSTNode = (ASTNode)aSTItem;
        }
        return aSTItem;
    }

    private boolean removeEmpty(Language language, String string) {
        ASTFeatures aSTFeatures = ASTFeatures.get(language);
        return aSTFeatures.removeEmpty || aSTFeatures.removeEmptyN == aSTFeatures.empty.contains(string);
    }

    private class CancelledException
    extends Exception {
        private CancelledException() {
        }
    }

    public static class T {
        int type;
        String identifier;

        T(ASTToken aSTToken) {
            this.type = aSTToken.getTypeID();
            this.identifier = aSTToken.getIdentifier();
        }

        public boolean equals(Object object) {
            if (!(object instanceof T)) {
                return false;
            }
            return !(((T)object).type != -1 && ((T)object).type != this.type || ((T)object).identifier != null && !((T)object).identifier.equals(this.identifier));
        }

        public int hashCode() {
            return (this.type + 1) * (this.identifier == null ? -1 : this.identifier.hashCode());
        }

        public String toString() {
            if (this.type == -1) {
                return "\"" + this.identifier + "\"";
            }
            if (this.identifier == null) {
                return "<" + this.type + ">";
            }
            return "[" + this.type + "," + this.identifier + "]";
        }

        public String toString(Language language) {
            if (this.type == -1) {
                return "\"" + this.identifier + "\"";
            }
            String string = language.getTokenType(this.type);
            if (this.identifier == null) {
                return "<" + string + ">";
            }
            return "[" + string + "," + this.identifier + "]";
        }
    }
}

