/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.EventSetDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.FormEvents;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.wizard.ConnectionWizardPanel1;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class ConnectionPanel1
extends JPanel {
    private ConnectionWizardPanel1 wizardPanel;
    private JTree eventSelectTree;
    private JLabel eventNameLabel;
    private JPanel sourcePanel;
    private JScrollPane eventSelectScroll;
    private JLabel eventSelectLabel;
    private JPanel sourceNamePanel;
    private JPanel sourceInfoPanel;
    private JPanel eventHandlerPanel;
    private JLabel sourceNameLabel;
    private JTextField sourceComponentName;
    private JComboBox eventNameCombo;
    private JPanel eventSelectLabelPanel;

    ConnectionPanel1(ConnectionWizardPanel1 connectionWizardPanel1) {
        this.wizardPanel = connectionWizardPanel1;
        this.initComponents();
        RADComponent rADComponent = connectionWizardPanel1.getSourceComponent();
        ResourceBundle resourceBundle = NbBundle.getBundle(ConnectionPanel1.class);
        this.setName(resourceBundle.getString("CTL_CW_Step1_Title"));
        this.sourceComponentName.setText(rADComponent.getName());
        this.eventNameCombo.setEnabled(connectionWizardPanel1.getSelectedEvent() != null);
        this.eventNameCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionPanel1.this.wizardPanel.fireStateChanged();
            }
        });
        this.eventNameCombo.getEditor().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionPanel1.this.wizardPanel.fireStateChanged();
            }
        });
        final Vector<EventSetNode> vector = new Vector<EventSetNode>();
        TreeNode treeNode = new TreeNode(){

            public TreeNode getChildAt(int n) {
                return (TreeNode)vector.elementAt(n);
            }

            public int getChildCount() {
                return vector.size();
            }

            public TreeNode getParent() {
                return null;
            }

            public int getIndex(TreeNode treeNode) {
                return vector.indexOf(treeNode);
            }

            public boolean getAllowsChildren() {
                return true;
            }

            public boolean isLeaf() {
                return false;
            }

            public Enumeration children() {
                return vector.elements();
            }
        };
        EventSetDescriptor eventSetDescriptor = null;
        EventSetNode eventSetNode = null;
        ArrayList<EventNode> arrayList = null;
        Event[] eventArray = rADComponent.getAllEvents();
        for (int i = 0; i < eventArray.length; ++i) {
            Event event = eventArray[i];
            EventSetDescriptor eventSetDescriptor2 = event.getEventSetDescriptor();
            if (eventSetDescriptor2 != eventSetDescriptor) {
                arrayList = new ArrayList<EventNode>();
                eventSetNode = new EventSetNode(eventSetDescriptor2.getName(), arrayList);
                vector.add(eventSetNode);
                eventSetDescriptor = eventSetDescriptor2;
            }
            arrayList.add(new EventNode(eventSetNode, event));
        }
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreeNode treeNode;
                TreePath[] treePathArray = ConnectionPanel1.this.eventSelectTree.getSelectionPaths();
                if (treePathArray != null && treePathArray.length == 1 && (treeNode = (TreeNode)treePathArray[0].getLastPathComponent()) != null && treeNode instanceof EventNode) {
                    ConnectionPanel1.this.setSelectedEvent(((EventNode)treeNode).getEvent());
                    return;
                }
                ConnectionPanel1.this.setSelectedEvent(null);
            }
        });
        defaultTreeSelectionModel.setSelectionMode(1);
        this.eventSelectTree.setModel(new DefaultTreeModel(treeNode));
        this.eventSelectTree.setSelectionModel(defaultTreeSelectionModel);
        Mnemonics.setLocalizedText((JLabel)this.sourceNameLabel, (String)resourceBundle.getString("CTL_CW_SourceComponent"));
        this.sourceComponentName.setToolTipText(resourceBundle.getString("CTL_CW_SourceComponent_Hint"));
        Mnemonics.setLocalizedText((JLabel)this.eventSelectLabel, (String)resourceBundle.getString("CTL_CW_Event"));
        this.eventSelectTree.setToolTipText(resourceBundle.getString("CTL_CW_Event_Hint"));
        this.sourcePanel.setToolTipText(resourceBundle.getString("CTL_CW_Event_Hint"));
        this.eventHandlerPanel.setBorder(new CompoundBorder(new TitledBorder(new EtchedBorder(), resourceBundle.getString("CTL_CW_EventHandlerMethod")), new EmptyBorder(new Insets(5, 5, 5, 5))));
        Mnemonics.setLocalizedText((JLabel)this.eventNameLabel, (String)resourceBundle.getString("CTL_CW_MethodName"));
        this.eventSelectTree.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CW_EventTree"));
        this.eventNameCombo.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CW_MethodName"));
        this.sourceComponentName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CW_SourceComponent"));
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CW_ConnectionPanel1"));
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
    }

    public Dimension getPreferredSize() {
        return new Dimension(450, 300);
    }

    String getEventName() {
        return (String)this.eventNameCombo.getEditor().getItem();
    }

    private void setSelectedEvent(Event event) {
        this.eventNameCombo.removeAllItems();
        if (event != null) {
            this.eventNameCombo.setEnabled(true);
            FormEvents formEvents = this.wizardPanel.getSourceComponent().getFormModel().getFormEvents();
            String string = formEvents.findFreeHandlerName(event, this.wizardPanel.getSourceComponent());
            this.eventNameCombo.addItem(string);
            if (event.hasEventHandlers()) {
                String[] stringArray = event.getEventHandlers();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.eventNameCombo.addItem(stringArray[i]);
                }
            }
            this.eventNameCombo.setSelectedIndex(0);
        } else {
            this.eventNameCombo.setEnabled(false);
        }
        this.wizardPanel.setSelectedEvent(event);
    }

    private void initComponents() {
        this.sourcePanel = new JPanel();
        this.sourceInfoPanel = new JPanel();
        this.sourceNamePanel = new JPanel();
        this.sourceNameLabel = new JLabel();
        this.sourceComponentName = new JTextField();
        this.eventSelectLabelPanel = new JPanel();
        this.eventSelectLabel = new JLabel();
        this.eventSelectScroll = new JScrollPane();
        this.eventSelectTree = new JTree();
        this.eventHandlerPanel = new JPanel();
        this.eventNameLabel = new JLabel();
        this.eventNameCombo = new JComboBox();
        this.setLayout(new BorderLayout(0, 11));
        this.sourcePanel.setLayout(new BorderLayout());
        this.sourceInfoPanel.setLayout(new GridLayout(2, 1));
        this.sourceNamePanel.setLayout(new FlowLayout(0, 0, 0));
        this.sourceNameLabel.setLabelFor(this.sourceComponentName);
        this.sourceNameLabel.setText("Source Component:");
        this.sourceNameLabel.setBorder(new EmptyBorder(new Insets(0, 0, 0, 6)));
        this.sourceNamePanel.add(this.sourceNameLabel);
        this.sourceComponentName.setEditable(false);
        this.sourceComponentName.setText("jTextField1");
        this.sourceNamePanel.add(this.sourceComponentName);
        this.sourceInfoPanel.add(this.sourceNamePanel);
        this.eventSelectLabelPanel.setLayout(new FlowLayout(0, 0, 3));
        this.eventSelectLabel.setLabelFor(this.eventSelectTree);
        this.eventSelectLabel.setText("Events");
        this.eventSelectLabelPanel.add(this.eventSelectLabel);
        this.sourceInfoPanel.add(this.eventSelectLabelPanel);
        this.sourcePanel.add((Component)this.sourceInfoPanel, "North");
        this.eventSelectScroll.setMaximumSize(new Dimension(Short.MAX_VALUE, 100));
        this.eventSelectTree.setRootVisible(false);
        this.eventSelectTree.setShowsRootHandles(true);
        this.eventSelectScroll.setViewportView(this.eventSelectTree);
        this.sourcePanel.add((Component)this.eventSelectScroll, "Center");
        this.add((Component)this.sourcePanel, "Center");
        this.eventHandlerPanel.setLayout(new BorderLayout(8, 0));
        this.eventHandlerPanel.setBorder(new TitledBorder("Event Handler Method"));
        this.eventNameLabel.setLabelFor(this.eventNameCombo);
        this.eventNameLabel.setText("Method Name:");
        this.eventHandlerPanel.add((Component)this.eventNameLabel, "West");
        this.eventNameCombo.setEditable(true);
        this.eventHandlerPanel.add((Component)this.eventNameCombo, "Center");
        this.add((Component)this.eventHandlerPanel, "South");
    }

    static class EventNode
    implements TreeNode {
        private TreeNode parent;
        private Event event;

        public EventNode(TreeNode treeNode, Event event) {
            this.parent = treeNode;
            this.event = event;
        }

        public TreeNode getChildAt(int n) {
            return null;
        }

        public int getChildCount() {
            return 0;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public int getIndex(TreeNode treeNode) {
            return -1;
        }

        public boolean getAllowsChildren() {
            return false;
        }

        public boolean isLeaf() {
            return true;
        }

        public Enumeration children() {
            return null;
        }

        public String toString() {
            if (!this.event.hasEventHandlers()) {
                return this.event.getName();
            }
            String[] stringArray = this.event.getEventHandlers();
            if (stringArray.length == 1) {
                return this.event.getName() + " [" + stringArray[0] + "]";
            }
            return this.event.getName() + " [...]";
        }

        Event getEvent() {
            return this.event;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EventSetNode
    implements TreeNode {
        private String eventSetName;
        private List<EventNode> subNodes;

        public EventSetNode(String string, List<EventNode> list) {
            this.eventSetName = string;
            this.subNodes = list;
        }

        @Override
        public TreeNode getChildAt(int n) {
            return this.subNodes.get(n);
        }

        @Override
        public int getChildCount() {
            return this.subNodes.size();
        }

        @Override
        public TreeNode getParent() {
            return null;
        }

        @Override
        public int getIndex(TreeNode treeNode) {
            return this.subNodes.indexOf(treeNode);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        public Enumeration children() {
            return Collections.enumeration(this.subNodes);
        }

        public String toString() {
            return this.eventSetName;
        }
    }
}

