/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.delegates;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.Method;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeGroup;
import org.netbeans.modules.form.codestructure.CodeStatement;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.layoutsupport.AbstractLayoutSupport;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.openide.nodes.Node;

public class JSplitPaneSupport
extends AbstractLayoutSupport {
    private static Method setLeftComponentMethod;
    private static Method setRightComponentMethod;
    private static Method setTopComponentMethod;
    private static Method setBottomComponentMethod;
    private static final String LEFT_TOP_BUTTON = "cp_left_top_button";
    private static final String RIGHT_BOTTOM_BUTTON = "cp_right_bottom_button";
    private String assistantParams;

    public Class getSupportedClass() {
        return JSplitPane.class;
    }

    public LayoutConstraints getNewConstraints(Container container, Container container2, Component component, int n, Point point, Point point2) {
        if (!(container instanceof JSplitPane)) {
            return null;
        }
        JSplitPane jSplitPane = (JSplitPane)container;
        Dimension dimension = jSplitPane.getSize();
        int n2 = jSplitPane.getOrientation();
        JButton jButton = (JButton)jSplitPane.getClientProperty(LEFT_TOP_BUTTON);
        JButton jButton2 = (JButton)jSplitPane.getClientProperty(RIGHT_BOTTOM_BUTTON);
        if (jButton == null && jButton2 == null || jButton != null && jButton2 != null) {
            String string = n2 == 1 ? (point.x <= dimension.width / 2 ? "left" : "right") : (point.y <= dimension.height / 2 ? "top" : "bottom");
            this.assistantParams = string;
            return new SplitConstraints(string);
        }
        this.assistantParams = this.findFreePosition();
        return new SplitConstraints(this.assistantParams);
    }

    public String getAssistantContext() {
        return "splitPaneLayout";
    }

    public Object[] getAssistantParams() {
        return new Object[]{this.assistantParams};
    }

    public boolean paintDragFeedback(Container container, Container container2, Component component, LayoutConstraints layoutConstraints, int n, Graphics graphics) {
        if (!(container instanceof JSplitPane)) {
            return false;
        }
        String string = (String)layoutConstraints.getConstraintsObject();
        if (string == null) {
            return false;
        }
        JSplitPane jSplitPane = (JSplitPane)container;
        int n2 = jSplitPane.getOrientation();
        Dimension dimension = jSplitPane.getSize();
        Insets insets = container.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        Rectangle rectangle = new Rectangle(insets.left, insets.top, dimension.width, dimension.height);
        if (n2 == 1) {
            Component component2 = jSplitPane.getLeftComponent();
            Component component3 = jSplitPane.getRightComponent();
            if (string == "left") {
                rectangle.width = component3 == null || component3 == component ? dimension.width / 2 : component3.getBounds().x - rectangle.x;
            } else if (component2 == null || component2 == component) {
                rectangle.x = insets.left + dimension.width / 2;
                rectangle.width = dimension.width - rectangle.x;
            } else {
                rectangle.x = component2.getBounds().x + component2.getBounds().width;
                rectangle.width = dimension.width - rectangle.x;
            }
        } else {
            Component component4 = jSplitPane.getTopComponent();
            Component component5 = jSplitPane.getBottomComponent();
            if (string == "top") {
                rectangle.height = component5 == null || component5 == component ? (rectangle.height /= 2) : component5.getBounds().y - rectangle.y;
            } else if (component4 == null || component4 == component) {
                rectangle.y = insets.top + dimension.height / 2;
                rectangle.height = dimension.height - rectangle.y;
            } else {
                rectangle.y = component4.getBounds().y + component4.getBounds().height;
                rectangle.height = dimension.height - rectangle.y;
            }
        }
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        return true;
    }

    public void addComponentsToContainer(Container container, Container container2, Component[] componentArray, int n) {
        if (!(container instanceof JSplitPane)) {
            return;
        }
        for (int i = 0; i < componentArray.length; ++i) {
            JSplitPane jSplitPane = (JSplitPane)container;
            int n2 = this.convertPosition(this.getConstraints(i + n));
            if (n2 == 0) {
                if (jSplitPane.getClientProperty(LEFT_TOP_BUTTON) == null) {
                    jSplitPane.putClientProperty(LEFT_TOP_BUTTON, jSplitPane.getLeftComponent());
                }
                jSplitPane.setLeftComponent(componentArray[i]);
                continue;
            }
            if (n2 != 1) continue;
            if (jSplitPane.getClientProperty(RIGHT_BOTTOM_BUTTON) == null) {
                jSplitPane.putClientProperty(RIGHT_BOTTOM_BUTTON, jSplitPane.getRightComponent());
            }
            jSplitPane.setRightComponent(componentArray[i]);
        }
    }

    public boolean removeComponentFromContainer(Container container, Container container2, Component component) {
        if (!(container2 instanceof JSplitPane)) {
            return false;
        }
        JSplitPane jSplitPane = (JSplitPane)container2;
        if (component == jSplitPane.getLeftComponent()) {
            if (super.removeComponentFromContainer(container, container2, component)) {
                JButton jButton = (JButton)jSplitPane.getClientProperty(LEFT_TOP_BUTTON);
                if (jButton != null) {
                    jSplitPane.setLeftComponent(jButton);
                    jSplitPane.putClientProperty(LEFT_TOP_BUTTON, null);
                }
                return true;
            }
        } else if (component == jSplitPane.getRightComponent() && super.removeComponentFromContainer(container, container2, component)) {
            JButton jButton = (JButton)jSplitPane.getClientProperty(RIGHT_BOTTOM_BUTTON);
            if (jButton != null) {
                jSplitPane.setRightComponent(jButton);
                jSplitPane.putClientProperty(RIGHT_BOTTOM_BUTTON, null);
            }
            return true;
        }
        return super.removeComponentFromContainer(container, container2, component);
    }

    public boolean clearContainer(Container container, Container container2) {
        JSplitPane jSplitPane = (JSplitPane)container;
        JButton jButton = (JButton)jSplitPane.getClientProperty(LEFT_TOP_BUTTON);
        JButton jButton2 = (JButton)jSplitPane.getClientProperty(RIGHT_BOTTOM_BUTTON);
        if (jButton != null) {
            this.removeComponentFromContainer(container, container2, jSplitPane.getLeftComponent());
        }
        if (jButton2 != null) {
            this.removeComponentFromContainer(container, container2, jSplitPane.getRightComponent());
        }
        return true;
    }

    protected CodeExpression readComponentCode(CodeStatement codeStatement, CodeGroup codeGroup) {
        CodeExpression[] codeExpressionArray = codeStatement.getStatementParameters();
        if (codeExpressionArray.length != 1) {
            return null;
        }
        String string = null;
        Object object = codeStatement.getMetaObject();
        if (JSplitPaneSupport.getSimpleAddMethod().equals(object)) {
            string = this.getComponentCount() == 0 ? "left" : "right";
        } else if (JSplitPaneSupport.getSetLeftComponentMethod().equals(object)) {
            string = "left";
        } else if (JSplitPaneSupport.getSetRightComponentMethod().equals(object)) {
            string = "right";
        } else if (JSplitPaneSupport.getSetTopComponentMethod().equals(object)) {
            string = "top";
        } else if (JSplitPaneSupport.getSetBottomComponentMethod().equals(object)) {
            string = "bottom";
        }
        SplitConstraints splitConstraints = new SplitConstraints(string);
        this.getConstraintsList().add(splitConstraints);
        codeGroup.addStatement(codeStatement);
        return codeExpressionArray[0];
    }

    protected void createComponentCode(CodeGroup codeGroup, CodeExpression codeExpression, int n) {
        LayoutConstraints layoutConstraints = this.getConstraints(n);
        if (!(layoutConstraints instanceof SplitConstraints)) {
            return;
        }
        ((SplitConstraints)layoutConstraints).createComponentCode(codeGroup, this.getLayoutContext().getContainerCodeExpression(), codeExpression);
    }

    protected LayoutConstraints createDefaultConstraints() {
        return new SplitConstraints(this.findFreePosition());
    }

    private int convertPosition(LayoutConstraints layoutConstraints) {
        if (layoutConstraints != null) {
            Object object = layoutConstraints.getConstraintsObject();
            if ("left".equals(object) || "top".equals(object)) {
                return 0;
            }
            if ("right".equals(object) || "bottom".equals(object)) {
                return 1;
            }
        }
        return -1;
    }

    private String findFreePosition() {
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        int n3 = this.getComponentCount();
        for (int i = 0; i < n3; ++i) {
            LayoutConstraints layoutConstraints = this.getConstraints(i);
            if (!(layoutConstraints instanceof SplitConstraints)) continue;
            int n4 = this.convertPosition(layoutConstraints);
            if (n4 == 0) {
                ++n;
                continue;
            }
            if (n4 != 1) continue;
            ++n2;
        }
        if (n == 0 || n < n2) {
            return bl ? "left" : "top";
        }
        return bl ? "right" : "bottom";
    }

    private static Method getSetLeftComponentMethod() {
        if (setLeftComponentMethod == null) {
            setLeftComponentMethod = JSplitPaneSupport.getAddMethod("setLeftComponent");
        }
        return setLeftComponentMethod;
    }

    private static Method getSetRightComponentMethod() {
        if (setRightComponentMethod == null) {
            setRightComponentMethod = JSplitPaneSupport.getAddMethod("setRightComponent");
        }
        return setRightComponentMethod;
    }

    private static Method getSetTopComponentMethod() {
        if (setTopComponentMethod == null) {
            setTopComponentMethod = JSplitPaneSupport.getAddMethod("setTopComponent");
        }
        return setTopComponentMethod;
    }

    private static Method getSetBottomComponentMethod() {
        if (setBottomComponentMethod == null) {
            setBottomComponentMethod = JSplitPaneSupport.getAddMethod("setBottomComponent");
        }
        return setBottomComponentMethod;
    }

    private static Method getAddMethod(String string) {
        try {
            return JSplitPane.class.getMethod(string, Component.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            return null;
        }
    }

    static class SplitPositionEditor
    extends PropertyEditorSupport {
        private final String[] values = new String[]{"left", "right", "top", "bottom"};

        SplitPositionEditor() {
        }

        public String[] getTags() {
            return this.values;
        }

        public String getAsText() {
            return (String)this.getValue();
        }

        public void setAsText(String string) {
            for (int i = 0; i < this.values.length; ++i) {
                if (!string.equals(this.values[i])) continue;
                this.setValue(string);
                break;
            }
        }
    }

    public static class SplitConstraints
    implements LayoutConstraints {
        private String position;
        private Node.Property[] properties;
        private CodeExpression containerExpression;
        private CodeExpression componentExpression;
        private CodeGroup componentCode;

        public SplitConstraints(String string) {
            this.position = string;
        }

        public Node.Property[] getProperties() {
            if (this.properties == null) {
                this.properties = new Node.Property[]{new FormProperty("SplitConstraints splitPosition", String.class, JSplitPaneSupport.getBundle().getString("PROP_splitPos"), JSplitPaneSupport.getBundle().getString("HINT_splitPos")){

                    public Object getTargetValue() {
                        return SplitConstraints.this.position;
                    }

                    public void setTargetValue(Object object) {
                        SplitConstraints.this.position = (String)object;
                    }

                    public PropertyEditor getExpliciteEditor() {
                        return new SplitPositionEditor();
                    }

                    protected void propertyValueChanged(Object object, Object object2) {
                        if (this.isChangeFiring()) {
                            SplitConstraints.this.updateCode();
                        }
                        super.propertyValueChanged(object, object2);
                    }

                    public void setPropertyContext(FormPropertyContext formPropertyContext) {
                    }
                }};
                this.properties[0].setValue("NOI18N", (Object)Boolean.TRUE);
            }
            return this.properties;
        }

        public Object getConstraintsObject() {
            return this.position;
        }

        public LayoutConstraints cloneConstraints() {
            return new SplitConstraints(this.position);
        }

        private void createComponentCode(CodeGroup codeGroup, CodeExpression codeExpression, CodeExpression codeExpression2) {
            this.componentCode = codeGroup;
            this.containerExpression = codeExpression;
            this.componentExpression = codeExpression2;
            this.updateCode();
        }

        private void updateCode() {
            Method method;
            if (this.componentCode == null) {
                return;
            }
            CodeStructure.removeStatements(this.componentCode.getStatementsIterator());
            this.componentCode.removeAll();
            if ("left".equals(this.position)) {
                method = JSplitPaneSupport.getSetLeftComponentMethod();
            } else if ("right".equals(this.position)) {
                method = JSplitPaneSupport.getSetRightComponentMethod();
            } else if ("top".equals(this.position)) {
                method = JSplitPaneSupport.getSetTopComponentMethod();
            } else if ("bottom".equals(this.position)) {
                method = JSplitPaneSupport.getSetBottomComponentMethod();
            } else {
                return;
            }
            this.componentCode.addStatement(CodeStructure.createStatement(this.containerExpression, method, new CodeExpression[]{this.componentExpression}));
        }
    }
}

