/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.examples;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.TransferHandler;
import net.sourceforge.iharder.Base64;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.MozillaPanel;
import org.mozilla.browser.XPCOMUtils;
import org.mozilla.dom.NodeFactory;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMEventListener;
import org.mozilla.interfaces.nsIDOMEventTarget;
import org.mozilla.interfaces.nsIDOMWindow2;
import org.mozilla.interfaces.nsIDragService;
import org.mozilla.interfaces.nsIDragSession;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsISupportsString;
import org.mozilla.interfaces.nsITransferable;
import org.mozilla.interfaces.nsIWebBrowser;
import org.mozilla.xpcom.Mozilla;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Example11_DnD {
    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(500, 800);
        JSplitPane sp = new JSplitPane(0);
        JColorChooser b = new JColorChooser();
        b.setColor(Color.RED);
        b.setDragEnabled(true);
        b.setTransferHandler(new Base64TransferHandler());
        b.setMinimumSize(new Dimension(500, 100));
        sp.add(b);
        final MozillaPanel moz = new MozillaPanel();
        moz.load("about:");
        moz.setMinimumSize(new Dimension(500, 350));
        moz.setPreferredSize(new Dimension(500, 650));
        sp.add(moz);
        sp.setDividerLocation(0.7);
        frame.getContentPane().add((Component)sp, "Center");
        frame.setVisible(true);
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                nsIWebBrowser brow = moz.getChromeAdapter().getWebBrowser();
                nsIDOMWindow2 win = XPCOMUtils.qi(brow.getContentDOMWindow(), nsIDOMWindow2.class);
                nsIDOMEventTarget et = win.getWindowRoot();
                MozDnDListener dndl = new MozDnDListener();
                et.addEventListener("dragdrop", dndl, true);
            }
        });
    }

    public static void onDrop(Node source, Node target, Object data) {
        if (data instanceof Color) {
            Color c = (Color)data;
            Document doc = target.getOwnerDocument();
            Element e1 = doc.createElement("table");
            Element e2 = doc.createElement("tr");
            Element e3 = doc.createElement("td");
            Text t = doc.createTextNode("dnd example");
            int i = c.getRed() * 256 * 256 + c.getGreen() * 256 + c.getBlue();
            String s = Integer.toHexString(i);
            e3.setAttribute("bgcolor", "#" + s);
            e3.appendChild(t);
            e2.appendChild(e3);
            e1.appendChild(e2);
            target.getParentNode().appendChild(e1);
        }
    }

    public static class Base64Transferable
    implements Transferable {
        private final Transferable t;

        public Base64Transferable(Transferable t) {
            this.t = t;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor != null && flavor.equals(DataFlavor.stringFlavor) && !this.t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                DataFlavor[] dfs = this.t.getTransferDataFlavors();
                Object d = this.t.getTransferData(dfs[0]);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream os = new ObjectOutputStream(bos);
                os.writeObject(d);
                os.close();
                bos.close();
                return Base64.encodeBytes(bos.toByteArray());
            }
            return this.t.getTransferData(flavor);
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            if (flavor == null) {
                return false;
            }
            if (flavor.equals(DataFlavor.stringFlavor)) {
                return true;
            }
            return this.t.isDataFlavorSupported(flavor);
        }

        public DataFlavor[] getTransferDataFlavors() {
            if (this.t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return this.t.getTransferDataFlavors();
            }
            DataFlavor[] fs = this.t.getTransferDataFlavors();
            DataFlavor[] allfs = new DataFlavor[fs.length + 1];
            allfs[0] = DataFlavor.stringFlavor;
            System.arraycopy(fs, 0, allfs, 1, fs.length);
            return allfs;
        }
    }

    public static class Base64TransferHandler
    extends TransferHandler {
        public Base64TransferHandler() {
            super("color");
        }

        public Transferable createTransferable(JComponent comp) {
            Transferable t = super.createTransferable(comp);
            return new Base64Transferable(t);
        }
    }

    private static class MozDnDListener
    implements nsIDOMEventListener {
        private MozDnDListener() {
        }

        public void handleEvent(nsIDOMEvent ev) {
            System.err.println("dom event " + ev.getType());
            nsIDragService ds = XPCOMUtils.getService("@mozilla.org/widget/dragservice;1", nsIDragService.class);
            nsIDragSession dragSession = ds.getCurrentSession();
            String f = "text/unicode";
            if (dragSession.isDataFlavorSupported(f)) {
                Object o;
                nsITransferable t = XPCOMUtils.create("@mozilla.org/widget/transferable;1", nsITransferable.class);
                t.addDataFlavor(f);
                dragSession.getData(t, 0L);
                nsISupports[] aData = new nsISupports[]{null};
                long[] aDataLen = new long[]{0L};
                t.getTransferData(f, aData, aDataLen);
                nsISupportsString ss = XPCOMUtils.qi(aData[0], nsISupportsString.class);
                String s = ss.getData();
                try {
                    o = Base64.decodeToObject(s);
                }
                catch (Exception e) {
                    o = s;
                }
                final Object data = o;
                final Node target = NodeFactory.getNodeInstance(ev.getTarget());
                final Node source = NodeFactory.getNodeInstance(dragSession.getSourceNode());
                MozillaExecutor.swingAsyncExec(new Runnable(){

                    public void run() {
                        Example11_DnD.onDrop(source, target, data);
                    }
                });
                ev.stopPropagation();
            }
        }

        public nsISupports queryInterface(String uuid) {
            return Mozilla.queryInterface(this, uuid);
        }
    }
}

