/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import org.limewire.util.VersionFormatException;

public class Version
implements Comparable<Version> {
    private final String v;
    private final int major;
    private final int minor;
    private final int service;
    private final int revision;

    public Version(String s) throws VersionFormatException {
        this.v = s;
        int[] nums = this.parse(s);
        this.major = nums[0];
        this.minor = nums[1];
        this.service = nums[2];
        this.revision = nums[3];
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getService() {
        return this.service;
    }

    public int getRevision() {
        return this.revision;
    }

    public String getVersion() {
        return this.v;
    }

    public String toString() {
        return this.getVersion();
    }

    @Override
    public int compareTo(Version other) {
        int retVal = this.major == other.major ? (this.minor == other.minor ? (this.service == other.service ? this.revision - other.revision : this.service - other.service) : this.minor - other.minor) : this.major - other.major;
        return retVal;
    }

    public boolean equals(Object o) {
        return this.compareTo((Version)o) == 0;
    }

    private int[] parse(String vers) throws VersionFormatException {
        int major;
        int dot2;
        int dot1 = vers.indexOf(".");
        if (dot1 != -1) {
            dot2 = vers.indexOf(".", dot1 + 1);
            if (dot2 == -1) {
                dot2 = vers.length();
            }
        } else {
            dot1 = vers.length();
            dot2 = -1;
        }
        try {
            major = Integer.parseInt(vers.substring(0, dot1));
        }
        catch (NumberFormatException nfe) {
            throw new VersionFormatException(vers);
        }
        int minor = 0;
        int service = 0;
        int revision = 0;
        if (dot2 != -1) {
            int q;
            try {
                minor = Integer.parseInt(vers.substring(dot1 + 1, dot2));
            }
            catch (NumberFormatException nfe) {
                throw new VersionFormatException(vers);
            }
            try {
                for (q = dot2 + 1; q < vers.length() && Character.isDigit(vers.charAt(q)); ++q) {
                }
                int lastNum = q;
                if (q <= vers.length()) {
                    service = Integer.parseInt(vers.substring(dot2 + 1, q));
                }
            }
            catch (NumberFormatException nfe) {
                throw new VersionFormatException(vers);
            }
            try {
                int p;
                for (q = lastNum + 1; q < vers.length() && !Character.isDigit(vers.charAt(q)); ++q) {
                }
                for (p = q; p < vers.length() && Character.isDigit(vers.charAt(p)); ++p) {
                }
                if (q < vers.length() && p <= vers.length()) {
                    revision = Integer.parseInt(vers.substring(q, p));
                }
            }
            catch (NumberFormatException okay) {
                // empty catch block
            }
        }
        return new int[]{major, minor, service, revision};
    }
}

