/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.resultpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.limewire.ui.swing.components.FocusJOptionPane;
import org.limewire.ui.swing.components.MultiLineLabel;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.ui.swing.search.resultpanel.DownloadPreprocessor;
import org.limewire.ui.swing.settings.QuestionsHandler;
import org.limewire.ui.swing.util.I18n;

public class LicenseWarningDownloadPreprocessor
implements DownloadPreprocessor {
    public static final int SKIP_WARNING_VALUE = 101;
    public static final int SHOW_WARNING_VALUE = 0;

    @Override
    public boolean execute(VisualSearchResult vsr) {
        return this.hasConfirmedLicenseWarningIfNecessary(vsr);
    }

    private boolean hasConfirmedLicenseWarningIfNecessary(VisualSearchResult vsr) {
        boolean initialLicenseWarning;
        boolean bl = initialLicenseWarning = QuestionsHandler.SKIP_FIRST_DOWNLOAD_WARNING.getValue() != 101;
        if (!vsr.isLicensed() && initialLicenseWarning) {
            String licenseWarning = I18n.tr("LimeWire is unable to find a license for this file. Download it anyway?\n\nLimeWire cannot monitor or control the content of the P2P Network, so please respect your local copyright laws.");
            JPanel thePanel = new JPanel(new BorderLayout(0, 15));
            thePanel.setOpaque(false);
            JCheckBox option = new JCheckBox(I18n.tr("Do not warn me again"));
            option.setOpaque(false);
            MultiLineLabel lbl = new MultiLineLabel(licenseWarning, 400);
            thePanel.add((Component)lbl, "North");
            thePanel.add((Component)option, "West");
            option.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    int skipWarningValue = e.getStateChange() == 1 ? 101 : 0;
                    QuestionsHandler.SKIP_FIRST_DOWNLOAD_WARNING.setValue(skipWarningValue);
                }
            });
            if (FocusJOptionPane.showConfirmDialog(null, thePanel, I18n.tr("Warning"), 0) != 0) {
                if (QuestionsHandler.SKIP_FIRST_DOWNLOAD_WARNING.getValue() == 101) {
                    QuestionsHandler.SKIP_FIRST_DOWNLOAD_WARNING.setValue(0);
                }
                return false;
            }
        }
        return true;
    }
}

