/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.limewire.core.api.connection.ConnectionStrength;
import org.limewire.core.api.connection.GnutellaConnectionManager;
import org.limewire.core.api.lifecycle.LifeCycleEvent;
import org.limewire.core.api.lifecycle.LifeCycleManager;
import org.limewire.core.api.search.Search;
import org.limewire.core.api.search.SearchFactory;
import org.limewire.core.api.search.SearchListener;
import org.limewire.core.api.search.SearchResult;
import org.limewire.core.api.search.sponsored.SponsoredResult;
import org.limewire.listener.EventListener;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.ui.swing.nav.NavItem;
import org.limewire.ui.swing.nav.NavItemListener;
import org.limewire.ui.swing.search.SearchHandler;
import org.limewire.ui.swing.search.SearchInfo;
import org.limewire.ui.swing.search.SearchNavItem;
import org.limewire.ui.swing.search.SearchNavigator;
import org.limewire.ui.swing.search.SearchResultsPanel;
import org.limewire.ui.swing.search.SearchResultsPanelFactory;
import org.limewire.ui.swing.search.SwingSearchListener;
import org.limewire.ui.swing.search.model.SearchResultsModel;
import org.limewire.ui.swing.search.model.SearchResultsModelFactory;
import org.limewire.ui.swing.util.SwingUtils;

@Singleton
class TextSearchHandlerImpl
implements SearchHandler {
    private final SearchFactory searchFactory;
    private final Provider<SearchResultsPanelFactory> searchResultPanelFactory;
    private final SearchNavigator searchNavigator;
    private final Provider<SearchResultsModelFactory> searchResultsModelFactory;
    private final LifeCycleManager lifeCycleManager;
    private final GnutellaConnectionManager connectionManager;
    private SearchResultsModelFactory modelFactory;
    private SearchResultsPanelFactory panelFactory;

    @Inject
    TextSearchHandlerImpl(SearchFactory searchFactory, Provider<SearchResultsPanelFactory> searchResultPanelFactory, SearchNavigator searchNavigator, Provider<SearchResultsModelFactory> searchResultsModelFactory, LifeCycleManager lifeCycleManager, GnutellaConnectionManager connectionManager) {
        this.searchNavigator = searchNavigator;
        this.searchFactory = searchFactory;
        this.searchResultPanelFactory = searchResultPanelFactory;
        this.searchResultsModelFactory = searchResultsModelFactory;
        this.lifeCycleManager = lifeCycleManager;
        this.connectionManager = connectionManager;
    }

    @Override
    public boolean doSearch(SearchInfo info) {
        Search search = this.searchFactory.createSearch(info);
        String panelTitle = info.getTitle();
        if (this.modelFactory == null) {
            this.modelFactory = this.searchResultsModelFactory.get();
        }
        if (this.panelFactory == null) {
            this.panelFactory = this.searchResultPanelFactory.get();
        }
        SearchResultsModel searchModel = this.modelFactory.createSearchResultsModel(info, search);
        SearchResultsPanel searchPanel = this.panelFactory.createSearchResultsPanel(searchModel);
        SearchNavItem item = this.searchNavigator.addSearch(panelTitle, (JComponent)searchPanel, search, searchModel);
        item.select();
        this.addConnectionWarnings(search, searchPanel, item);
        this.startSearch(searchModel, searchPanel, item);
        return true;
    }

    private void startSearch(final SearchResultsModel searchModel, final SearchResultsPanel searchPanel, final SearchNavItem navItem) {
        if (this.lifeCycleManager.isStarted()) {
            searchModel.start(new SwingSearchListener(searchModel, searchPanel, navItem));
        } else {
            searchPanel.setLifeCycleComplete(false);
            final EventListener<LifeCycleEvent> listener = new EventListener<LifeCycleEvent>(){

                @Override
                @SwingEDTEvent
                public void handleEvent(LifeCycleEvent event) {
                    if (event == LifeCycleEvent.STARTED) {
                        searchPanel.setLifeCycleComplete(true);
                        searchModel.start(new SwingSearchListener(searchModel, searchPanel, navItem));
                        TextSearchHandlerImpl.this.lifeCycleManager.removeListener(this);
                    }
                }
            };
            this.lifeCycleManager.addListener(listener);
            navItem.addNavItemListener(new NavItemListener(){

                @Override
                public void itemRemoved(boolean wasSelected) {
                    TextSearchHandlerImpl.this.lifeCycleManager.removeListener(listener);
                }

                @Override
                public void itemSelected(boolean selected) {
                }
            });
        }
    }

    private boolean setConnectionStrength(ConnectionStrength type, SearchResultsPanel searchPanel) {
        switch (type) {
            case TURBO: 
            case FULL: {
                searchPanel.setFullyConnected(true);
                return true;
            }
        }
        return false;
    }

    private void removeListeners(Search search, AtomicReference<SearchListener> searchListenerRef, AtomicReference<PropertyChangeListener> connectionListenerRef) {
        PropertyChangeListener connectionListener;
        SearchListener searchListener = searchListenerRef.get();
        if (searchListener != null) {
            search.removeSearchListener(searchListener);
            searchListenerRef.set(null);
        }
        if ((connectionListener = connectionListenerRef.get()) != null) {
            this.connectionManager.removePropertyChangeListener(connectionListener);
            connectionListenerRef.set(null);
        }
    }

    private void addConnectionWarnings(final Search search, final SearchResultsPanel searchPanel, NavItem navItem) {
        final AtomicReference<SearchListener> searchListenerRef = new AtomicReference<SearchListener>();
        final AtomicReference<PropertyChangeListener> connectionListenerRef = new AtomicReference<PropertyChangeListener>();
        connectionListenerRef.set(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("strength") && TextSearchHandlerImpl.this.setConnectionStrength((ConnectionStrength)((Object)evt.getNewValue()), searchPanel)) {
                    TextSearchHandlerImpl.this.removeListeners(search, searchListenerRef, connectionListenerRef);
                }
            }
        });
        searchListenerRef.set(new SearchListener(){
            private final AtomicInteger numberOfResults = new AtomicInteger(0);

            @Override
            public void handleSearchResult(Search search, SearchResult searchResult) {
                if (this.numberOfResults.addAndGet(1) > 10) {
                    SwingUtils.invokeNowOrLater(new Runnable(){

                        @Override
                        public void run() {
                            searchPanel.setFullyConnected(true);
                        }
                    });
                    TextSearchHandlerImpl.this.removeListeners(search, searchListenerRef, connectionListenerRef);
                }
            }

            @Override
            public void handleSearchResults(Search search, Collection<? extends SearchResult> searchResults) {
                if (this.numberOfResults.addAndGet(searchResults.size()) > 10) {
                    SwingUtils.invokeNowOrLater(new Runnable(){

                        @Override
                        public void run() {
                            searchPanel.setFullyConnected(true);
                        }
                    });
                    TextSearchHandlerImpl.this.removeListeners(search, searchListenerRef, connectionListenerRef);
                }
            }

            @Override
            public void handleSponsoredResults(Search search, List<SponsoredResult> sponsoredResults) {
            }

            @Override
            public void searchStarted(Search search) {
            }

            @Override
            public void searchStopped(Search search) {
            }
        });
        searchPanel.setFullyConnected(false);
        this.connectionManager.addPropertyChangeListener((PropertyChangeListener)connectionListenerRef.get());
        if (this.setConnectionStrength(this.connectionManager.getConnectionStrength(), searchPanel)) {
            this.removeListeners(search, searchListenerRef, connectionListenerRef);
        } else {
            search.addSearchListener((SearchListener)searchListenerRef.get());
            navItem.addNavItemListener(new NavItemListener(){

                @Override
                public void itemRemoved(boolean wasSelected) {
                    TextSearchHandlerImpl.this.removeListeners(search, searchListenerRef, connectionListenerRef);
                }

                @Override
                public void itemSelected(boolean selected) {
                }
            });
        }
    }
}

