/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.RectanglePainter;
import org.limewire.bittorrent.Torrent;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadPiecesInfo;
import org.limewire.core.api.download.DownloadPropertyKey;
import org.limewire.core.api.download.DownloadState;
import org.limewire.core.api.library.PropertiableFile;
import org.limewire.ui.swing.properties.FileInfoDialog;
import org.limewire.ui.swing.properties.FileInfoPanel;
import org.limewire.ui.swing.properties.PiecesGrid;
import org.limewire.ui.swing.util.FontUtils;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.PainterUtils;
import org.limewire.ui.swing.util.ResizeUtils;

public class FileInfoPiecesPanel
implements FileInfoPanel {
    private static final int NUM_COLUMNS = 10;
    private static final int MAX_NUM_ROWS = 10;
    private static final int MAX_CELL_HEIGHT = 16;
    private static final int MAX_CELL_WIDTH = 80;
    private static final PieceIntensity ACTIVE_INTENSITY = new PieceIntensity(DownloadPiecesInfo.PieceState.ACTIVE);
    private static final PieceIntensity UNAVAILABLE_INTENSITY = new PieceIntensity(DownloadPiecesInfo.PieceState.UNAVAILABLE);
    private final NumberFormat formatter = new DecimalFormat("0.00");
    private static final int REFRESH_DELAY = 200;
    @Resource
    private Color foreground;
    @Resource
    private Font smallFont;
    @Resource
    private Color legendBackground = PainterUtils.TRASPARENT;
    @Resource
    private Color downloadedForeground;
    @Resource
    private Color availableForeground;
    @Resource
    private Color activeForeground;
    @Resource
    private Color unavailableForeground;
    private final Color partialForegroundInitial;
    private final Color partialForegroundFinal;
    private final DownloadItem download;
    private Torrent torrent = null;
    private final JPanel component;
    private PiecesGrid grid;
    private Timer refresher;
    private DownloadPiecesInfo piecesInfo;
    private int numPieces = -1;
    private int coalesceFactor;
    private boolean finishedSuccessfully = false;
    private int cachedColumns;
    private int cachedRows;
    private final JLabel statusLabel;
    private JLabel numPiecesLabel;
    private JLabel piecesPerCellLabel;
    private JLabel piecesSizeLabel;
    private JLabel ratioLabel;
    private JLabel uploadedLabel;
    private JLabel downloadedLabel;
    private JLabel piecesCompletedLabel;
    private JLabel failedDownloadLabel;

    public FileInfoPiecesPanel(FileInfoDialog.FileInfoType type, final DownloadItem download) {
        this.download = download;
        GuiUtils.assignResources(this);
        this.partialForegroundInitial = FileInfoPiecesPanel.createShade(this.availableForeground, this.downloadedForeground, 0.1);
        this.partialForegroundFinal = FileInfoPiecesPanel.createShade(this.downloadedForeground, this.availableForeground, 0.1);
        this.component = new JPanel(new MigLayout("insets 6 0 0 0"));
        this.component.setOpaque(false);
        this.numPiecesLabel = this.createLabel("?");
        this.piecesPerCellLabel = this.createLabel("?");
        this.piecesCompletedLabel = this.createLabel("?");
        this.piecesSizeLabel = this.createLabel("?");
        this.downloadedLabel = this.createLabel("?");
        this.failedDownloadLabel = this.createLabel("?");
        this.grid = new PiecesGrid();
        this.statusLabel = new JLabel(I18n.tr("Preparing View..."));
        this.grid.setLayout(new GridBagLayout());
        this.grid.add(this.statusLabel);
        ResizeUtils.forceSize(this.grid, new Dimension(800, 160));
        final JPanel infoPanel = new JPanel(new MigLayout("insets 0, gap 0, fill"));
        infoPanel.setOpaque(false);
        JPanel legendPanel = new JPanel(new MigLayout("insets 8, gap 3"));
        legendPanel.setBackground(this.legendBackground);
        legendPanel.add(FileInfoPiecesPanel.createLegendBox(this.activeForeground));
        legendPanel.add((Component)this.createLabel(I18n.tr("Active")), "gapright 5");
        legendPanel.add(FileInfoPiecesPanel.createLegendBox(this.availableForeground));
        legendPanel.add((Component)this.createLabel(I18n.tr("Available")), "wrap");
        legendPanel.add(FileInfoPiecesPanel.createLegendBox(this.downloadedForeground));
        legendPanel.add((Component)this.createLabel(I18n.tr("Done")), "gapright 5");
        legendPanel.add(FileInfoPiecesPanel.createLegendBox(this.unavailableForeground));
        legendPanel.add((Component)this.createLabel(I18n.tr("Unavailable")), "wrap");
        legendPanel.add(FileInfoPiecesPanel.createLegendBox(new GradientPaint(0.0f, 0.0f, this.partialForegroundInitial, 0.0f, 1.0f, this.partialForegroundFinal)));
        legendPanel.add((Component)this.createLabel(I18n.tr("Partially Done")), "wrap");
        JPanel bottomLegend = new JPanel(new MigLayout("insets 0, gap 6, fillx"));
        bottomLegend.setOpaque(false);
        bottomLegend.add(this.createLabel(I18n.tr("Pieces per Cell:")));
        bottomLegend.add(this.piecesPerCellLabel);
        legendPanel.add((Component)bottomLegend, "gaptop 5, span, alignx 50%");
        JPanel rightPanel = new JPanel(new MigLayout("fillx, gap 0, insets 0"));
        rightPanel.setOpaque(false);
        rightPanel.add(legendPanel);
        infoPanel.add((Component)rightPanel, "dock east");
        infoPanel.add((Component)this.createBoldLabel(I18n.tr("Number of Pieces:")), "split 2");
        infoPanel.add((Component)this.numPiecesLabel, "wrap");
        infoPanel.add((Component)this.createBoldLabel(I18n.tr("Pieces Completed:")), "split 2");
        infoPanel.add((Component)this.piecesCompletedLabel, "wrap");
        infoPanel.add((Component)this.createBoldLabel(I18n.tr("Piece Size:")), "split 2");
        infoPanel.add((Component)this.piecesSizeLabel, "wrap");
        infoPanel.add((Component)this.createBoldLabel(I18n.tr("Downloaded:")), "split 2");
        infoPanel.add((Component)this.downloadedLabel, "wrap");
        infoPanel.add((Component)this.createBoldLabel(I18n.tr("Failed Download:")), "split 2");
        infoPanel.add((Component)this.failedDownloadLabel, "wrap");
        if (download.getDownloadItemType() == DownloadItem.DownloadItemType.BITTORRENT) {
            this.torrent = (Torrent)download.getDownloadProperty(DownloadPropertyKey.TORRENT);
            this.uploadedLabel = this.createLabel("");
            this.ratioLabel = this.createLabel("");
            infoPanel.add((Component)this.createBoldLabel(I18n.tr("Uploaded:")), "split 2");
            infoPanel.add((Component)this.uploadedLabel, "wrap");
            infoPanel.add((Component)this.createBoldLabel(I18n.tr("Ratio:")), "split 2");
            infoPanel.add((Component)this.ratioLabel, "wrap");
        }
        this.component.add((Component)this.grid, "wrap");
        this.component.add((Component)infoPanel, "growx");
        this.refresher = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int margin;
                if (this.isFinished()) {
                    FileInfoPiecesPanel.this.refresher.stop();
                    if (download.getState() == DownloadState.CANCELLED) {
                        FileInfoPiecesPanel.this.grid.setAlpha(0.5f);
                        FileInfoPiecesPanel.this.statusLabel.setText(I18n.tr("Download Cancelled!"));
                        FileInfoPiecesPanel.this.statusLabel.setVisible(true);
                        FileInfoPiecesPanel.this.grid.repaint();
                    } else {
                        FileInfoPiecesPanel.this.finishedSuccessfully = true;
                        if (FileInfoPiecesPanel.this.numPieces > 0) {
                            for (int i = 0; i < FileInfoPiecesPanel.this.grid.getCellCount(); ++i) {
                                FileInfoPiecesPanel.this.grid.setCellFillPaint(i, FileInfoPiecesPanel.this.downloadedForeground);
                            }
                        } else {
                            FileInfoPiecesPanel.this.statusLabel.setText(I18n.tr("Download Already Finished!"));
                        }
                    }
                } else if (FileInfoPiecesPanel.this.calculatePieceData() > 0) {
                    FileInfoPiecesPanel.this.updateTable();
                }
                FileInfoPiecesPanel.this.grid.repaint();
                if (FileInfoPiecesPanel.this.grid.isMarginUpdated() && (margin = FileInfoPiecesPanel.this.grid.getInnerMargin()) != 0) {
                    infoPanel.setBorder(BorderFactory.createEmptyBorder(0, margin, 0, margin));
                }
                FileInfoPiecesPanel.this.updateDownloadDetails();
            }

            private boolean isFinished() {
                DownloadState state = download.getState();
                return state == DownloadState.DONE || state == DownloadState.FINISHING || state == DownloadState.CANCELLED || state == DownloadState.DANGEROUS || state == DownloadState.SCAN_FAILED_DOWNLOADING_DEFINITIONS || state == DownloadState.SCAN_FAILED || state == DownloadState.THREAT_FOUND;
            }
        });
        this.refresher.setInitialDelay(0);
        this.refresher.start();
    }

    private int calculatePieceData() {
        this.piecesInfo = this.download.getPiecesInfo();
        if (this.piecesInfo == null) {
            return -1;
        }
        int newNum = this.piecesInfo.getNumPieces();
        if (newNum != this.numPieces && newNum != 0) {
            this.statusLabel.setVisible(false);
            this.numPieces = newNum;
            this.setupGrid();
        }
        return newNum;
    }

    private void setupGrid() {
        int requiredRows;
        int numRows = requiredRows = (int)Math.ceil((double)this.numPieces / 10.0);
        this.coalesceFactor = 1;
        if (requiredRows > 10) {
            this.coalesceFactor = (int)Math.ceil((double)this.numPieces / 100.0);
            numRows = (int)Math.ceil((double)this.numPieces / (double)(this.coalesceFactor * 10));
            this.piecesPerCellLabel.setText("" + this.coalesceFactor);
        }
        this.grid.resizeGrid(numRows, 10);
        this.grid.setAlignmentX(0.5f);
        this.grid.setAlignmentY(0.5f);
        ResizeUtils.forceSize(this.grid, new Dimension(800, 16 * numRows));
    }

    private static Component createLegendBox(Paint foreground) {
        JXPanel panel = new JXPanel();
        RectanglePainter painter = new RectanglePainter();
        painter.setPaintStretched(true);
        painter.setFillPaint(foreground);
        painter.setBorderPaint(Color.BLACK);
        painter.setAntialiasing(true);
        painter.setCacheable(true);
        panel.setBackgroundPainter(painter);
        return panel;
    }

    private JLabel createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setOpaque(false);
        label.setForeground(this.foreground);
        label.setFont(this.smallFont);
        return label;
    }

    private JLabel createBoldLabel(String text) {
        JLabel label = this.createLabel(text);
        FontUtils.bold(label);
        return label;
    }

    private void updateDownloadDetails() {
        long currentSize = this.download.getCurrentSize();
        long verifiedSize = this.download.getAmountVerified();
        String downloadString = GuiUtils.formatUnitFromBytes(currentSize);
        if (currentSize - verifiedSize > 1000L) {
            downloadString = downloadString + " " + I18n.tr("({0} verified)", GuiUtils.formatUnitFromBytes(verifiedSize));
        }
        this.downloadedLabel.setText(downloadString);
        if (this.numPieces > 0) {
            this.numPiecesLabel.setText("" + this.numPieces);
        }
        if (this.piecesInfo != null) {
            int completed = this.piecesInfo.getNumPiecesCompleted();
            String completedText = this.finishedSuccessfully ? "" + this.numPieces : (completed < 0 ? "?" : "" + completed);
            this.piecesCompletedLabel.setText(completedText);
            this.piecesSizeLabel.setText(GuiUtils.formatUnitFromBytes(this.piecesInfo.getPieceSize()));
        }
        this.failedDownloadLabel.setText(GuiUtils.formatUnitFromBytes(this.download.getAmountLost()));
        if (this.torrent != null) {
            this.uploadedLabel.setText(GuiUtils.formatUnitFromBytes(this.torrent.getTotalUploaded()));
            this.ratioLabel.setText(this.formatter.format(this.torrent.getSeedRatio()));
        }
    }

    private void updateTable() {
        if (this.cachedRows != this.grid.getRows() || this.cachedColumns != this.grid.getColumns()) {
            this.cachedRows = this.grid.getRows();
            this.cachedColumns = this.grid.getColumns();
            int cellsAvailable = this.grid.getCellCount();
            this.coalesceFactor = (int)Math.ceil((double)this.numPieces / (double)cellsAvailable);
            this.piecesPerCellLabel.setText("" + this.coalesceFactor);
        }
        int gridSlot = 0;
        for (int i = 0; i < this.numPieces; i += this.coalesceFactor) {
            Color pieceForeground = Color.BLACK;
            int numPiecesLeft = this.numPieces - this.coalesceFactor * gridSlot;
            int piecesToCoalesce = this.coalesceFactor;
            if (numPiecesLeft < this.coalesceFactor) {
                piecesToCoalesce = numPiecesLeft;
            }
            PieceIntensity cumulativePieceIntensity = FileInfoPiecesPanel.coalescePieceStates(this.piecesInfo, i, piecesToCoalesce);
            DownloadPiecesInfo.PieceState cumulativeState = cumulativePieceIntensity.getState();
            switch (cumulativeState) {
                case ACTIVE: {
                    pieceForeground = this.activeForeground;
                    break;
                }
                case PARTIAL: {
                    pieceForeground = FileInfoPiecesPanel.createShade(this.partialForegroundInitial, this.partialForegroundFinal, cumulativePieceIntensity.getIntensity());
                    break;
                }
                case AVAILABLE: {
                    pieceForeground = this.availableForeground;
                    break;
                }
                case DOWNLOADED: {
                    pieceForeground = this.downloadedForeground;
                    break;
                }
                case UNAVAILABLE: {
                    pieceForeground = this.unavailableForeground;
                    break;
                }
                default: {
                    throw new IllegalStateException(cumulativeState.toString());
                }
            }
            this.grid.setCellFillPaint(gridSlot++, pieceForeground);
        }
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    @Override
    public void save() {
    }

    @Override
    public void updatePropertiableFile(PropertiableFile file) {
    }

    @Override
    public void dispose() {
        this.refresher.stop();
    }

    private static PieceIntensity coalescePieceStates(DownloadPiecesInfo piecesInfo, int startIndex, int piecesToCoalesce) {
        int completedScore = 0;
        DownloadPiecesInfo.PieceState workingState = null;
        for (int i = startIndex; i < startIndex + piecesToCoalesce; ++i) {
            DownloadPiecesInfo.PieceState state = piecesInfo.getPieceState(i);
            if (state == DownloadPiecesInfo.PieceState.ACTIVE) {
                return ACTIVE_INTENSITY;
            }
            if (state == DownloadPiecesInfo.PieceState.UNAVAILABLE) {
                return UNAVAILABLE_INTENSITY;
            }
            switch (state) {
                case PARTIAL: {
                    ++completedScore;
                    break;
                }
                case DOWNLOADED: {
                    completedScore += 2;
                }
            }
            workingState = workingState != null && workingState != state ? DownloadPiecesInfo.PieceState.PARTIAL : state;
        }
        if (workingState == DownloadPiecesInfo.PieceState.PARTIAL) {
            int completedScoreMax = piecesToCoalesce * 2;
            return new PieceIntensity(workingState, (double)completedScore / (double)completedScoreMax);
        }
        return new PieceIntensity(workingState);
    }

    private static Color createShade(Color initialShade, Color finalShade, double intensity) {
        int redDelta = finalShade.getRed() - initialShade.getRed();
        int greenDelta = finalShade.getGreen() - initialShade.getGreen();
        int blueDelta = finalShade.getBlue() - initialShade.getBlue();
        redDelta = (int)((double)redDelta * intensity);
        greenDelta = (int)((double)greenDelta * intensity);
        blueDelta = (int)((double)blueDelta * intensity);
        return new Color(initialShade.getRed() + redDelta, initialShade.getGreen() + greenDelta, initialShade.getBlue() + blueDelta);
    }

    private static class PieceIntensity {
        private final DownloadPiecesInfo.PieceState state;
        private final double intensity;

        public PieceIntensity(DownloadPiecesInfo.PieceState state) {
            this.state = state;
            this.intensity = 1.0;
        }

        public PieceIntensity(DownloadPiecesInfo.PieceState state, double intensity) {
            this.state = state;
            this.intensity = intensity;
        }

        public DownloadPiecesInfo.PieceState getState() {
            return this.state;
        }

        public double getIntensity() {
            return this.intensity;
        }
    }
}

