/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.player;

import ca.odell.glazedlists.EventList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.limewire.core.api.Category;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectionHistogram;
import org.limewire.inspection.InspectionPoint;
import org.limewire.player.api.AudioPlayer;
import org.limewire.player.api.AudioPlayerEvent;
import org.limewire.player.api.AudioPlayerListener;
import org.limewire.player.api.AudioSource;
import org.limewire.player.api.PlayerState;
import org.limewire.ui.swing.library.LibraryMediator;
import org.limewire.ui.swing.library.LibraryPanel;
import org.limewire.ui.swing.library.navigator.LibraryNavItem;
import org.limewire.ui.swing.player.PlayerMediator;
import org.limewire.ui.swing.player.PlayerMediatorListener;
import org.limewire.ui.swing.player.PlayerUtils;
import org.limewire.ui.swing.settings.MediaPlayerSettings;
import org.limewire.ui.swing.util.I18n;
import org.limewire.util.FileUtils;

@Singleton
class AudioPlayerMediator
implements PlayerMediator {
    public static final String AUDIO_LENGTH_BYTES = "audio.length.bytes";
    public static final String AUDIO_TYPE = "audio.type";
    private static final String MP3 = "mp3";
    private static final String WAVE = "wave";
    private final Provider<AudioPlayer> audioPlayerProvider;
    private final LibraryMediator libraryMediator;
    private final List<PlayerMediatorListener> listenerList;
    private final List<LocalFileItem> playList;
    private final List<LocalFileItem> shuffleList;
    private AudioPlayer audioPlayer;
    private PlaylistId playlistId;
    private LocalFileItem fileItem = null;
    private Map audioProperties = null;
    private float progress;
    private boolean shuffle = false;
    @InspectionPoint(value="media-player")
    private final PlayerInspector inspectable;

    @Inject
    public AudioPlayerMediator(Provider<AudioPlayer> audioPlayerProvider, LibraryMediator libraryMediator) {
        this.audioPlayerProvider = audioPlayerProvider;
        this.libraryMediator = libraryMediator;
        this.listenerList = new ArrayList<PlayerMediatorListener>();
        this.playList = new ArrayList<LocalFileItem>();
        this.shuffleList = new ArrayList<LocalFileItem>();
        this.inspectable = new PlayerInspector();
    }

    private AudioPlayer getPlayer() {
        if (this.audioPlayer == null) {
            this.audioPlayer = this.audioPlayerProvider.get();
            this.audioPlayer.addAudioPlayerListener(new PlayerListener());
        }
        return this.audioPlayer;
    }

    @Override
    public void addMediatorListener(PlayerMediatorListener listener) {
        this.listenerList.add(listener);
    }

    @Override
    public void removeMediatorListener(PlayerMediatorListener listener) {
        this.listenerList.remove(listener);
    }

    private void fireProgressUpdated(float progress) {
        int size = this.listenerList.size();
        for (int i = 0; i < size; ++i) {
            this.listenerList.get(i).progressUpdated(progress);
        }
    }

    private void fireSongChanged(String name) {
        int size = this.listenerList.size();
        for (int i = 0; i < size; ++i) {
            this.listenerList.get(i).songChanged(name);
        }
    }

    private void fireStateChanged(PlayerState state) {
        int size = this.listenerList.size();
        for (int i = 0; i < size; ++i) {
            this.listenerList.get(i).stateChanged(state);
        }
    }

    @Override
    public PlayerState getStatus() {
        return this.getPlayer().getStatus();
    }

    @Override
    public boolean isActivePlaylist(LibraryNavItem navItem) {
        if (navItem != null) {
            PlaylistId newId = new PlaylistId(navItem);
            return newId.equals(this.playlistId);
        }
        return false;
    }

    @Override
    public void setActivePlaylist(LibraryNavItem navItem) {
        if (navItem != null) {
            PlaylistId oldPlaylist = this.playlistId;
            this.playlistId = new PlaylistId(navItem);
            if (!this.playlistId.equals(oldPlaylist)) {
                this.inspectable.newListStarted();
            }
        } else {
            this.playlistId = null;
            this.playList.clear();
        }
    }

    private List<LocalFileItem> getPlaylist() {
        LibraryNavItem selectedNavItem = this.libraryMediator.getSelectedNavItem();
        Category selectedCategory = this.libraryMediator.getSelectedCategory();
        if (selectedNavItem == null) {
            return this.playList;
        }
        PlaylistId selectedId = new PlaylistId(selectedNavItem);
        if (selectedId.equals(this.playlistId) && LibraryPanel.isPlayable(selectedCategory)) {
            List<LocalFileItem> libraryList = this.libraryMediator.getPlayableList();
            if (libraryList == null) {
                libraryList = Collections.emptyList();
            }
            return libraryList;
        }
        return this.playList;
    }

    @Override
    public void setPlaylist(EventList<LocalFileItem> fileList) {
        this.playList.clear();
        if (fileList == null) {
            return;
        }
        int size = fileList.size();
        for (int i = 0; i < size; ++i) {
            this.playList.add((LocalFileItem)fileList.get(i));
        }
    }

    @Override
    public boolean isShuffle() {
        return this.shuffle;
    }

    @Override
    public boolean hasScrollingTitle() {
        return true;
    }

    @Override
    public void setShuffle(boolean shuffle) {
        this.shuffle = shuffle;
        if (shuffle) {
            this.updateShuffleList();
        } else {
            this.shuffleList.clear();
        }
    }

    @Override
    public void setVolume(double value) {
        this.getPlayer().setVolume(value);
    }

    @Override
    public void pause() {
        this.getPlayer().pause();
    }

    @Override
    public void resume() {
        PlayerState status = this.getPlayer().getStatus();
        if (status == PlayerState.STOPPED || status == PlayerState.UNKNOWN) {
            LocalFileItem selectedItem;
            List<LocalFileItem> selectedItems = this.libraryMediator.getSelectedItems();
            if (selectedItems.size() > 0 && PlayerUtils.isPlayableAudioFile((selectedItem = selectedItems.get(0)).getFile())) {
                this.setActivePlaylist(this.libraryMediator.getSelectedNavItem());
                this.play(selectedItem);
            }
        } else {
            this.getPlayer().unpause();
        }
    }

    @Override
    public void play(File file) {
        this.stop();
        this.fileItem = null;
        this.loadAndPlay(file);
        this.setActivePlaylist(null);
        this.shuffleList.clear();
    }

    @Override
    public void play(LocalFileItem localFileItem) {
        this.stop();
        this.fileItem = localFileItem;
        this.loadAndPlay(localFileItem.getFile());
        if (this.shuffle) {
            this.updateShuffleList();
        }
    }

    private void loadAndPlay(File fileToPlay) {
        AudioPlayer player = this.getPlayer();
        player.loadSong(fileToPlay);
        player.playSong();
        this.inspectable.started(fileToPlay);
    }

    @Override
    public void skip(double percent) {
        String songType;
        if (this.audioProperties != null && this.audioProperties.containsKey(AUDIO_TYPE) && this.isSeekable(songType = (String)this.audioProperties.get(AUDIO_TYPE)) && this.audioProperties.containsKey(AUDIO_LENGTH_BYTES)) {
            long skipBytes = Math.round((double)((Integer)this.audioProperties.get(AUDIO_LENGTH_BYTES)).intValue() * percent);
            this.getPlayer().seekLocation(skipBytes);
        }
    }

    @Override
    public void stop() {
        this.getPlayer().stop();
    }

    @Override
    public void nextSong() {
        this.stop();
        this.fileItem = this.getNextFileItem();
        if (this.fileItem != null) {
            this.loadAndPlay(this.fileItem.getFile());
        }
    }

    @Override
    public void prevSong() {
        this.stop();
        if (this.progress < 0.1f) {
            this.fileItem = this.getPrevFileItem();
        }
        if (this.fileItem != null) {
            this.loadAndPlay(this.fileItem.getFile());
        }
    }

    @Override
    public File getCurrentMediaFile() {
        AudioSource source = this.getPlayer().getCurrentSong();
        return source != null ? source.getFile() : null;
    }

    @Override
    public boolean isPlaying(File file) {
        return this.getPlayer().isPlaying(file);
    }

    @Override
    public boolean isPaused(File file) {
        return this.getPlayer().isPaused(file);
    }

    @Override
    public boolean isSeekable() {
        if (this.audioProperties != null) {
            return this.isSeekable((String)this.audioProperties.get(AUDIO_TYPE));
        }
        return false;
    }

    @Override
    public boolean isPlaylistSupported() {
        return true;
    }

    @Override
    public boolean isVolumeSettable() {
        return true;
    }

    private boolean isSeekable(String songType) {
        if (songType == null) {
            return false;
        }
        return songType.equalsIgnoreCase(MP3) || songType.equalsIgnoreCase(WAVE);
    }

    private void updateShuffleList() {
        this.shuffleList.clear();
        List<LocalFileItem> playlist = this.getPlaylist();
        if (playlist.size() == 0) {
            return;
        }
        for (int i = 0; i < playlist.size(); ++i) {
            this.shuffleList.add(playlist.get(i));
        }
        Collections.shuffle(this.shuffleList);
        int index = this.shuffleList.indexOf(this.fileItem);
        if (index > 0) {
            this.shuffleList.remove(index);
            this.shuffleList.add(0, this.fileItem);
        }
    }

    private LocalFileItem getNextFileItem() {
        int index;
        List<LocalFileItem> fileList;
        List<LocalFileItem> list = fileList = this.shuffle ? this.shuffleList : this.getPlaylist();
        if (this.fileItem != null && fileList.size() > 0 && (index = fileList.indexOf(this.fileItem)) < fileList.size() - 1) {
            return fileList.get(index + 1);
        }
        return null;
    }

    private LocalFileItem getPrevFileItem() {
        int index;
        List<LocalFileItem> fileList;
        List<LocalFileItem> list = fileList = this.shuffle ? this.shuffleList : this.getPlaylist();
        if (this.fileItem != null && fileList.size() > 0 && (index = fileList.indexOf(this.fileItem)) > 0) {
            return fileList.get(index - 1);
        }
        return null;
    }

    private String getSongName() {
        if (this.audioProperties != null) {
            Object author = this.audioProperties.get("author");
            Object title = this.audioProperties.get("title");
            if (author != null && title != null) {
                return author + " - " + title;
            }
        }
        if (this.fileItem != null) {
            return this.fileItem.getFile().getName();
        }
        if (this.getCurrentMediaFile() != null) {
            return FileUtils.getFilenameNoExtension(this.getCurrentMediaFile().getName());
        }
        return I18n.tr("Unknown");
    }

    private class PlayerInspector
    implements Inspectable {
        private final Properties percentPlayedProp = MediaPlayerSettings.MEDIA_PLAYER_PERCENT_PLAYED.get();
        private final Properties filesPlayed = MediaPlayerSettings.MEDIA_PLAYER_NUM_PLAYS.get();
        private final Properties playListSizeProp = MediaPlayerSettings.MEDIA_PLAYER_LIST_SIZE.get();

        private PlayerInspector() {
        }

        void stopped() {
            this.incrementIntProperty(this.percentPlayedProp, Integer.toString(Math.round(AudioPlayerMediator.this.progress * 100.0f)));
            MediaPlayerSettings.MEDIA_PLAYER_PERCENT_PLAYED.set(this.percentPlayedProp);
        }

        void started(File filePlayed) {
            this.incrementIntProperty(this.filesPlayed, filePlayed.getName());
            MediaPlayerSettings.MEDIA_PLAYER_NUM_PLAYS.set(this.filesPlayed);
        }

        void newListStarted() {
            List fileList = AudioPlayerMediator.this.shuffle ? AudioPlayerMediator.this.shuffleList : AudioPlayerMediator.this.getPlaylist();
            this.incrementIntProperty(this.playListSizeProp, Integer.toString(fileList.size()));
            MediaPlayerSettings.MEDIA_PLAYER_LIST_SIZE.set(this.playListSizeProp);
        }

        private void incrementIntProperty(Properties properties, String key) {
            String value = properties.getProperty(key);
            Integer currentNum = value == null ? 0 : Integer.valueOf(value);
            properties.setProperty(key, Integer.toString(currentNum + 1));
        }

        @Override
        public Object inspect() {
            int repeats = 0;
            int numPlayStarts = 0;
            for (String fileName : this.filesPlayed.stringPropertyNames()) {
                int numOfPlaysForFile = Integer.parseInt(this.filesPlayed.getProperty(fileName));
                numPlayStarts += numOfPlaysForFile;
                if (numOfPlaysForFile <= 1) continue;
                repeats += numOfPlaysForFile - 1;
            }
            int numPlayStops = 0;
            InspectionHistogram<Integer> percentPlayed = new InspectionHistogram<Integer>();
            for (String percentPlayedStr : this.percentPlayedProp.stringPropertyNames()) {
                Integer percent = Integer.valueOf(percentPlayedStr);
                int numPlayedAtPercent = Integer.parseInt(this.percentPlayedProp.getProperty(percentPlayedStr));
                numPlayStops += numPlayedAtPercent;
                percentPlayed.count(percent, numPlayedAtPercent);
            }
            int numberOfTimesListPlayed = 0;
            InspectionHistogram<Integer> playListsize = new InspectionHistogram<Integer>();
            for (String numFilesInPlayListAsStr : this.playListSizeProp.stringPropertyNames()) {
                Integer numFilesInPlayList = Integer.valueOf(numFilesInPlayListAsStr);
                int numPlayListPlays = Integer.parseInt(this.playListSizeProp.getProperty(numFilesInPlayListAsStr));
                numberOfTimesListPlayed += numPlayListPlays;
                playListsize.count(numFilesInPlayList, numPlayListPlays);
            }
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("play_starts", numPlayStarts);
            ret.put("repeats", repeats);
            ret.put("play_stops", numPlayStops);
            ret.put("percent_played", percentPlayed.inspect());
            ret.put("total_list_plays", numberOfTimesListPlayed);
            ret.put("list_size", playListsize.inspect());
            return ret;
        }
    }

    private static class PlaylistId {
        private final LibraryNavItem.NavType type;
        private final int id;

        public PlaylistId(LibraryNavItem navItem) {
            this.type = navItem.getType();
            this.id = navItem.getId();
        }

        public boolean equals(Object obj) {
            if (obj instanceof PlaylistId) {
                return this.type == ((PlaylistId)obj).type && this.id == ((PlaylistId)obj).id;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.type.hashCode();
            result = 31 * result + this.id;
            return result;
        }
    }

    private class PlayerListener
    implements AudioPlayerListener {
        private PlayerListener() {
        }

        @Override
        public void progressChange(int bytesread) {
            if (AudioPlayerMediator.this.audioProperties != null && AudioPlayerMediator.this.audioProperties.containsKey(AudioPlayerMediator.AUDIO_LENGTH_BYTES)) {
                float byteslength = ((Integer)AudioPlayerMediator.this.audioProperties.get(AudioPlayerMediator.AUDIO_LENGTH_BYTES)).floatValue();
                AudioPlayerMediator.this.progress = (float)bytesread / byteslength;
                AudioPlayerMediator.this.fireProgressUpdated(AudioPlayerMediator.this.progress);
            }
        }

        @Override
        public void songOpened(Map<String, Object> properties) {
            AudioPlayerMediator.this.audioProperties = properties;
            AudioPlayerMediator.this.fireSongChanged(AudioPlayerMediator.this.getSongName());
        }

        @Override
        public void stateChange(AudioPlayerEvent event) {
            if (event.getState() == PlayerState.EOM) {
                AudioPlayerMediator.this.nextSong();
            } else if (event.getState() == PlayerState.STOPPED) {
                AudioPlayerMediator.this.inspectable.stopped();
            }
            AudioPlayerMediator.this.fireStateChanged(event.getState());
        }
    }
}

