/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.painter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.util.PaintUtils;
import org.limewire.ui.swing.util.PainterUtils;

public class ProgressBarForegroundPainter<X extends JComponent>
extends AbstractPainter<X> {
    private final boolean drawHandle;
    private Paint foreground;
    private Paint disabledForeground;
    private final Paint upperAccent;
    private int heightCache = 0;

    public ProgressBarForegroundPainter(Paint foreground, Paint disabledForeground) {
        this(foreground, disabledForeground, PainterUtils.TRASPARENT, false);
    }

    public ProgressBarForegroundPainter(Paint foreground, Paint disabledForeground, Paint upperAccent) {
        this(foreground, disabledForeground, upperAccent, false);
    }

    public ProgressBarForegroundPainter(Paint foreground, Paint disabledForeground, boolean drawHandle) {
        this(foreground, disabledForeground, PainterUtils.TRASPARENT, drawHandle);
    }

    public ProgressBarForegroundPainter(Paint foreground, Paint disabledForeground, Paint upperAccent, boolean drawHandle) {
        this.drawHandle = drawHandle;
        this.foreground = foreground;
        this.disabledForeground = disabledForeground;
        this.upperAccent = upperAccent;
        this.setAntialiasing(false);
        this.setCacheable(false);
    }

    @Override
    protected void doPaint(Graphics2D g, X object, int width, int height) {
        if (height != this.heightCache) {
            this.heightCache = height;
            this.foreground = PaintUtils.resizeGradient(this.foreground, 0, height - 2);
            this.disabledForeground = PaintUtils.resizeGradient(this.disabledForeground, 0, height - 2);
        }
        int progress = (int)((double)(width - 3) * ProgressBarForegroundPainter.getPercentComplete(object));
        if (((Component)object).isEnabled()) {
            g.setPaint(this.foreground);
            g.fillRect(1, 1, progress, height - 2);
            g.setPaint(this.upperAccent);
            g.drawLine(1, 1, progress, 1);
        } else {
            g.setPaint(this.disabledForeground);
            g.fillRect(1, 1, progress, height - 2);
        }
        if (this.drawHandle && ((Component)object).getMousePosition() != null) {
            if (progress == 0) {
                ++progress;
            }
            g.setPaint(Color.WHITE);
            g.fillRect(progress, 0, 2, height);
        }
    }

    private static double getPercentComplete(Object object) {
        if (object instanceof JProgressBar) {
            return ((JProgressBar)object).getPercentComplete();
        }
        if (object instanceof JSlider) {
            JSlider slider = (JSlider)object;
            return (double)(slider.getValue() - slider.getMinimum()) / (double)(slider.getMaximum() - slider.getMinimum());
        }
        throw new IllegalArgumentException("Progress bar painter does not support " + object.getClass().getName());
    }
}

