/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.menu;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import org.limewire.friend.api.FriendConnection;
import org.limewire.friend.api.FriendConnectionEvent;
import org.limewire.listener.EventBean;
import org.limewire.listener.EventUtils;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.action.MnemonicMenu;
import org.limewire.ui.swing.friends.chat.ChatMediator;
import org.limewire.ui.swing.friends.login.AutoLoginService;
import org.limewire.ui.swing.friends.login.LoginPopupPanel;
import org.limewire.ui.swing.mainframe.ChangeLanguageAction;
import org.limewire.ui.swing.menu.HideTransferTrayAction;
import org.limewire.ui.swing.menu.ShowDownloadsTrayAction;
import org.limewire.ui.swing.menu.ShowUploadsTrayAction;
import org.limewire.ui.swing.transfer.TransferTrayNavigator;
import org.limewire.ui.swing.util.I18n;

class ViewMenu
extends MnemonicMenu {
    private static final String visibleText = I18n.tr("Hide &Chat Window");
    private static final String notVisibleText = I18n.tr("Show &Chat Window");
    private final Provider<LoginPopupPanel> friendsSignInPanelProvider;
    private final Provider<AutoLoginService> autoLoginServiceProvider;
    private final EventBean<FriendConnectionEvent> friendConnectionEventBean;
    private final Provider<HideTransferTrayAction> hideTransferTrayTrayActionProvider;
    private final Provider<ShowDownloadsTrayAction> showDownloadsTrayActionProvider;
    private final Provider<ShowUploadsTrayAction> showUploadsTrayActionProvider;
    private final Provider<ChatMediator> chatFrameProvider;
    private final Provider<ChangeLanguageAction> changeLanguageActionProvider;
    private final Provider<TransferTrayNavigator> transferTrayNavigator;

    @Inject
    public ViewMenu(Provider<LoginPopupPanel> friendsSignInPanel, Provider<AutoLoginService> autoLoginServiceProvider, EventBean<FriendConnectionEvent> friendConnectionEventBean, Provider<HideTransferTrayAction> hideTransferTrayTrayActionProvider, Provider<ShowDownloadsTrayAction> showHideDownloadTrayAction, Provider<ShowUploadsTrayAction> uploadTrayActionProvider, Provider<ChatMediator> chatFrameProvider, Provider<ChangeLanguageAction> changeLanguageActionProvider, Provider<TransferTrayNavigator> transferTrayNavigator) {
        super(I18n.tr("&View"));
        this.friendsSignInPanelProvider = friendsSignInPanel;
        this.hideTransferTrayTrayActionProvider = hideTransferTrayTrayActionProvider;
        this.autoLoginServiceProvider = autoLoginServiceProvider;
        this.friendConnectionEventBean = friendConnectionEventBean;
        this.showDownloadsTrayActionProvider = showHideDownloadTrayAction;
        this.showUploadsTrayActionProvider = uploadTrayActionProvider;
        this.chatFrameProvider = chatFrameProvider;
        this.changeLanguageActionProvider = changeLanguageActionProvider;
        this.transferTrayNavigator = transferTrayNavigator;
    }

    @Override
    public void createMenuItems() {
        JCheckBoxMenuItem hideTransferTray = new JCheckBoxMenuItem(this.hideTransferTrayTrayActionProvider.get());
        JCheckBoxMenuItem showDownloads = new JCheckBoxMenuItem(this.showDownloadsTrayActionProvider.get());
        JCheckBoxMenuItem showUploads = new JCheckBoxMenuItem(this.showUploadsTrayActionProvider.get());
        boolean showTransfers = this.transferTrayNavigator.get().isTrayShowing();
        hideTransferTray.setSelected(!showTransfers);
        showDownloads.setSelected(showTransfers && this.transferTrayNavigator.get().isDownloadsSelected());
        showUploads.setSelected(showTransfers && this.transferTrayNavigator.get().isUploadsSelected());
        ButtonGroup group = new ButtonGroup();
        group.add(hideTransferTray);
        group.add(showDownloads);
        group.add(showUploads);
        this.add(this.buildShowHideChatWindowAction(this.chatFrameProvider));
        this.addSeparator();
        this.add(hideTransferTray);
        this.add(showDownloads);
        this.add(showUploads);
        this.addSeparator();
        this.add(this.changeLanguageActionProvider.get());
    }

    private boolean hasActiveConnection() {
        if (this.autoLoginServiceProvider.get().isAttemptingLogin()) {
            return true;
        }
        FriendConnection friendConnection = (FriendConnection)EventUtils.getSource(this.friendConnectionEventBean);
        if (friendConnection != null) {
            return friendConnection.isLoggedIn() || friendConnection.isLoggingIn();
        }
        return false;
    }

    private boolean isLoggingIn() {
        FriendConnection friendConnection = (FriendConnection)EventUtils.getSource(this.friendConnectionEventBean);
        return friendConnection != null && friendConnection.isLoggingIn();
    }

    private Action buildShowHideChatWindowAction(final Provider<ChatMediator> chatFrameProvider) {
        AbstractAction action = new AbstractAction(chatFrameProvider.get().isVisible() ? visibleText : notVisibleText){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!((ChatMediator)chatFrameProvider.get()).isVisible() && !ViewMenu.this.hasActiveConnection()) {
                    ((LoginPopupPanel)ViewMenu.this.friendsSignInPanelProvider.get()).setVisible(true);
                } else if (!((AutoLoginService)ViewMenu.this.autoLoginServiceProvider.get()).isAttemptingLogin() && !ViewMenu.this.isLoggingIn()) {
                    ((ChatMediator)chatFrameProvider.get()).setVisible(!((ChatMediator)chatFrameProvider.get()).isVisible());
                }
            }
        };
        return action;
    }
}

