/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.table;

import com.google.inject.Inject;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.ui.swing.library.navigator.LibraryNavItem;
import org.limewire.ui.swing.library.navigator.LibraryNavigatorPanel;
import org.limewire.ui.swing.library.table.RemoveButton;

class RemoveEditor
extends JPanel
implements TableCellEditor {
    private final List<CellEditorListener> listeners = new ArrayList<CellEditorListener>();
    private LocalFileItem currentEditingItem;

    @Inject
    public RemoveEditor(RemoveButton removeButton, final LibraryNavigatorPanel libraryNavigatorPanel) {
        this.add(removeButton);
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RemoveEditor.this.currentEditingItem != null) {
                    LibraryNavItem item = libraryNavigatorPanel.getSelectedNavItem();
                    item.getLocalFileList().removeFile(RemoveEditor.this.currentEditingItem.getFile());
                    RemoveEditor.this.currentEditingItem = null;
                }
                RemoveEditor.this.stopCellEditing();
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.currentEditingItem = value instanceof LocalFileItem ? (LocalFileItem)value : null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCellEditorListener(CellEditorListener lis) {
        List<CellEditorListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(lis)) {
                this.listeners.add(lis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelCellEditing() {
        List<CellEditorListener> list = this.listeners;
        synchronized (list) {
            int N = this.listeners.size();
            for (int i = 0; i < N; ++i) {
                this.listeners.get(i).editingCanceled(new ChangeEvent(this));
            }
        }
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCellEditorListener(CellEditorListener lis) {
        List<CellEditorListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(lis)) {
                this.listeners.remove(lis);
            }
        }
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stopCellEditing() {
        List<CellEditorListener> list = this.listeners;
        synchronized (list) {
            int N = this.listeners.size();
            for (int i = 0; i < N; ++i) {
                this.listeners.get(i).editingStopped(new ChangeEvent(this));
            }
        }
        return true;
    }
}

