/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.table;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.jdesktop.swingx.decorator.SortKey;
import org.jdesktop.swingx.decorator.SortOrder;
import org.limewire.core.api.Category;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.library.FileItem;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.core.api.library.PropertiableFile;
import org.limewire.ui.swing.library.table.AbstractLibraryFormat;
import org.limewire.ui.swing.settings.TablesHandler;
import org.limewire.ui.swing.table.ColumnStateInfo;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.IconManager;
import org.limewire.ui.swing.util.PropertiableFileUtils;

public class AllTableFormat<T extends LocalFileItem>
extends AbstractLibraryFormat<T> {
    static final int PLAY_INDEX = 0;
    static final int NAME_INDEX = 1;
    static final int TYPE_INDEX = 2;
    static final int SIZE_INDEX = 3;
    static final int HIT_INDEX = 4;
    static final int UPLOADS_INDEX = 5;
    static final int UPLOAD_ATTEMPTS_INDEX = 6;
    static final int PATH_INDEX = 7;
    static final int ACTION_INDEX = 8;
    private IconManager iconManager;

    @Inject
    public AllTableFormat(IconManager iconManager) {
        super(8, "LIBRARY_ALL_TABLE", 1, true, new ColumnStateInfo(0, "LIBRARY_ALL_PLAY", "", 16, 16, true, false), new ColumnStateInfo(1, "LIBRARY_ALL_NAME", I18n.tr("Name"), 480, true, true), new ColumnStateInfo(2, "LIBRARY_ALL_TYPE", I18n.tr("Type"), 230, true, true), new ColumnStateInfo(3, "LIBRARY_ALL_SIZE", I18n.tr("Size"), 60, false, true), new ColumnStateInfo(4, "LIBRARY_ALL_HITS", I18n.tr("Hits"), 100, false, true), new ColumnStateInfo(5, "LIBRARY_ALL_UPLOADS", I18n.tr("Uploads"), 100, false, true), new ColumnStateInfo(6, "LIBRARY_ALL_UPLOAD_ATTEMPTS", I18n.tr("Upload attempts"), 200, false, true), new ColumnStateInfo(7, "LIBRARY_ALL_PATH", I18n.tr("Location"), 200, false, true), new ColumnStateInfo(8, "LIBRARY_ALL_ACTION", I18n.tr(" "), 22, 22, true, false));
        this.iconManager = iconManager;
    }

    @Override
    public Object getColumnValue(T baseObject, int column) {
        switch (column) {
            case 0: {
                return baseObject;
            }
            case 1: {
                return baseObject;
            }
            case 3: {
                return baseObject.getSize();
            }
            case 2: {
                if (baseObject.getCategory() == Category.DOCUMENT || baseObject.getCategory() == Category.OTHER) {
                    String mime = this.iconManager.getMIMEDescription((PropertiableFile)baseObject);
                    if (mime != null) {
                        return I18n.tr(baseObject.getCategory().getSingularName()) + " (" + mime + ")";
                    }
                    return I18n.tr(baseObject.getCategory().getSingularName());
                }
                return I18n.tr(baseObject.getCategory().getSingularName());
            }
            case 4: {
                return baseObject.getNumHits();
            }
            case 6: {
                return baseObject.getNumUploadAttempts();
            }
            case 5: {
                return baseObject.getNumUploads();
            }
            case 7: {
                return baseObject.getProperty(FilePropertyKey.LOCATION);
            }
            case 8: {
                return baseObject;
            }
        }
        throw new IllegalArgumentException("Unknown column:" + column);
    }

    @Override
    public Class getColumnClass(int column) {
        switch (column) {
            case 0: 
            case 1: {
                return FileItem.class;
            }
        }
        return super.getColumnClass(column);
    }

    @Override
    public List<SortKey> getDefaultSortKeys() {
        if (TablesHandler.getSortedColumn(this.getSortOrderID(), this.getSortedColumn()).getValue() == this.getSortedColumn() && TablesHandler.getSortedOrder(this.getSortOrderID(), this.getSortOrder()).getValue() == this.getSortOrder()) {
            return Arrays.asList(new SortKey(SortOrder.ASCENDING, 1), new SortKey(SortOrder.ASCENDING, 2), new SortKey(SortOrder.ASCENDING, 3));
        }
        return super.getDefaultSortKeys();
    }

    @Override
    public List<Integer> getSecondarySortColumns(int column) {
        return Collections.emptyList();
    }

    @Override
    public Comparator getColumnComparator(int column) {
        switch (column) {
            case 1: {
                return new NameComparator();
            }
        }
        return super.getColumnComparator(column);
    }

    private class NameComparator
    implements Comparator<FileItem> {
        private NameComparator() {
        }

        @Override
        public int compare(FileItem o1, FileItem o2) {
            String title1 = this.getDisplayText((LocalFileItem)o1);
            String title2 = this.getDisplayText((LocalFileItem)o2);
            return title1.toLowerCase(Locale.US).compareTo(title2.toLowerCase(Locale.US));
        }

        private String getDisplayText(LocalFileItem item) {
            if (item.getCategory() == Category.AUDIO) {
                return PropertiableFileUtils.getNameProperty(item, true);
            }
            return item.getFileName();
        }
    }
}

