/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.friends.chat;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import org.limewire.core.api.library.SharedFileList;
import org.limewire.core.api.library.SharedFileListManager;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.friends.chat.ChatFrame;
import org.limewire.ui.swing.friends.chat.ChatFriend;
import org.limewire.ui.swing.friends.chat.ChatFriendList;
import org.limewire.ui.swing.library.LibraryMediator;
import org.limewire.ui.swing.library.ShareListIcons;
import org.limewire.ui.swing.search.FriendPresenceActions;
import org.limewire.ui.swing.util.I18n;

class ChatPopupMenu
extends JPopupMenu {
    private final Provider<FriendPresenceActions> remoteHostActions;
    private final Provider<SharedFileListManager> sharedFileListManager;
    private final Provider<LibraryMediator> library;
    private final Provider<ChatFrame> chatFrame;
    private final ChatFriend chatFriend;

    @Inject
    public ChatPopupMenu(Provider<ChatFriendList> chatFriendList, Provider<FriendPresenceActions> remoteHostActions, Provider<SharedFileListManager> sharedFileListManager, Provider<LibraryMediator> library, Provider<ChatFrame> chatFrame) {
        this.remoteHostActions = remoteHostActions;
        this.sharedFileListManager = sharedFileListManager;
        this.library = library;
        this.chatFrame = chatFrame;
        this.chatFriend = chatFriendList.get().getSelectedFriend();
        this.init();
    }

    private void init() {
        if (this.chatFriend.isChatting()) {
            this.add(this.createShareListSubMenu());
            this.addSeparator();
            this.add(new BrowseFiles());
            this.addSeparator();
            this.add(new CloseChat());
        } else {
            this.add(new OpenChat());
            this.addSeparator();
            this.add(this.createShareListSubMenu());
            this.addSeparator();
            this.add(new BrowseFiles());
        }
    }

    private JMenu createShareListSubMenu() {
        JMenu shareListMenu = new JMenu(I18n.tr("Share List"));
        for (SharedFileList list : this.sharedFileListManager.get().getModel()) {
            if (list.isPublic()) continue;
            shareListMenu.add(new AddRemoveCheckBoxMenuItem(this.chatFriend.getID(), list));
        }
        shareListMenu.addSeparator();
        shareListMenu.add(new ShareNewList());
        return shareListMenu;
    }

    private class AddRemoveCheckBoxMenuItem
    extends JCheckBoxMenuItem {
        public AddRemoveCheckBoxMenuItem(final String friendID, final SharedFileList shareList) {
            super(shareList.getCollectionName(), new ShareListIcons().getListIcon(shareList));
            this.setSelected(shareList.getFriendIds().contains(friendID));
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AddRemoveCheckBoxMenuItem.this.isSelected()) {
                        shareList.addFriend(friendID);
                    } else {
                        shareList.removeFriend(friendID);
                    }
                    AddRemoveCheckBoxMenuItem.this.setIcon(new ShareListIcons().getListIcon(shareList));
                }
            });
        }
    }

    private class ShareNewList
    extends AbstractAction {
        public ShareNewList() {
            super(I18n.tr("Share New List"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int id = ((SharedFileListManager)ChatPopupMenu.this.sharedFileListManager.get()).createNewSharedFileList(I18n.tr("Untitled"));
            for (SharedFileList list : ((SharedFileListManager)ChatPopupMenu.this.sharedFileListManager.get()).getModel()) {
                if (list.getId() != id) continue;
                list.addFriend(ChatPopupMenu.this.chatFriend.getID());
                ((LibraryMediator)ChatPopupMenu.this.library.get()).selectAndRenameSharedList(list);
            }
        }
    }

    private class OpenChat
    extends AbstractAction {
        public OpenChat() {
            super(I18n.tr("Open Conversation"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((ChatFrame)ChatPopupMenu.this.chatFrame.get()).selectOrStartConversation(ChatPopupMenu.this.chatFriend);
        }
    }

    private class CloseChat
    extends AbstractAction {
        public CloseChat() {
            super(I18n.tr("Close Conversation"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((ChatFrame)ChatPopupMenu.this.chatFrame.get()).closeConversation(ChatPopupMenu.this.chatFriend);
        }
    }

    class BrowseFiles
    extends AbstractAction {
        public BrowseFiles() {
            super(I18n.tr("Browse Files"));
            this.setEnabled(ChatPopupMenu.this.chatFriend.isSignedInToLimewire());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((FriendPresenceActions)ChatPopupMenu.this.remoteHostActions.get()).viewFriendLibrary(ChatPopupMenu.this.chatFriend.getFriend());
        }
    }
}

