/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.filter;

import ca.odell.glazedlists.matchers.Matcher;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.ui.swing.filter.FilterableItem;
import org.limewire.ui.swing.filter.RangeFilterFormat;
import org.limewire.ui.swing.util.I18n;
import org.limewire.util.CommonUtils;

class LengthFilterFormat<E extends FilterableItem>
implements RangeFilterFormat<E> {
    private static final long[] LENGTHS = new long[]{0L, 30L, 60L, 300L, 600L, 900L, 1800L, 3600L, 7200L, 14400L};

    LengthFilterFormat() {
    }

    @Override
    public String getHeaderText() {
        return I18n.tr("Length");
    }

    @Override
    public Matcher<E> getMatcher(long minValue, long maxValue) {
        return new LengthMatcher(minValue, maxValue);
    }

    @Override
    public long[] getValues() {
        return LENGTHS;
    }

    @Override
    public String getValueText(int valueIndex) {
        return CommonUtils.seconds2time(LENGTHS[valueIndex]);
    }

    @Override
    public boolean isMaximumAbsolute() {
        return false;
    }

    @Override
    public boolean isUpperLimitEnabled() {
        return true;
    }

    @Override
    public boolean updateValues(SearchCategory filterCategory, long lowerValue, long upperValue) {
        return false;
    }

    private static class LengthMatcher<E extends FilterableItem>
    implements Matcher<E> {
        private final long minLength;
        private final long maxLength;

        public LengthMatcher(long minLength, long maxLength) {
            this.minLength = minLength;
            this.maxLength = maxLength;
        }

        @Override
        public boolean matches(E item) {
            Object value = item.getProperty(FilePropertyKey.LENGTH);
            if (value instanceof Long) {
                long length = (Long)value;
                boolean minValid = this.minLength == LENGTHS[0] || length >= this.minLength;
                boolean maxValid = this.maxLength == LENGTHS[LENGTHS.length - 1] || length <= this.maxLength;
                return minValid && maxValid;
            }
            return false;
        }
    }
}

