/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.downloads;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.io.File;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadState;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.ui.swing.components.FocusJOptionPane;
import org.limewire.ui.swing.components.MultiLineLabel;
import org.limewire.ui.swing.player.PlayerUtils;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

public class DownloadItemUtils {
    @InspectablePrimitive(value="number of completed downloads launched", category=DataCategory.USAGE)
    private static volatile int downloadsLaunched = 0;

    private DownloadItemUtils() {
    }

    public static void launch(final DownloadItem downloadItem, final CategoryManager categoryManager) {
        assert (EventQueue.isDispatchThread());
        assert (downloadItem.isLaunchable());
        if (downloadItem.getState() == DownloadState.SCAN_FAILED || downloadItem.getState() == DownloadState.SCAN_FAILED_DOWNLOADING_DEFINITIONS) {
            String message = I18n.tr("This file has not been scanned for viruses.  Do you want to launch anyway?");
            int answer = FocusJOptionPane.showConfirmDialog(GuiUtils.getMainFrame(), new MultiLineLabel(message, 400), I18n.tr("Message"), 0, 3);
            if (answer != 0) {
                return;
            }
        }
        GuiUtils.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
        new SwingWorker<File, Void>(){

            @Override
            protected File doInBackground() throws Exception {
                return downloadItem.getLaunchableFile();
            }

            @Override
            protected void done() {
                GuiUtils.getMainFrame().setCursor(Cursor.getDefaultCursor());
                try {
                    File file = (File)this.get();
                    if (file != null) {
                        PlayerUtils.playOrLaunch(file, categoryManager);
                    }
                }
                catch (InterruptedException ignored) {
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        }.execute();
        if (downloadItem.getState() == DownloadState.DONE) {
            ++downloadsLaunched;
        }
    }
}

