/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.painter.BusyPainter;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.limewire.ui.swing.util.GuiUtils;

public class ColoredBusyLabel
extends JXBusyLabel {
    @Resource
    private Color lightGrey;
    @Resource
    private Color darkGrey;

    public ColoredBusyLabel(Dimension dimension) {
        super(dimension);
        GuiUtils.assignResources(this);
        this.setBusyPainter(null);
        this.getBusyPainter();
    }

    @Override
    protected BusyPainter createBusyPainter(final Dimension dim) {
        BusyPainter p = new BusyPainter(){

            @Override
            protected void init(Shape point, Shape trajectory, Color unused, Color unused2) {
                super.init(dim == null ? UIManagerExt.getShape("JXBusyLabel.pointShape") : this.getScaledCircularPoint(dim.height), dim == null ? UIManagerExt.getShape("JXBusyLabel.trajectoryShape") : 1.getScaledDefaultTrajectory(dim.height), ColoredBusyLabel.this.lightGrey, ColoredBusyLabel.this.darkGrey);
            }

            private Ellipse2D.Float getScaledCircularPoint(float height) {
                return new Ellipse2D.Float(0.0f, 0.0f, height / 5.0f, height / 5.0f);
            }
        };
        return p;
    }
}

