/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing;

import com.sun.jna.Callback;
import java.util.ArrayList;
import java.util.List;
import org.limewire.service.ErrorService;

public class UncaughtExceptionHandlerImpl
implements Thread.UncaughtExceptionHandler,
Callback.UncaughtExceptionHandler {
    private final List<StackTraceElement> notReported = new ArrayList<StackTraceElement>();

    public UncaughtExceptionHandlerImpl() {
        this.notReported.add(new StackTraceElement("javax.jmdns.DNSRecord", "suppressedBy", null, -1));
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        this.handleUncaughtException(thread.getName(), throwable);
    }

    @Override
    public void uncaughtException(Callback c, Throwable e) {
        this.handleUncaughtException(Thread.currentThread().getName(), e);
    }

    private void handleUncaughtException(String name, Throwable throwable) {
        StackTraceElement[] stackTraceElements;
        for (StackTraceElement stackTraceElement : stackTraceElements = throwable.getStackTrace()) {
            if (!this.matchesUnreported(stackTraceElement)) continue;
            throwable.printStackTrace();
            return;
        }
        ErrorService.error(throwable, "Uncaught thread error: " + name);
    }

    private boolean matchesUnreported(StackTraceElement stackTraceElement) {
        for (StackTraceElement notReportedStackTrace : this.notReported) {
            if (!this.matches(notReportedStackTrace, stackTraceElement)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(StackTraceElement filter, StackTraceElement element) {
        return filter.getClassName().equals(element.getClassName()) && filter.getMethodName().equals(element.getMethodName()) && (filter.getLineNumber() < 0 || filter.getLineNumber() == element.getLineNumber());
    }
}

